/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.CastingType;
import org.jetbrains.kotlin.fir.analysis.checkers.FirCastDiagnosticsHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.expressions.FirTypeOperatorCall;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeDynamicType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirCastOperatorsChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirTypeOperatorCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirTypeOperatorCallChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirCastOperatorsChecker
extends FirExpressionChecker<FirTypeOperatorCall> {
    @NotNull
    public static final FirCastOperatorsChecker INSTANCE = new FirCastOperatorsChecker();

    private FirCastOperatorsChecker() {
    }

    @Override
    public void check(@NotNull FirTypeOperatorCall expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        boolean isSafeAs;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        FirSession session = context2.getSession();
        FirExpression firstArgument = expression2.getArgumentList().getArguments().get(0);
        ConeKotlinType actualType = TypeExpansionUtilsKt.fullyExpandedType(FirTypeUtilsKt.getConeType(FirExpressionUtilKt.unwrapSmartcastExpression(firstArgument).getTypeRef()), session);
        FirTypeRef conversionTypeRef = expression2.getConversionTypeRef();
        ConeKotlinType targetType = TypeExpansionUtilsKt.fullyExpandedType(FirTypeUtilsKt.getConeType(conversionTypeRef), session);
        if (FirOperation.Companion.getTYPES().contains((Object)expression2.getOperation()) && targetType instanceof ConeDynamicType) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)conversionTypeRef.getSource(), FirErrors.INSTANCE.getDYNAMIC_NOT_ALLOWED(), (DiagnosticContext)context2, null, 8, null);
        }
        boolean bl = isSafeAs = expression2.getOperation() == FirOperation.SAFE_AS;
        if (expression2.getOperation() == FirOperation.AS || isSafeAs) {
            CastingType castType = FirCastDiagnosticsHelpersKt.checkCasting(actualType, targetType, isSafeAs, context2);
            if (castType == CastingType.Impossible) {
                if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.EnableDfaWarningsInK2)) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getCAST_NEVER_SUCCEEDS(), (DiagnosticContext)context2, null, 8, null);
                }
            } else if (castType == CastingType.Always) {
                if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.EnableDfaWarningsInK2)) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getUSELESS_CAST(), (DiagnosticContext)context2, null, 8, null);
                }
            } else if (FirCastDiagnosticsHelpersKt.isCastErased(actualType, targetType, context2)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getUNCHECKED_CAST(), (Object)actualType, (Object)targetType, (DiagnosticContext)context2, null, 32, null);
            }
        } else if (expression2.getOperation() == FirOperation.IS && !context2.isContractBody() && FirCastDiagnosticsHelpersKt.isCastErased(actualType, targetType, context2)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)conversionTypeRef.getSource(), FirErrors.INSTANCE.getCANNOT_CHECK_FOR_ERASED(), (Object)targetType, (DiagnosticContext)context2, null, 16, null);
        }
    }
}

