/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirMethodOfAnyImplementedInInterfaceChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.impl.FirDeclarationStatusImplKt;
import org.jetbrains.kotlin.fir.declarations.impl.FirOuterClassTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.impl.FirResolvedDeclarationStatusImpl;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.util.ListMultimap;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b\u001a\f\u0010\u001c\u001a\u00020\n*\u00020\u001dH\u0002\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\t\u001a\u00020\n*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u0018\u0010\u000e\u001a\u00020\n*\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010\"\u0018\u0010\u0011\u001a\u00020\n*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\r\u00a8\u0006\u001e"}, d2={"DEFAULT_STATUS_FOR_NORMAL_MAIN_FUNCTION", "Lorg/jetbrains/kotlin/fir/declarations/impl/FirResolvedDeclarationStatusImpl;", "getDEFAULT_STATUS_FOR_NORMAL_MAIN_FUNCTION", "()Lorg/jetbrains/kotlin/fir/declarations/impl/FirResolvedDeclarationStatusImpl;", "MAIN_FUNCTION_SHAPES", "", "", "NO_NAME_PROVIDED", "Lorg/jetbrains/kotlin/name/Name;", "hasMainFunctionStatus", "", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "getHasMainFunctionStatus", "(Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;)Z", "isTopLevel", "Lorg/jetbrains/kotlin/name/CallableId;", "(Lorg/jetbrains/kotlin/name/CallableId;)Z", "representsMainFunctionAllowingConflictingOverloads", "getRepresentsMainFunctionAllowingConflictingOverloads", "checkConflictingElements", "", "elements", "", "Lorg/jetbrains/kotlin/fir/FirElement;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "isCollectable", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "checkers"})
public final class FirConflictsHelpersKt {
    @NotNull
    private static final Name NO_NAME_PROVIDED;
    @NotNull
    private static final Set<String> MAIN_FUNCTION_SHAPES;
    @NotNull
    private static final FirResolvedDeclarationStatusImpl DEFAULT_STATUS_FOR_NORMAL_MAIN_FUNCTION;

    @NotNull
    public static final FirResolvedDeclarationStatusImpl getDEFAULT_STATUS_FOR_NORMAL_MAIN_FUNCTION() {
        return DEFAULT_STATUS_FOR_NORMAL_MAIN_FUNCTION;
    }

    private static final boolean getHasMainFunctionStatus(FirSimpleFunction $this$hasMainFunctionStatus) {
        Object object = FirDeclarationStatusImplKt.getModifiersRepresentation($this$hasMainFunctionStatus.getStatus());
        return Intrinsics.areEqual(object, FirDeclarationStatusImplKt.getModifiersRepresentation(DEFAULT_STATUS_FOR_NORMAL_MAIN_FUNCTION)) ? true : Intrinsics.areEqual(object, FirDeclarationStatusImplKt.getModifiersRepresentation(FirResolvedDeclarationStatusImpl.Companion.getDEFAULT_STATUS_FOR_SUSPEND_MAIN_FUNCTION()));
    }

    private static final boolean isTopLevel(CallableId $this$isTopLevel) {
        return $this$isTopLevel.getClassName() == null;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean getRepresentsMainFunctionAllowingConflictingOverloads(FirSimpleFunction $this$representsMainFunctionAllowingConflictingOverloads) {
        boolean bl;
        if (!(Intrinsics.areEqual($this$representsMainFunctionAllowingConflictingOverloads.getName(), StandardNames.MAIN) && FirConflictsHelpersKt.isTopLevel($this$representsMainFunctionAllowingConflictingOverloads.getSymbol().getCallableId()) && FirConflictsHelpersKt.getHasMainFunctionStatus($this$representsMainFunctionAllowingConflictingOverloads))) {
            bl = false;
        } else {
            void $this$_get_representsMainFunctionAllowingConflictingOverloads__u24lambda_u240;
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
            Set<String> set = MAIN_FUNCTION_SHAPES;
            boolean bl2 = false;
            FirMethodOfAnyImplementedInInterfaceChecker.INSTANCE.appendRepresentationBeforeCallableId((StringBuilder)$this$_get_representsMainFunctionAllowingConflictingOverloads__u24lambda_u240, $this$representsMainFunctionAllowingConflictingOverloads);
            FirMethodOfAnyImplementedInInterfaceChecker.INSTANCE.appendRepresentationAfterCallableId((StringBuilder)$this$_get_representsMainFunctionAllowingConflictingOverloads__u24lambda_u240, $this$representsMainFunctionAllowingConflictingOverloads);
            $this$_get_representsMainFunctionAllowingConflictingOverloads__u24lambda_u240.append(':');
            FirMethodOfAnyImplementedInInterfaceChecker.INSTANCE.appendRepresentation((StringBuilder)$this$_get_representsMainFunctionAllowingConflictingOverloads__u24lambda_u240, $this$representsMainFunctionAllowingConflictingOverloads.getReturnTypeRef());
            String string2 = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
            bl = set.contains(string2);
        }
        return bl;
    }

    private static final boolean isCollectable(FirDeclaration $this$isCollectable) {
        boolean bl;
        FirDeclaration firDeclaration = $this$isCollectable;
        if (firDeclaration instanceof FirSimpleFunction) {
            KtSourceElement ktSourceElement = $this$isCollectable.getSource();
            bl = !((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) && !Intrinsics.areEqual(((FirSimpleFunction)$this$isCollectable).getName(), NO_NAME_PROVIDED);
        } else if (firDeclaration instanceof FirProperty) {
            KtSourceElement ktSourceElement = $this$isCollectable.getSource();
            bl = !((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind.EnumGeneratedDeclaration);
        } else {
            bl = firDeclaration instanceof FirRegularClass ? !Intrinsics.areEqual(((FirRegularClass)$this$isCollectable).getName(), NO_NAME_PROVIDED) : true;
        }
        return bl;
    }

    public static final void checkConflictingElements(@NotNull List<? extends FirElement> elements, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (elements.size() <= 1) {
            return;
        }
        ListMultimap<Name, FirBasedSymbol> multimap = new ListMultimap<Name, FirBasedSymbol>();
        for (FirElement firElement : elements) {
            Name name2 = null;
            FirBasedSymbol symbol2 = null;
            FirElement firElement2 = firElement;
            if (firElement2 instanceof FirVariable) {
                symbol2 = ((FirVariable)firElement).getSymbol();
                name2 = ((FirVariable)firElement).getName();
            } else {
                if (firElement2 instanceof FirOuterClassTypeParameterRef) continue;
                if (firElement2 instanceof FirTypeParameterRef) {
                    symbol2 = ((FirTypeParameterRef)firElement).getSymbol();
                    name2 = ((FirTypeParameterSymbol)symbol2).getName();
                } else {
                    symbol2 = null;
                    name2 = null;
                }
            }
            Name name3 = name2;
            boolean bl = name3 != null ? !name3.isSpecial() : false;
            if (!bl) continue;
            FirBasedSymbol firBasedSymbol = symbol2;
            Intrinsics.checkNotNull(firBasedSymbol);
            multimap.put(name2, firBasedSymbol);
        }
        for (Name name4 : multimap.getKeys()) {
            List conflictingElements = (List)multimap.get(name4);
            if (conflictingElements.size() <= 1) continue;
            for (FirBasedSymbol conflictingElement : conflictingElements) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)conflictingElement.getSource(), FirErrors.INSTANCE.getREDECLARATION(), (Object)conflictingElements, (DiagnosticContext)context2, null, 16, null);
            }
        }
    }

    public static final /* synthetic */ boolean access$isCollectable(FirDeclaration $receiver) {
        return FirConflictsHelpersKt.isCollectable($receiver);
    }

    public static final /* synthetic */ boolean access$getRepresentsMainFunctionAllowingConflictingOverloads(FirSimpleFunction $receiver) {
        return FirConflictsHelpersKt.getRepresentsMainFunctionAllowingConflictingOverloads($receiver);
    }

    static {
        Name name2 = Name.special("<no name provided>");
        Intrinsics.checkNotNullExpressionValue(name2, "special(...)");
        NO_NAME_PROVIDED = name2;
        String[] stringArray = new String[]{"<>[]():kotlin/Unit", "<>[](kotlin/Array<kotlin/String,>,):kotlin/Unit", "<>[](vararg kotlin/String,):kotlin/Unit"};
        MAIN_FUNCTION_SHAPES = SetsKt.setOf(stringArray);
        DEFAULT_STATUS_FOR_NORMAL_MAIN_FUNCTION = FirResolvedDeclarationStatusImpl.Companion.getDEFAULT_STATUS_FOR_STATUSLESS_DECLARATIONS();
    }
}

