/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirConstChecksKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifier;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirConstPropertyChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirConstPropertyChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirConstPropertyChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirConstPropertyChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,70:1\n47#2:71\n*S KotlinDebug\n*F\n+ 1 FirConstPropertyChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirConstPropertyChecker\n*L\n27#1:71\n*E\n"})
public final class FirConstPropertyChecker
extends FirDeclarationChecker<FirProperty> {
    @NotNull
    public static final FirConstPropertyChecker INSTANCE = new FirConstPropertyChecker();

    private FirConstPropertyChecker() {
    }

    @Override
    public void check(@NotNull FirProperty declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        KtSourceElement source;
        ClassKind classKind2;
        Object it;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        FirMemberDeclaration $this$isConst$iv = declaration2;
        boolean $i$f$isConst = false;
        if (!$this$isConst$iv.getStatus().isConst()) {
            return;
        }
        if (declaration2.isVar()) {
            FirModifier<?> constModifier;
            FirElement firElement = declaration2;
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.CONST_KEYWORD;
            Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken, "CONST_KEYWORD");
            FirModifier<?> firModifier = constModifier = FirKeywordUtilsKt.getModifier(firElement, ktModifierKeywordToken);
            if (firModifier != null) {
                it = firModifier;
                boolean bl = false;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirModifier)it).getSource(), FirErrors.INSTANCE.getWRONG_MODIFIER_TARGET(), (Object)((FirModifier)it).getToken(), (Object)"vars", (DiagnosticContext)context2, null, 32, null);
            }
        }
        FirRegularClass firRegularClass = (it = CollectionsKt.lastOrNull(context2.getContainingDeclarations())) instanceof FirRegularClass ? (FirRegularClass)it : null;
        ClassKind classKind3 = classKind2 = firRegularClass != null ? firRegularClass.getClassKind() : null;
        if (classKind2 != ClassKind.OBJECT && context2.getContainingDeclarations().size() > 1) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirErrors.INSTANCE.getCONST_VAL_NOT_TOP_LEVEL_OR_OBJECT(), (DiagnosticContext)context2, null, 8, null);
            return;
        }
        FirPropertyAccessor firPropertyAccessor = declaration2.getGetter();
        KtSourceElement ktSourceElement = source = firPropertyAccessor != null ? firPropertyAccessor.getSource() : null;
        if (source != null && !(source.getKind() instanceof KtFakeSourceElementKind)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getCONST_VAL_WITH_GETTER(), (DiagnosticContext)context2, null, 8, null);
            return;
        }
        if (declaration2.getDelegate() != null) {
            FirExpression firExpression2 = declaration2.getDelegate();
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)(firExpression2 != null ? firExpression2.getSource() : null), FirErrors.INSTANCE.getCONST_VAL_WITH_DELEGATE(), (DiagnosticContext)context2, null, 8, null);
            return;
        }
        FirExpression initializer2 = declaration2.getInitializer();
        if (initializer2 == null) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirErrors.INSTANCE.getCONST_VAL_WITHOUT_INITIALIZER(), (DiagnosticContext)context2, null, 8, null);
            return;
        }
        ConeKotlinType type2 = TypeExpansionUtilsKt.fullyExpandedType(FirTypeUtilsKt.getConeType(declaration2.getReturnTypeRef()), context2.getSession());
        if (!(type2 instanceof ConeErrorType) && !FirConstChecksKt.canBeUsedForConstVal(type2)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirErrors.INSTANCE.getTYPE_CANT_BE_USED_FOR_CONST_VAL(), (Object)FirTypeUtilsKt.getConeType(declaration2.getReturnTypeRef()), (DiagnosticContext)context2, null, 16, null);
            return;
        }
        if (FirConstChecksKt.checkConstantArguments(initializer2, context2.getSession()) != null) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)initializer2.getSource(), FirErrors.INSTANCE.getCONST_VAL_WITH_NON_CONST_INITIALIZER(), (DiagnosticContext)context2, null, 8, null);
        }
    }
}

