/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.fir.FirSession;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.expressions.FirCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirOperation;
import ksp.org.jetbrains.kotlin.fir.expressions.FirTypeOperatorCall;
import ksp.org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import ksp.org.jetbrains.kotlin.fir.resolve.ScopeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import ksp.org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import ksp.org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutorByMapKt;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import ksp.org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import ksp.org.jetbrains.kotlin.fir.types.ConeErrorType;
import ksp.org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import ksp.org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import ksp.org.jetbrains.kotlin.fir.types.ConeStarProjection;
import ksp.org.jetbrains.kotlin.fir.types.ConeStubTypeForTypeVariableInSubtyping;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeVariable;
import ksp.org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import ksp.org.jetbrains.kotlin.fir.types.TypeUnificationKt;
import ksp.org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import ksp.org.jetbrains.kotlin.types.AbstractTypeChecker;
import ksp.org.jetbrains.kotlin.types.TypeCheckerState;
import ksp.org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import ksp.org.jetbrains.kotlin.types.model.RigidTypeMarker;
import ksp.org.jetbrains.kotlin.types.model.TypeCheckerProviderContext;
import ksp.org.jetbrains.kotlin.types.model.TypeSystemContextHelpersKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a'\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005R\u00020\u0002j\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0007\u001a'\u0010\b\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nR\u00020\u0002j\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u000b\u001a\n\u0010\f\u001a\u00020\u0001*\u00020\u0005\u001a'\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005R\u00020\u0002j\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0007\u001a1\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0000R\u00020\u0002j\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0014\u001a)\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0002R\u00020\u0002j\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\u0016"}, d2={"isCastErased", "", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "supertype", "Lksp/org/jetbrains/kotlin/fir/types/ConeKotlinType;", "subtype", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Z", "findStaticallyKnownSubtype", "subTypeClassSymbol", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;)Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "isNonReifiedTypeParameter", "isUpcast", "candidateType", "targetType", "isRefinementUseless", "lhsType", "expression", "Lksp/org/jetbrains/kotlin/fir/expressions/FirTypeOperatorCall;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/expressions/FirTypeOperatorCall;)Z", "isExactTypeCast", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirCastDiagnosticsHelpers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirCastDiagnosticsHelpers.kt\norg/jetbrains/kotlin/fir/analysis/checkers/FirCastDiagnosticsHelpersKt\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n*L\n1#1,229:1\n71#2:230\n1761#3,3:231\n1#4:234\n48#5:235\n*S KotlinDebug\n*F\n+ 1 FirCastDiagnosticsHelpers.kt\norg/jetbrains/kotlin/fir/analysis/checkers/FirCastDiagnosticsHelpersKt\n*L\n61#1:230\n61#1:231,3\n200#1:235\n*E\n"})
public final class FirCastDiagnosticsHelpersKt {
    public static final boolean isCastErased(@NotNull CheckerContext context2, @NotNull ConeKotlinType supertype, @NotNull ConeKotlinType subtype) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)supertype, (String)"supertype");
        Intrinsics.checkNotNullParameter((Object)subtype, (String)"subtype");
        ConeInferenceContext typeContext2 = TypeComponentsKt.getTypeContext(context2.getSession());
        boolean isNonReifiedTypeParameter = FirCastDiagnosticsHelpersKt.isNonReifiedTypeParameter(subtype);
        boolean isUpcast = FirCastDiagnosticsHelpersKt.isUpcast(context2, supertype, subtype);
        if (isNonReifiedTypeParameter && !isUpcast) {
            boolean nullableToDefinitelyNotNull;
            boolean bl2 = nullableToDefinitelyNotNull = !TypeUtilsKt.canBeNull(subtype, context2.getSession()) && Intrinsics.areEqual((Object)TypeUtilsKt.withNullability$default(supertype, false, typeContext2, null, false, 12, null), (Object)subtype);
            if (!nullableToDefinitelyNotNull) {
                return true;
            }
        }
        if (!(supertype instanceof ConeErrorType) && ConeTypeUtilsKt.isMarkedNullable(supertype) || !(subtype instanceof ConeErrorType) && ConeTypeUtilsKt.isMarkedNullable(subtype)) {
            return FirCastDiagnosticsHelpersKt.isCastErased(context2, TypeUtilsKt.withNullability$default(supertype, false, typeContext2, null, false, 12, null), TypeUtilsKt.withNullability$default(subtype, false, typeContext2, null, false, 12, null));
        }
        if (isUpcast) {
            return false;
        }
        if (isNonReifiedTypeParameter) {
            return true;
        }
        if (subtype instanceof ConeTypeParameterType) {
            return false;
        }
        FirRegularClassSymbol firRegularClassSymbol = ToSymbolUtilsKt.toRegularClassSymbol(subtype, context2.getSession());
        if (firRegularClassSymbol == null) {
            return true;
        }
        FirRegularClassSymbol regularClassSymbol = firRegularClassSymbol;
        Set<FirClassLikeSymbol<?>> outerClasses = LookupTagUtilsKt.getClassAndItsOuterClassesWhenLocal(regularClassSymbol, context2.getSession());
        FirClassLikeSymbol $this$isLocal$iv = regularClassSymbol;
        boolean $i$f$isLocal = false;
        if ($this$isLocal$iv.getClassId().isLocal()) {
            boolean bl3;
            block12: {
                Iterable $this$any$iv = regularClassSymbol.getTypeParameterSymbols();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl3 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirTypeParameterSymbol it = (FirTypeParameterSymbol)element$iv;
                        boolean bl4 = false;
                        if (!(!CollectionsKt.contains((Iterable)outerClasses, it.getContainingDeclarationSymbol()))) continue;
                        bl3 = true;
                        break block12;
                    }
                    bl3 = false;
                }
            }
            if (bl3) {
                return true;
            }
        }
        ConeKotlinType staticallyKnownSubtype = FirCastDiagnosticsHelpersKt.findStaticallyKnownSubtype(context2, supertype, regularClassSymbol);
        return !AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, TypeComponentsKt.getTypeContext(context2.getSession()).newTypeCheckerState(true, false, false), (KotlinTypeMarker)staticallyKnownSubtype, (KotlinTypeMarker)subtype, false, 8, null);
    }

    @NotNull
    public static final ConeKotlinType findStaticallyKnownSubtype(@NotNull CheckerContext context2, @NotNull ConeKotlinType supertype, @NotNull FirRegularClassSymbol subTypeClassSymbol) {
        Collection collection;
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)supertype, (String)"supertype");
        Intrinsics.checkNotNullParameter((Object)subTypeClassSymbol, (String)"subTypeClassSymbol");
        boolean bl3 = bl2 = !ConeTypeUtilsKt.isMarkedNullable(supertype);
        if (_Assertions.ENABLED && !bl2) {
            boolean $i$a$-assert-FirCastDiagnosticsHelpersKt$findStaticallyKnownSubtype$22 = false;
            String $i$a$-assert-FirCastDiagnosticsHelpersKt$findStaticallyKnownSubtype$22 = "This method only makes sense for non-nullable types";
            throw new AssertionError((Object)$i$a$-assert-FirCastDiagnosticsHelpersKt$findStaticallyKnownSubtype$22);
        }
        FirSession session = context2.getSession();
        ConeInferenceContext typeContext2 = TypeComponentsKt.getTypeContext(session);
        if (supertype instanceof ConeClassLikeType && Intrinsics.areEqual(ToSymbolUtilsKt.toSymbol((ConeClassLikeType)supertype, session), (Object)subTypeClassSymbol)) {
            return supertype;
        }
        ConeClassLikeType subtypeWithVariablesType = ScopeUtilsKt.defaultType(subTypeClassSymbol);
        TypeCheckerState typeCheckerState = TypeCheckerProviderContext.newTypeCheckerState$default(TypeComponentsKt.getTypeContext(context2.getSession()), false, false, false, 4, null);
        if (supertype instanceof ConeIntersectionType) {
            collection = ((ConeIntersectionType)supertype).getIntersectedTypes();
        } else {
            ArrayList<ConeKotlinType> arrayList = new ArrayList<ConeKotlinType>(1);
            ArrayList<ConeKotlinType> it = arrayList;
            boolean bl4 = false;
            it.add(supertype);
            collection = arrayList;
        }
        Collection normalizedTypes = collection;
        Map resultSubstitution = new LinkedHashMap();
        for (ConeKotlinType normalizedType : normalizedTypes) {
            Map map;
            RigidTypeMarker supertypeWithVariables = (RigidTypeMarker)CollectionsKt.firstOrNull(AbstractTypeChecker.INSTANCE.findCorrespondingSupertypes(typeCheckerState, subtypeWithVariablesType, TypeSystemContextHelpersKt.typeConstructor(normalizedType, typeContext2)));
            List<FirTypeParameterSymbol> variables2 = subTypeClassSymbol.getTypeParameterSymbols();
            if (supertypeWithVariables != null) {
                Map result2 = new LinkedHashMap();
                map = TypeUnificationKt.doUnify(context2.getSession(), supertype, (ConeKotlinTypeProjection)((Object)supertypeWithVariables), CollectionsKt.toSet((Iterable)variables2), result2) ? result2 : (Map)new LinkedHashMap();
            } else {
                map = new LinkedHashMap();
            }
            Map substitution = map;
            for (FirTypeParameterSymbol variable : variables2) {
                ConeTypeProjection value2 = (ConeTypeProjection)substitution.get(variable);
                ConeKotlinType resultValue = value2 == null ? null : (value2 instanceof ConeStarProjection ? (ConeKotlinType)new ConeStubTypeForTypeVariableInSubtyping(new ConeTypeVariable("", null), true) : ConeTypeProjectionKt.getType(value2));
                if (resultValue == null) continue;
                resultSubstitution.put(variable, resultValue);
            }
        }
        ConeSubstitutor substitutor2 = ConeSubstitutorByMapKt.substitutorByMap$default(resultSubstitution, session, false, 4, null);
        return substitutor2.substituteOrSelf(subtypeWithVariablesType);
    }

    public static final boolean isNonReifiedTypeParameter(@NotNull ConeKotlinType $this$isNonReifiedTypeParameter) {
        Intrinsics.checkNotNullParameter((Object)$this$isNonReifiedTypeParameter, (String)"<this>");
        return $this$isNonReifiedTypeParameter instanceof ConeTypeParameterType && !((ConeTypeParameterType)$this$isNonReifiedTypeParameter).getLookupTag().getTypeParameterSymbol().isReified();
    }

    public static final boolean isUpcast(@NotNull CheckerContext context2, @NotNull ConeKotlinType candidateType, @NotNull ConeKotlinType targetType) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)candidateType, (String)"candidateType");
        Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
        return AbstractTypeChecker.INSTANCE.isSubtypeOf(TypeComponentsKt.getTypeContext(context2.getSession()), (KotlinTypeMarker)candidateType, (KotlinTypeMarker)targetType, false);
    }

    public static final boolean isRefinementUseless(@NotNull CheckerContext context2, @NotNull ConeKotlinType lhsType, @NotNull ConeKotlinType targetType, @NotNull FirTypeOperatorCall expression2) {
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)lhsType, (String)"lhsType");
        Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (lhsType instanceof ConeErrorType || targetType instanceof ConeErrorType) {
            return false;
        }
        FirCall $this$argument$iv = expression2;
        boolean $i$f$getArgument = false;
        FirExpression arg = (FirExpression)CollectionsKt.first($this$argument$iv.getArgumentList().getArguments());
        switch (WhenMappings.$EnumSwitchMapping$0[expression2.getOperation().ordinal()]) {
            case 1: 
            case 2: {
                if (arg instanceof FirFunctionCall) {
                    FirFunctionSymbol functionSymbol;
                    FirCallableSymbol<?> firCallableSymbol = ReferenceUtilsKt.toResolvedCallableSymbol(arg, context2.getSession());
                    FirFunctionSymbol firFunctionSymbol = functionSymbol = firCallableSymbol instanceof FirFunctionSymbol ? (FirFunctionSymbol)firCallableSymbol : null;
                    if (functionSymbol != null && FirHelpersKt.isFunctionForExpectTypeFromCastFeature(functionSymbol)) {
                        return false;
                    }
                }
                ConeKotlinType refinedTargetType = expression2.getOperation() == FirOperation.SAFE_AS && ConeTypeUtilsKt.isMarkedOrFlexiblyNullable(lhsType) ? TypeUtilsKt.withNullability$default(targetType, true, TypeComponentsKt.getTypeContext(context2.getSession()), null, false, 12, null) : targetType;
                bl2 = FirCastDiagnosticsHelpersKt.isExactTypeCast(context2, lhsType, refinedTargetType);
                break;
            }
            case 3: 
            case 4: {
                bl2 = FirCastDiagnosticsHelpersKt.isUpcast(context2, lhsType, targetType);
                break;
            }
            default: {
                throw new AssertionError((Object)("Should not be here: " + (Object)((Object)expression2.getOperation())));
            }
        }
        return bl2;
    }

    private static final boolean isExactTypeCast(CheckerContext context2, ConeKotlinType lhsType, ConeKotlinType targetType) {
        return AbstractTypeChecker.equalTypes$default(AbstractTypeChecker.INSTANCE, TypeComponentsKt.getTypeContext(context2.getSession()), lhsType, targetType, false, false, 16, null);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FirOperation.values().length];
            try {
                nArray[FirOperation.AS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirOperation.SAFE_AS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirOperation.IS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirOperation.NOT_IS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

