/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.util;

import java.util.ArrayList;
import java.util.List;
import ksp.com.intellij.openapi.util.Comparing;
import ksp.com.intellij.psi.PsiCaseLabelElement;
import ksp.com.intellij.psi.PsiCaseLabelElementList;
import ksp.com.intellij.psi.PsiClass;
import ksp.com.intellij.psi.PsiCodeBlock;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiExpression;
import ksp.com.intellij.psi.PsiPattern;
import ksp.com.intellij.psi.PsiStatement;
import ksp.com.intellij.psi.PsiSwitchBlock;
import ksp.com.intellij.psi.PsiSwitchExpression;
import ksp.com.intellij.psi.PsiSwitchLabelStatementBase;
import ksp.com.intellij.psi.PsiType;
import ksp.com.intellij.psi.util.PsiUtil;
import ksp.com.intellij.psi.util.TypeConversionUtil;
import ksp.com.intellij.util.containers.ContainerUtil;
import ksp.org.jetbrains.annotations.NotNull;

public final class JavaPsiSwitchUtil {
    public static boolean isEnhancedSwitch(@NotNull PsiSwitchBlock statement) {
        if (statement == null) {
            JavaPsiSwitchUtil.$$$reportNull$$$0(0);
        }
        if (statement instanceof PsiSwitchExpression) {
            return true;
        }
        PsiExpression selector = statement.getExpression();
        if (selector == null) {
            return false;
        }
        PsiType selectorType = selector.getType();
        if (selectorType == null) {
            return false;
        }
        PsiCodeBlock body = statement.getBody();
        if (body == null) {
            return false;
        }
        ArrayList<PsiCaseLabelElement> cases = new ArrayList<PsiCaseLabelElement>();
        for (PsiStatement psiStatement : body.getStatements()) {
            PsiCaseLabelElement[] elements;
            PsiSwitchLabelStatementBase labelStatementBase;
            PsiCaseLabelElementList elementList;
            if (!(psiStatement instanceof PsiSwitchLabelStatementBase) || (elementList = (labelStatementBase = (PsiSwitchLabelStatementBase)psiStatement).getCaseLabelElementList()) == null) continue;
            for (PsiCaseLabelElement caseLabelElement : elements = elementList.getElements()) {
                if (caseLabelElement == null) continue;
                cases.add(caseLabelElement);
            }
        }
        return JavaPsiSwitchUtil.isEnhancedSwitch(cases, JavaPsiSwitchUtil.isClassSelectorType(selectorType));
    }

    public static boolean isEnhancedSwitch(@NotNull List<? extends PsiCaseLabelElement> labelElements, boolean selectorIsTypeOrClass) {
        if (labelElements == null) {
            JavaPsiSwitchUtil.$$$reportNull$$$0(1);
        }
        if (selectorIsTypeOrClass) {
            return true;
        }
        return ContainerUtil.exists(labelElements, st -> st instanceof PsiPattern || JavaPsiSwitchUtil.isNullType(st));
    }

    private static boolean isNullType(@NotNull PsiElement element2) {
        if (element2 == null) {
            JavaPsiSwitchUtil.$$$reportNull$$$0(2);
        }
        return element2 instanceof PsiExpression && TypeConversionUtil.isNullType(((PsiExpression)element2).getType());
    }

    private static boolean isClassSelectorType(@NotNull PsiType type2) {
        if (type2 == null) {
            JavaPsiSwitchUtil.$$$reportNull$$$0(3);
        }
        if (TypeConversionUtil.getTypeRank(type2) <= 4) {
            return false;
        }
        if (TypeConversionUtil.isPrimitiveAndNotNull(type2)) {
            return false;
        }
        PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly(type2);
        if (psiClass != null) {
            if (psiClass.isEnum()) {
                return false;
            }
            String fqn = psiClass.getQualifiedName();
            if (Comparing.strEqual(fqn, "java.lang.String")) {
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labelElements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "ksp/com/intellij/psi/util/JavaPsiSwitchUtil";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnhancedSwitch";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isNullType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isClassSelectorType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

