/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.impl.source.resolve;

import ksp.com.intellij.openapi.util.Key;
import ksp.com.intellij.pom.java.LanguageLevel;
import ksp.com.intellij.psi.JavaCodeFragment;
import ksp.com.intellij.psi.JavaPsiFacade;
import ksp.com.intellij.psi.JavaResolveResult;
import ksp.com.intellij.psi.PsiArrayType;
import ksp.com.intellij.psi.PsiClass;
import ksp.com.intellij.psi.PsiClassType;
import ksp.com.intellij.psi.PsiDeclarationStatement;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiElementFactory;
import ksp.com.intellij.psi.PsiExpression;
import ksp.com.intellij.psi.PsiField;
import ksp.com.intellij.psi.PsiFile;
import ksp.com.intellij.psi.PsiJavaCodeReferenceElement;
import ksp.com.intellij.psi.PsiMember;
import ksp.com.intellij.psi.PsiModifierListOwner;
import ksp.com.intellij.psi.PsiSubstitutor;
import ksp.com.intellij.psi.PsiType;
import ksp.com.intellij.psi.PsiTypeParameter;
import ksp.com.intellij.psi.PsiVariable;
import ksp.com.intellij.psi.ResolveState;
import ksp.com.intellij.psi.filters.ElementFilter;
import ksp.com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import ksp.com.intellij.psi.infos.CandidateInfo;
import ksp.com.intellij.psi.scope.ElementClassFilter;
import ksp.com.intellij.psi.scope.ElementClassHint;
import ksp.com.intellij.psi.scope.JavaScopeProcessorEvent;
import ksp.com.intellij.psi.scope.PsiConflictResolver;
import ksp.com.intellij.psi.scope.PsiScopeProcessor;
import ksp.com.intellij.psi.scope.conflictResolvers.JavaVariableConflictResolver;
import ksp.com.intellij.psi.scope.processor.ConflictFilterProcessor;
import ksp.com.intellij.psi.util.PsiUtil;
import ksp.com.intellij.util.SmartList;
import ksp.org.jetbrains.annotations.NotNull;

public class VariableResolverProcessor
extends ConflictFilterProcessor
implements ElementClassHint {
    private static final ElementFilter ourFilter = ElementClassFilter.VARIABLE;
    @NotNull
    private StaticScope myStaticScopeFlag;
    private final PsiClass myAccessClass;
    private PsiElement myCurrentFileContext;

    public VariableResolverProcessor(@NotNull PsiJavaCodeReferenceElement place, @NotNull PsiFile placeFile) {
        if (place == null) {
            VariableResolverProcessor.$$$reportNull$$$0(0);
        }
        if (placeFile == null) {
            VariableResolverProcessor.$$$reportNull$$$0(1);
        }
        super(place.getReferenceName(), ourFilter, new PsiConflictResolver[]{new JavaVariableConflictResolver()}, new SmartList<CandidateInfo>(), place, placeFile);
        this.myStaticScopeFlag = StaticScope.NON_STATIC;
        PsiClass access = null;
        PsiElement qualifier2 = place.getQualifier();
        if (qualifier2 instanceof PsiExpression) {
            JavaResolveResult accessClass = PsiUtil.getAccessObjectClass((PsiExpression)qualifier2);
            PsiElement element2 = accessClass.getElement();
            if (element2 instanceof PsiTypeParameter) {
                PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(placeFile.getProject());
                PsiClassType type2 = factory2.createType((PsiTypeParameter)element2);
                PsiType accessType = accessClass.getSubstitutor().substitute(type2);
                if (accessType instanceof PsiArrayType) {
                    LanguageLevel languageLevel = PsiUtil.getLanguageLevel(placeFile);
                    access = factory2.getArrayClass(languageLevel);
                } else if (accessType instanceof PsiClassType) {
                    access = ((PsiClassType)accessType).resolve();
                }
            } else if (element2 instanceof PsiClass) {
                access = (PsiClass)element2;
            }
        }
        this.myAccessClass = access;
    }

    @Override
    protected boolean stopAtFoundResult(@NotNull JavaResolveResult cachedResult) {
        if (cachedResult == null) {
            VariableResolverProcessor.$$$reportNull$$$0(2);
        }
        if (super.stopAtFoundResult(cachedResult)) {
            PsiElement element2;
            JavaCodeFragment.VisibilityChecker visibilityChecker;
            if (this.myPlaceFile instanceof JavaCodeFragment && (visibilityChecker = ((JavaCodeFragment)this.myPlaceFile).getVisibilityChecker()) != null && (element2 = cachedResult.getElement()) instanceof PsiMember) {
                PsiMember member = (PsiMember)element2;
                return JavaResolveUtil.isAccessible(member, member.getContainingClass(), member.getModifierList(), this.myPlace, this.myAccessClass, cachedResult.getCurrentFileResolveScope(), null);
            }
            return true;
        }
        return false;
    }

    @Override
    public final void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
        if (event == null) {
            VariableResolverProcessor.$$$reportNull$$$0(3);
        }
        super.handleEvent(event, associated);
        if (JavaScopeProcessorEvent.isEnteringStaticScope(event, associated)) {
            if (this.myStaticScopeFlag != StaticScope.STATIC_NO_CONSTANTS) {
                this.myStaticScopeFlag = associated instanceof PsiClass && ((PsiClass)associated).getParent() instanceof PsiDeclarationStatement ? StaticScope.STATIC_NO_CONSTANTS : StaticScope.STATIC;
            }
        } else if (JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT.equals(event)) {
            this.myCurrentFileContext = (PsiElement)associated;
        }
    }

    @Override
    public void add(@NotNull PsiElement element2, @NotNull PsiSubstitutor substitutor2) {
        if (element2 == null) {
            VariableResolverProcessor.$$$reportNull$$$0(4);
        }
        if (substitutor2 == null) {
            VariableResolverProcessor.$$$reportNull$$$0(5);
        }
        boolean staticProblem = this.isStaticProblem(element2);
        this.add(new CandidateInfo(element2, substitutor2, this.myPlace, this.myAccessClass, staticProblem, this.myCurrentFileContext));
    }

    private boolean isStaticProblem(@NotNull PsiElement element2) {
        if (element2 == null) {
            VariableResolverProcessor.$$$reportNull$$$0(6);
        }
        if (this.myStaticScopeFlag == StaticScope.NON_STATIC || ((PsiModifierListOwner)element2).hasModifierProperty("static")) {
            return false;
        }
        if (element2 instanceof PsiField) {
            return true;
        }
        return this.myStaticScopeFlag != StaticScope.STATIC || !(element2 instanceof PsiVariable) || !PsiUtil.isCompileTimeConstant((PsiVariable)element2);
    }

    @Override
    public boolean shouldProcess(@NotNull ElementClassHint.DeclarationKind kind) {
        if (kind == null) {
            VariableResolverProcessor.$$$reportNull$$$0(7);
        }
        return kind == ElementClassHint.DeclarationKind.VARIABLE || kind == ElementClassHint.DeclarationKind.FIELD || kind == ElementClassHint.DeclarationKind.ENUM_CONST;
    }

    @Override
    public boolean execute(@NotNull PsiElement element2, @NotNull ResolveState state) {
        if (element2 == null) {
            VariableResolverProcessor.$$$reportNull$$$0(8);
        }
        if (state == null) {
            VariableResolverProcessor.$$$reportNull$$$0(9);
        }
        if (!(element2 instanceof PsiField) && (this.myName == null || PsiUtil.checkName(element2, this.myName, this.myPlace))) {
            super.execute(element2, state);
            return this.myResults.isEmpty();
        }
        return super.execute(element2, state);
    }

    @Override
    public <T> T getHint(@NotNull Key<T> hintKey) {
        if (hintKey == null) {
            VariableResolverProcessor.$$$reportNull$$$0(10);
        }
        if (hintKey == ElementClassHint.KEY) {
            return (T)this;
        }
        return super.getHint(hintKey);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cachedResult";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hintKey";
                break;
            }
        }
        objectArray2[1] = "ksp/com/intellij/psi/impl/source/resolve/VariableResolverProcessor";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "stopAtFoundResult";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "handleEvent";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "add";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isStaticProblem";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldProcess";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getHint";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static enum StaticScope {
        NON_STATIC,
        STATIC,
        STATIC_NO_CONSTANTS;

    }
}

