/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.backend;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.fir.backend.Fir2IrBuiltinSymbolsContainer;
import ksp.org.jetbrains.kotlin.ir.InternalSymbolFinderAPI;
import ksp.org.jetbrains.kotlin.ir.SymbolFinder;
import ksp.org.jetbrains.kotlin.ir.declarations.IrProperty;
import ksp.org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import ksp.org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import ksp.org.jetbrains.kotlin.ir.util.IrUtilsKt;
import ksp.org.jetbrains.kotlin.name.CallableId;
import ksp.org.jetbrains.kotlin.name.ClassId;
import ksp.org.jetbrains.kotlin.name.Name;

@InternalSymbolFinderAPI
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\u0010H\u0016J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lksp/org/jetbrains/kotlin/fir/backend/SymbolFinderOverFir;", "Lksp/org/jetbrains/kotlin/ir/SymbolFinder;", "fir2irBuiltins", "Lksp/org/jetbrains/kotlin/fir/backend/Fir2IrBuiltinSymbolsContainer;", "<init>", "(Lorg/jetbrains/kotlin/fir/backend/Fir2IrBuiltinSymbolsContainer;)V", "findClass", "Lksp/org/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "classId", "Lksp/org/jetbrains/kotlin/name/ClassId;", "findFunctions", "", "Lksp/org/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "callableId", "Lksp/org/jetbrains/kotlin/name/CallableId;", "findProperties", "Lksp/org/jetbrains/kotlin/ir/symbols/IrPropertySymbol;", "findGetter", "property", "findBuiltInClassMemberFunctions", "builtInClass", "name", "Lksp/org/jetbrains/kotlin/name/Name;", "fir2ir"})
public final class SymbolFinderOverFir
extends SymbolFinder {
    @NotNull
    private final Fir2IrBuiltinSymbolsContainer fir2irBuiltins;

    public SymbolFinderOverFir(@NotNull Fir2IrBuiltinSymbolsContainer fir2irBuiltins) {
        Intrinsics.checkNotNullParameter((Object)fir2irBuiltins, (String)"fir2irBuiltins");
        this.fir2irBuiltins = fir2irBuiltins;
    }

    @Override
    @Nullable
    public IrClassSymbol findClass(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        return this.fir2irBuiltins.loadClassSafe$fir2ir(classId);
    }

    @Override
    @NotNull
    public Iterable<IrSimpleFunctionSymbol> findFunctions(@NotNull CallableId callableId) {
        Intrinsics.checkNotNullParameter((Object)callableId, (String)"callableId");
        return this.fir2irBuiltins.findFunctions$fir2ir(callableId);
    }

    @Override
    @NotNull
    public Iterable<IrPropertySymbol> findProperties(@NotNull CallableId callableId) {
        Intrinsics.checkNotNullParameter((Object)callableId, (String)"callableId");
        return this.fir2irBuiltins.findProperties$fir2ir(callableId);
    }

    @Override
    @Nullable
    public IrSimpleFunctionSymbol findGetter(@NotNull IrPropertySymbol property2) {
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        IrSimpleFunction irSimpleFunction = ((IrProperty)property2.getOwner()).getGetter();
        return irSimpleFunction != null ? irSimpleFunction.getSymbol() : null;
    }

    @Override
    @NotNull
    public Iterable<IrSimpleFunctionSymbol> findBuiltInClassMemberFunctions(@NotNull IrClassSymbol builtInClass, @NotNull Name name2) {
        Intrinsics.checkNotNullParameter((Object)builtInClass, (String)"builtInClass");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return SequencesKt.asIterable((Sequence)SequencesKt.filter(IrUtilsKt.getFunctions(builtInClass), arg_0 -> SymbolFinderOverFir.findBuiltInClassMemberFunctions$lambda$0(name2, arg_0)));
    }

    private static final boolean findBuiltInClassMemberFunctions$lambda$0(Name $name, IrSimpleFunctionSymbol it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)((IrSimpleFunction)it.getOwner()).getName(), (Object)$name);
    }
}

