/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.backend.jvm.lower;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.backend.common.FileLoweringPass;
import ksp.org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import ksp.org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import ksp.org.jetbrains.kotlin.backend.jvm.lower.JvmLocalDeclarationsLowering;
import ksp.org.jetbrains.kotlin.backend.jvm.lower.PropertyReferenceDelegationLowering;
import ksp.org.jetbrains.kotlin.ir.IrStatement;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFile;
import ksp.org.jetbrains.kotlin.ir.declarations.IrParameterKind;
import ksp.org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import ksp.org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import ksp.org.jetbrains.kotlin.ir.expressions.IrCall;
import ksp.org.jetbrains.kotlin.ir.expressions.IrExpression;
import ksp.org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import ksp.org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import ksp.org.jetbrains.kotlin.ir.visitors.IrTransformer;

@PhaseDescription(name="MakePropertyDelegateMethodsStatic", prerequisite={PropertyReferenceDelegationLowering.class, JvmLocalDeclarationsLowering.class})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0001\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0010H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0017"}, d2={"Lksp/org/jetbrains/kotlin/backend/jvm/lower/MakePropertyDelegateMethodsStaticLowering;", "Lksp/org/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "Lksp/org/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lksp/org/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irFile", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFile;", "visitSimpleFunction", "Lksp/org/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lksp/org/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "visitCall", "Lksp/org/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lksp/org/jetbrains/kotlin/ir/expressions/IrCall;", "isSyntheticDelegateMethod", "", "backend.jvm.lower"})
public final class MakePropertyDelegateMethodsStaticLowering
extends IrElementTransformerVoid
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public MakePropertyDelegateMethodsStaticLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        irFile.transform((IrTransformer)this, (Object)null);
    }

    @Override
    @NotNull
    public IrStatement visitSimpleFunction(@NotNull IrSimpleFunction declaration2) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            if (!this.isSyntheticDelegateMethod(declaration2)) break block1;
            IrValueParameter irValueParameter = declaration2.getDispatchReceiverParameter();
            if (irValueParameter != null) {
                irValueParameter.setKind(IrParameterKind.Regular);
            }
        }
        return super.visitSimpleFunction(declaration2);
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (this.isSyntheticDelegateMethod((IrSimpleFunction)expression2.getSymbol().getOwner())) {
            throw new IllegalStateException(("`$delegate` method should not be called. Please either remove the call, or support remapping of dispatch receiver in MakePropertyDelegateMethodsStaticLowering: " + RenderIrElementKt.render$default(expression2.getSymbol().getOwner(), null, 1, null)).toString());
        }
        return super.visitCall(expression2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSyntheticDelegateMethod(IrSimpleFunction $this$isSyntheticDelegateMethod) {
        if (!Intrinsics.areEqual((Object)$this$isSyntheticDelegateMethod.getOrigin(), (Object)IrDeclarationOrigin.Companion.getPROPERTY_DELEGATE())) return false;
        String string = $this$isSyntheticDelegateMethod.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        if (!StringsKt.endsWith$default((String)string, (String)"$delegate", (boolean)false, (int)2, null)) return false;
        return true;
    }
}

