/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import ksp.org.jetbrains.kotlin.fir.SessionHolder;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirMissingDependencySupertypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import ksp.org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import ksp.org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import ksp.org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousFunctionSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import ksp.org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypesKt;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.utils.SmartSet;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencySupertypeInQualifiedAccessExpressionsChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "<init>", "()V", "check", "", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;)V", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirMissingDependencySupertypeInQualifiedAccessExpressionsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirMissingDependencySupertypeInQualifiedAccessExpressionsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencySupertypeInQualifiedAccessExpressionsChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,63:1\n1#2:64\n*E\n"})
public final class FirMissingDependencySupertypeInQualifiedAccessExpressionsChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirMissingDependencySupertypeInQualifiedAccessExpressionsChecker INSTANCE = new FirMissingDependencySupertypeInQualifiedAccessExpressionsChecker();

    private FirMissingDependencySupertypeInQualifiedAccessExpressionsChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirQualifiedAccessExpression expression2) {
        FirClassifierSymbol<?> receiverSymbol;
        FirClassLikeSymbol<?> ownerSymbol;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        KtSourceElement source = expression2.getSource();
        FirCallableSymbol symbol = FirReferenceUtilsKt.toResolvedCallableSymbol$default(expression2.getCalleeReference(), false, 1, null);
        if (symbol == null) {
            ConeSimpleKotlinType coneSimpleKotlinType;
            ConeKotlinType coneKotlinType;
            FirExpression firExpression = expression2.getExplicitReceiver();
            ConeSimpleKotlinType receiverType = firExpression != null && (coneKotlinType = FirTypeUtilsKt.getResolvedType(firExpression)) != null && (coneSimpleKotlinType = ConeTypesKt.unwrapToSimpleTypeUsingLowerBound(coneKotlinType)) != null ? TypeExpansionUtilsKt.fullyExpandedType((SessionHolder)context2, coneSimpleKotlinType) : null;
            FirMissingDependencySupertypeUtilsKt.checkMissingDependencySuperTypes(context2, reporter, receiverType, source);
            return;
        }
        SmartSet<FirBasedSymbol> checkedSymbols = SmartSet.Companion.create();
        Object object = expression2.getDispatchReceiver();
        FirClassifierSymbol<?> dispatchReceiverSymbol = object != null && (object = FirTypeUtilsKt.getResolvedType((FirExpression)object)) != null ? ToSymbolUtilsKt.toSymbol((ConeKotlinType)object, context2.getSession()) : null;
        boolean missingSuperTypes = FirMissingDependencySupertypeUtilsKt.checkMissingDependencySuperTypes(context2, reporter, (FirBasedSymbol)dispatchReceiverSymbol, source, false);
        FirClassifierSymbol<?> firClassifierSymbol = dispatchReceiverSymbol;
        if (firClassifierSymbol != null) {
            FirBasedSymbol p0 = firClassifierSymbol;
            boolean bl2 = false;
            checkedSymbols.add(p0);
        }
        boolean lazySupertypesUnresolvedByDefault = symbol instanceof FirConstructorSymbol || symbol instanceof FirAnonymousFunctionSymbol;
        boolean isEagerCheck = lazySupertypesUnresolvedByDefault || missingSuperTypes;
        ConeClassLikeLookupTag coneClassLikeLookupTag = FirVisibilityCheckerKt.getOwnerLookupTag(symbol);
        FirClassLikeSymbol<?> firClassLikeSymbol = ownerSymbol = coneClassLikeLookupTag != null ? ToSymbolUtilsKt.toSymbol(coneClassLikeLookupTag, context2.getSession()) : null;
        if (ownerSymbol != null && checkedSymbols.add(ownerSymbol)) {
            FirMissingDependencySupertypeUtilsKt.checkMissingDependencySuperTypes(context2, reporter, (FirBasedSymbol)ownerSymbol, source, isEagerCheck);
        }
        ConeKotlinType coneKotlinType = symbol.getResolvedReceiverType();
        FirClassifierSymbol<?> firClassifierSymbol2 = receiverSymbol = coneKotlinType != null ? ToSymbolUtilsKt.toSymbol(coneKotlinType, context2.getSession()) : null;
        if (receiverSymbol != null && checkedSymbols.add(receiverSymbol)) {
            FirMissingDependencySupertypeUtilsKt.checkMissingDependencySuperTypes(context2, reporter, (FirBasedSymbol)receiverSymbol, source, isEagerCheck);
        }
    }
}

