/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.fir.FirSession;
import ksp.org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import ksp.org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirThisReceiverExpression;
import ksp.org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirEnumEntrySymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import ksp.org.jetbrains.kotlin.name.CallableId;
import ksp.org.jetbrains.kotlin.name.ClassId;
import ksp.org.jetbrains.kotlin.name.FqName;
import ksp.org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0002\u001a\u00020\u0003*\u00020\u0004H\u0002\u001a\u0014\u0010\u0005\u001a\u00020\u0003*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0014\u0010\t\u001a\u00020\u0003*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\f\u0010\n\u001a\u00020\u0003*\u00020\u000bH\u0002\u001a\u0018\u0010\f\u001a\u00020\u0003*\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0010\u0010\u000e\u001a\u00020\u0003*\u0006\u0012\u0002\b\u00030\rH\u0002\u001a!\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00100\u0013H\u0082\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"JAVA_LANG_VOID", "Lksp/org/jetbrains/kotlin/name/ClassId;", "isIgnorable", "", "Lksp/org/jetbrains/kotlin/fir/types/ConeKotlinType;", "isMustUseReturnValue", "Lksp/org/jetbrains/kotlin/fir/expressions/FirAnnotation;", "session", "Lksp/org/jetbrains/kotlin/fir/FirSession;", "isIgnorableValue", "isLocalPropertyOrParameterOrThis", "Lksp/org/jetbrains/kotlin/fir/expressions/FirExpression;", "isExcluded", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "isSubjectToCheck", "ifMappedTypeCollection", "", "Lksp/org/jetbrains/kotlin/name/CallableId;", "nonIgnorableCollectionMethod", "Lkotlin/Function1;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirUnusedReturnValueChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirUnusedReturnValueChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirUnusedReturnValueCheckerKt\n*L\n1#1,202:1\n168#1,34:203\n*S KotlinDebug\n*F\n+ 1 FirUnusedReturnValueChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirUnusedReturnValueCheckerKt\n*L\n155#1:203,34\n*E\n"})
public final class FirUnusedReturnValueCheckerKt {
    @NotNull
    private static final ClassId JAVA_LANG_VOID = ClassId.Companion.topLevel(new FqName("java.lang.Void"));

    private static final boolean isIgnorable(ConeKotlinType $this$isIgnorable) {
        ClassId classId = ConeTypeUtilsKt.getClassId($this$isIgnorable);
        if (classId == null) {
            return false;
        }
        ClassId classId2 = classId;
        if (Intrinsics.areEqual((Object)classId2, (Object)StandardClassIds.INSTANCE.getNothing())) {
            return true;
        }
        if (Intrinsics.areEqual((Object)classId2, (Object)StandardClassIds.INSTANCE.getUnit()) && !ConeTypeUtilsKt.isMarkedNullable($this$isIgnorable)) {
            return true;
        }
        return Intrinsics.areEqual((Object)classId2, (Object)JAVA_LANG_VOID) && !ConeTypeUtilsKt.isMarkedNullable($this$isIgnorable);
    }

    private static final boolean isMustUseReturnValue(FirAnnotation $this$isMustUseReturnValue, FirSession session) {
        return Intrinsics.areEqual((Object)FirAnnotationUtilsKt.toAnnotationClassId($this$isMustUseReturnValue, session), (Object)StandardClassIds.Annotations.INSTANCE.getMustUseReturnValue());
    }

    private static final boolean isIgnorableValue(FirAnnotation $this$isIgnorableValue, FirSession session) {
        return Intrinsics.areEqual((Object)FirAnnotationUtilsKt.toAnnotationClassId($this$isIgnorableValue, session), (Object)StandardClassIds.Annotations.INSTANCE.getIgnorableReturnValue());
    }

    private static final boolean isLocalPropertyOrParameterOrThis(FirExpression $this$isLocalPropertyOrParameterOrThis) {
        boolean bl2;
        if ($this$isLocalPropertyOrParameterOrThis instanceof FirThisReceiverExpression) {
            return true;
        }
        if (!($this$isLocalPropertyOrParameterOrThis instanceof FirPropertyAccessExpression)) {
            return false;
        }
        FirBasedSymbol<?> firBasedSymbol = FirReferenceUtilsKt.getSymbol(((FirPropertyAccessExpression)$this$isLocalPropertyOrParameterOrThis).getCalleeReference());
        if (firBasedSymbol instanceof FirValueParameterSymbol) {
            bl2 = true;
        } else if (firBasedSymbol instanceof FirPropertySymbol) {
            FirPropertySymbol firPropertySymbol = FirReferenceUtilsKt.toResolvedPropertySymbol$default(((FirPropertyAccessExpression)$this$isLocalPropertyOrParameterOrThis).getCalleeReference(), false, 1, null);
            bl2 = firPropertySymbol != null ? firPropertySymbol.isLocal() : false;
        } else {
            bl2 = false;
        }
        return bl2;
    }

    private static final boolean isExcluded(FirCallableSymbol<?> $this$isExcluded, FirSession session) {
        return FirAnnotationUtilsKt.hasAnnotation((FirBasedSymbol)$this$isExcluded, StandardClassIds.Annotations.INSTANCE.getIgnorableReturnValue(), session);
    }

    private static final boolean isSubjectToCheck(FirCallableSymbol<?> $this$isSubjectToCheck) {
        Object object;
        if (Intrinsics.areEqual((Object)$this$isSubjectToCheck.getCallableId().getPackageName().asString(), (Object)"kotlin")) {
            return !($this$isSubjectToCheck.getOrigin() instanceof FirDeclarationOrigin.Enhancement);
        }
        CallableId $this$ifMappedTypeCollection$iv = $this$isSubjectToCheck.getCallableId();
        boolean $i$f$ifMappedTypeCollection = false;
        String packageName$iv = $this$ifMappedTypeCollection$iv.getPackageName().asString();
        if ((Intrinsics.areEqual((Object)packageName$iv, (Object)"kotlin.collections") || Intrinsics.areEqual((Object)packageName$iv, (Object)"java.util")) && (object = $this$ifMappedTypeCollection$iv.getClassName()) != null && (object = ((FqName)object).asString()) != null) {
            Object className$iv = object;
            Object[] objectArray = new String[]{"Collection", "MutableCollection", "List", "MutableList", "ArrayList", "Set", "MutableSet", "HashSet", "LinkedHashSet", "Map", "MutableMap", "HashMap", "LinkedHashMap", "ArrayDeque"};
            if (SetsKt.setOf((Object[])objectArray).contains(className$iv)) {
                objectArray = new String[]{"add", "addAll", "remove", "removeAt", "removeAll", "set", "put", "retainAll", "removeLast"};
                boolean it = !SetsKt.setOf((Object[])objectArray).contains($this$ifMappedTypeCollection$iv.getCallableName().asString());
                boolean bl2 = false;
                return it;
            }
        }
        if ($this$isSubjectToCheck instanceof FirEnumEntrySymbol) {
            return true;
        }
        return $this$isSubjectToCheck.getResolvedStatus().getHasMustUseReturnValue();
    }

    private static final void ifMappedTypeCollection(CallableId $this$ifMappedTypeCollection, Function1<? super Boolean, Unit> nonIgnorableCollectionMethod) {
        boolean $i$f$ifMappedTypeCollection = false;
        String packageName2 = $this$ifMappedTypeCollection.getPackageName().asString();
        if (!Intrinsics.areEqual((Object)packageName2, (Object)"kotlin.collections") && !Intrinsics.areEqual((Object)packageName2, (Object)"java.util")) {
            return;
        }
        Object object = $this$ifMappedTypeCollection.getClassName();
        if (object == null || (object = ((FqName)object).asString()) == null) {
            return;
        }
        Object className = object;
        Object[] objectArray = new String[]{"Collection", "MutableCollection", "List", "MutableList", "ArrayList", "Set", "MutableSet", "HashSet", "LinkedHashSet", "Map", "MutableMap", "HashMap", "LinkedHashMap", "ArrayDeque"};
        if (!SetsKt.setOf((Object[])objectArray).contains(className)) {
            return;
        }
        objectArray = new String[]{"add", "addAll", "remove", "removeAt", "removeAll", "set", "put", "retainAll", "removeLast"};
        nonIgnorableCollectionMethod.invoke((Object)(!SetsKt.setOf((Object[])objectArray).contains($this$ifMappedTypeCollection.getCallableName().asString()) ? 1 : 0));
    }

    public static final /* synthetic */ boolean access$isMustUseReturnValue(FirAnnotation $receiver, FirSession session) {
        return FirUnusedReturnValueCheckerKt.isMustUseReturnValue($receiver, session);
    }

    public static final /* synthetic */ boolean access$isIgnorableValue(FirAnnotation $receiver, FirSession session) {
        return FirUnusedReturnValueCheckerKt.isIgnorableValue($receiver, session);
    }

    public static final /* synthetic */ boolean access$isIgnorable(ConeKotlinType $receiver) {
        return FirUnusedReturnValueCheckerKt.isIgnorable($receiver);
    }

    public static final /* synthetic */ boolean access$isSubjectToCheck(FirCallableSymbol $receiver) {
        return FirUnusedReturnValueCheckerKt.isSubjectToCheck($receiver);
    }

    public static final /* synthetic */ boolean access$isExcluded(FirCallableSymbol $receiver, FirSession session) {
        return FirUnusedReturnValueCheckerKt.isExcluded($receiver, session);
    }
}

