/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.stub;

import ksp.com.intellij.psi.PsiJavaDocumentedElement;
import ksp.com.intellij.psi.PsiMember;
import ksp.com.intellij.psi.PsiMethod;
import ksp.com.intellij.psi.impl.PsiImplUtil;
import ksp.com.intellij.psi.impl.java.stubs.PsiMemberStub;
import ksp.com.intellij.psi.impl.source.PsiFileImpl;
import ksp.com.intellij.psi.impl.source.PsiMethodImpl;
import ksp.com.intellij.psi.impl.source.StubbedSpine;
import ksp.com.intellij.psi.impl.source.tree.JavaElementType;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public final class JavaStubImplUtil {
    public static int getMethodStubIndex(PsiMethod method) {
        if (!(method instanceof PsiMethodImpl)) {
            return -1;
        }
        PsiFileImpl file = (PsiFileImpl)method.getContainingFile();
        StubbedSpine spine = file.getStubbedSpine();
        int result2 = 0;
        for (int i2 = 0; i2 < spine.getStubCount(); ++i2) {
            if (spine.getStubType(i2) != JavaElementType.METHOD) continue;
            if (spine.getStubPsi(i2) == method) {
                return result2;
            }
            ++result2;
        }
        return -1;
    }

    public static <T extends PsiMember & PsiJavaDocumentedElement> boolean isMemberDeprecated(@NotNull T member, @Nullable PsiMemberStub<?> stub2) {
        if (member == null) {
            JavaStubImplUtil.$$$reportNull$$$0(0);
        }
        if (stub2 != null) {
            return stub2.isDeprecated() || stub2.hasDeprecatedAnnotation() && PsiImplUtil.isDeprecatedByAnnotation(member);
        }
        return PsiImplUtil.isDeprecatedByDocTag(member) || PsiImplUtil.isDeprecatedByAnnotation(member);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "ksp/com/intellij/psi/stub/JavaStubImplUtil", "isMemberDeprecated"));
    }
}

