/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.lang;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import ksp.com.intellij.lang.Language;
import ksp.com.intellij.lang.LanguageUtil;
import ksp.com.intellij.lang.MetaLanguage;
import ksp.com.intellij.openapi.extensions.ExtensionPointName;
import ksp.com.intellij.openapi.util.Key;
import ksp.com.intellij.openapi.util.KeyedExtensionCollector;
import ksp.com.intellij.util.KeyedLazyInstance;
import ksp.com.intellij.util.containers.ContainerUtil;
import ksp.kotlinx.collections.immutable.ExtensionsKt;
import ksp.kotlinx.collections.immutable.PersistentList;
import ksp.org.jetbrains.annotations.NonNls;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.annotations.TestOnly;

public class LanguageExtension<T>
extends KeyedExtensionCollector<T, Language> {
    private final T myDefaultImplementation;
    private final Key<T> myCacheKey;
    private final Key<PersistentList<T>> allCacheKey;

    public LanguageExtension(@NotNull ExtensionPointName<? extends KeyedLazyInstance<T>> epName) {
        if (epName == null) {
            LanguageExtension.$$$reportNull$$$0(0);
        }
        this(epName.getName(), null);
    }

    public LanguageExtension(@NotNull @NonNls String epName) {
        if (epName == null) {
            LanguageExtension.$$$reportNull$$$0(1);
        }
        this(epName, null);
    }

    public LanguageExtension(@NotNull ExtensionPointName<? extends KeyedLazyInstance<T>> epName, @Nullable T defaultImplementation) {
        if (epName == null) {
            LanguageExtension.$$$reportNull$$$0(2);
        }
        this(epName.getName(), defaultImplementation);
    }

    public LanguageExtension(@NonNls String epName, @Nullable T defaultImplementation) {
        super(epName);
        this.myDefaultImplementation = defaultImplementation;
        this.myCacheKey = Key.create("EXTENSIONS_IN_LANGUAGE_" + epName);
        this.allCacheKey = Key.create("ALL_EXTENSIONS_IN_LANGUAGE_" + epName);
    }

    @Override
    @NotNull
    protected String keyToString(@NotNull Language key) {
        if (key == null) {
            LanguageExtension.$$$reportNull$$$0(3);
        }
        String string = key.getID();
        if (string == null) {
            LanguageExtension.$$$reportNull$$$0(4);
        }
        return string;
    }

    @TestOnly
    public void clearCache(@NotNull Language language) {
        if (language == null) {
            LanguageExtension.$$$reportNull$$$0(5);
        }
        this.clearCacheForDerivedLanguages(language);
        this.clearCache();
    }

    private void clearCacheForDerivedLanguages(@NotNull Language language) {
        if (language == null) {
            LanguageExtension.$$$reportNull$$$0(6);
        }
        for (Language dialect : ContainerUtil.concat(language.getTransitiveDialects(), Collections.singletonList(language))) {
            this.clearCacheForLanguage(dialect);
            for (MetaLanguage metaLanguage : LanguageUtil.matchingMetaLanguages(dialect)) {
                this.clearCacheForLanguage(metaLanguage);
            }
        }
        if (language instanceof MetaLanguage) {
            Collection<Language> matchingLanguages = ((MetaLanguage)language).getMatchingLanguages();
            for (Language matchingLanguage : matchingLanguages) {
                Collection<Language> dialects = matchingLanguage.getTransitiveDialects();
                this.clearCacheForLanguage(matchingLanguage);
                for (Language dialect : dialects) {
                    this.clearCacheForLanguage(dialect);
                }
            }
        }
    }

    private void clearCacheForLanguage(@NotNull Language language) {
        if (language == null) {
            LanguageExtension.$$$reportNull$$$0(7);
        }
        language.putUserData(this.myCacheKey, null);
        language.putUserData(this.allCacheKey, null);
        super.invalidateCacheForExtension(language.getID());
    }

    @Override
    public void invalidateCacheForExtension(@NotNull String key) {
        if (key == null) {
            LanguageExtension.$$$reportNull$$$0(8);
        }
        super.invalidateCacheForExtension(key);
        Language language = Language.findLanguageByID(key);
        if (language != null) {
            this.clearCacheForDerivedLanguages(language);
        }
    }

    public T forLanguage(@NotNull Language l2) {
        T cached;
        if (l2 == null) {
            LanguageExtension.$$$reportNull$$$0(9);
        }
        if ((cached = l2.getUserData(this.myCacheKey)) != null) {
            return cached;
        }
        T result2 = this.findForLanguage(l2);
        if (result2 == null) {
            return null;
        }
        result2 = l2.putUserDataIfAbsent(this.myCacheKey, result2);
        return result2;
    }

    protected T findForLanguage(@NotNull Language language) {
        if (language == null) {
            LanguageExtension.$$$reportNull$$$0(10);
        }
        for (Language l2 = language; l2 != null; l2 = l2.getBaseLanguage()) {
            List extensions = this.forKey(l2);
            if (extensions.isEmpty()) continue;
            return extensions.get(0);
        }
        return this.myDefaultImplementation;
    }

    @NotNull
    public List<T> allForLanguage(@NotNull Language language) {
        List cached;
        if (language == null) {
            LanguageExtension.$$$reportNull$$$0(11);
        }
        if ((cached = (List)language.getUserData(this.allCacheKey)) != null) {
            List list = cached;
            if (list == null) {
                LanguageExtension.$$$reportNull$$$0(12);
            }
            return list;
        }
        PersistentList<T> result2 = this.collectAllForLanguage(language);
        List list = language.putUserDataIfAbsent(this.allCacheKey, result2);
        if (list == null) {
            LanguageExtension.$$$reportNull$$$0(13);
        }
        return list;
    }

    @NotNull
    private PersistentList<T> collectAllForLanguage(@NotNull Language language) {
        if (language == null) {
            LanguageExtension.$$$reportNull$$$0(14);
        }
        PersistentList result2 = ExtensionsKt.persistentListOf();
        for (Language l2 = language; l2 != null; l2 = l2.getBaseLanguage()) {
            result2 = result2.addAll(this.forKey(l2));
        }
        PersistentList persistentList = result2;
        if (persistentList == null) {
            LanguageExtension.$$$reportNull$$$0(15);
        }
        return persistentList;
    }

    @Override
    @NotNull
    protected List<T> buildExtensions(@NotNull String stringKey, @NotNull Language key) {
        List<MetaLanguage> metaLanguages;
        if (stringKey == null) {
            LanguageExtension.$$$reportNull$$$0(16);
        }
        if (key == null) {
            LanguageExtension.$$$reportNull$$$0(17);
        }
        if ((metaLanguages = LanguageUtil.matchingMetaLanguages(key)).isEmpty()) {
            List list = super.buildExtensions(stringKey, key);
            if (list == null) {
                LanguageExtension.$$$reportNull$$$0(18);
            }
            return list;
        }
        HashSet<String> allKeys = new HashSet<String>(metaLanguages.size() + 1);
        allKeys.add(stringKey);
        for (MetaLanguage language : metaLanguages) {
            allKeys.add(this.keyToString(language));
        }
        PersistentList persistentList = this.buildExtensions(allKeys);
        if (persistentList == null) {
            LanguageExtension.$$$reportNull$$$0(19);
        }
        return persistentList;
    }

    @NotNull
    public List<T> allForLanguageOrAny(@NotNull Language l2) {
        if (l2 == null) {
            LanguageExtension.$$$reportNull$$$0(20);
        }
        List<T> forLanguage = this.allForLanguage(l2);
        if (l2 == Language.ANY) {
            List<T> list = forLanguage;
            if (list == null) {
                LanguageExtension.$$$reportNull$$$0(21);
            }
            return list;
        }
        List<T> list = ContainerUtil.concat(forLanguage, this.allForLanguage(Language.ANY));
        if (list == null) {
            LanguageExtension.$$$reportNull$$$0(22);
        }
        return list;
    }

    @Override
    public void addExplicitExtension(@NotNull Language key, @NotNull T t2) {
        if (key == null) {
            LanguageExtension.$$$reportNull$$$0(23);
        }
        if (t2 == null) {
            LanguageExtension.$$$reportNull$$$0(24);
        }
        this.clearCacheForLanguage(key);
        super.addExplicitExtension(key, t2);
    }

    @Override
    public void removeExplicitExtension(@NotNull Language key, @NotNull T t2) {
        if (key == null) {
            LanguageExtension.$$$reportNull$$$0(25);
        }
        if (t2 == null) {
            LanguageExtension.$$$reportNull$$$0(26);
        }
        this.clearCacheForLanguage(key);
        super.removeExplicitExtension(key, t2);
    }

    protected T getDefaultImplementation() {
        return this.myDefaultImplementation;
    }

    @Override
    protected void ensureValuesLoaded() {
        super.ensureValuesLoaded();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 12: 
            case 13: 
            case 15: 
            case 18: 
            case 19: 
            case 21: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: 
            case 12: 
            case 13: 
            case 15: 
            case 18: 
            case 19: 
            case 21: 
            case 22: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "epName";
                break;
            }
            case 3: 
            case 8: 
            case 17: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 4: 
            case 12: 
            case 13: 
            case 15: 
            case 18: 
            case 19: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/lang/LanguageExtension";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 9: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringKey";
                break;
            }
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/lang/LanguageExtension";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "keyToString";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "allForLanguage";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAllForLanguage";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "buildExtensions";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "allForLanguageOrAny";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "keyToString";
                break;
            }
            case 4: 
            case 12: 
            case 13: 
            case 15: 
            case 18: 
            case 19: 
            case 21: 
            case 22: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "clearCache";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "clearCacheForDerivedLanguages";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "clearCacheForLanguage";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "invalidateCacheForExtension";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "forLanguage";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findForLanguage";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "allForLanguage";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "collectAllForLanguage";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "buildExtensions";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "allForLanguageOrAny";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addExplicitExtension";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "removeExplicitExtension";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 12: 
            case 13: 
            case 15: 
            case 18: 
            case 19: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

