/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util.containers;

import java.util.Arrays;
import ksp.com.intellij.util.ArrayUtil;
import ksp.org.jetbrains.annotations.NotNull;

public final class UnsignedShortArrayList
implements Cloneable {
    private char[] myData;
    private int mySize;

    public UnsignedShortArrayList(int initialCapacity) {
        this.myData = new char[initialCapacity];
    }

    public UnsignedShortArrayList() {
        this(10);
    }

    public void trimToSize() {
        if (this.mySize < this.myData.length) {
            this.myData = ArrayUtil.realloc(this.myData, this.mySize);
        }
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.myData.length;
        if (minCapacity > oldCapacity) {
            char[] oldData = this.myData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.myData = new char[newCapacity];
            System.arraycopy(oldData, 0, this.myData, 0, this.mySize);
        }
    }

    public void fill(int fromIndex, int toIndex, int value2) {
        UnsignedShortArrayList.assertShort(value2);
        if (toIndex > this.mySize) {
            this.ensureCapacity(toIndex);
            this.mySize = toIndex;
        }
        Arrays.fill(this.myData, fromIndex, toIndex, (char)value2);
    }

    public int size() {
        return this.mySize;
    }

    public boolean isEmpty() {
        return this.mySize == 0;
    }

    public boolean contains(int element2) {
        UnsignedShortArrayList.assertShort(element2);
        return this.indexOf(element2) >= 0;
    }

    public int indexOf(int element2) {
        UnsignedShortArrayList.assertShort(element2);
        return this.indexOf(element2, 0, this.mySize);
    }

    public int indexOf(int element2, int startIndex, int endIndex) {
        UnsignedShortArrayList.assertShort(element2);
        if (startIndex < 0 || endIndex < startIndex || endIndex > this.mySize) {
            throw new IndexOutOfBoundsException("startIndex: " + startIndex + "; endIndex: " + endIndex + "; mySize: " + this.mySize);
        }
        for (int i2 = startIndex; i2 < endIndex; ++i2) {
            if (element2 != this.myData[i2]) continue;
            return i2;
        }
        return -1;
    }

    public int lastIndexOf(int element2) {
        UnsignedShortArrayList.assertShort(element2);
        for (int i2 = this.mySize - 1; i2 >= 0; --i2) {
            if (element2 != this.myData[i2]) continue;
            return i2;
        }
        return -1;
    }

    public Object clone() {
        try {
            UnsignedShortArrayList v2 = (UnsignedShortArrayList)super.clone();
            v2.myData = (char[])this.myData.clone();
            return v2;
        }
        catch (CloneNotSupportedException e2) {
            throw new InternalError();
        }
    }

    public int @NotNull [] toArray() {
        int[] nArray = this.toArray(0, this.mySize);
        if (nArray == null) {
            UnsignedShortArrayList.$$$reportNull$$$0(0);
        }
        return nArray;
    }

    public int @NotNull [] toArray(int @NotNull [] a2) {
        if (a2 == null) {
            UnsignedShortArrayList.$$$reportNull$$$0(1);
        }
        if (a2.length < this.mySize) {
            a2 = new int[this.mySize];
        }
        for (int i2 = 0; i2 < this.mySize; ++i2) {
            int c2;
            a2[i2] = c2 = this.myData[i2];
        }
        if (a2 == null) {
            UnsignedShortArrayList.$$$reportNull$$$0(2);
        }
        return a2;
    }

    public int @NotNull [] toArray(int startIndex, int length) {
        int[] result2 = new int[length];
        for (int i2 = startIndex; i2 < length; ++i2) {
            int c2;
            result2[i2 - startIndex] = c2 = this.myData[i2];
        }
        if (result2 == null) {
            UnsignedShortArrayList.$$$reportNull$$$0(3);
        }
        return result2;
    }

    public int get(int index2) {
        this.checkRange(index2);
        return this.myData[index2];
    }

    public int getQuick(int index2) {
        return this.myData[index2];
    }

    public int set(int index2, int element2) {
        this.checkRange(index2);
        char oldValue = this.myData[index2];
        this.setQuick(index2, element2);
        return oldValue;
    }

    public void setQuick(int index2, int element2) {
        UnsignedShortArrayList.assertShort(element2);
        this.myData[index2] = (char)element2;
    }

    private static void assertShort(int element2) {
        assert (element2 >= 0 && element2 < 65536) : element2;
    }

    public void add(int element2) {
        this.ensureCapacity(this.mySize + 1);
        this.setQuick(this.mySize++, element2);
    }

    public void add(int index2, int element2) {
        if (index2 > this.mySize || index2 < 0) {
            throw new IndexOutOfBoundsException("Index: " + index2 + ", Size: " + this.mySize);
        }
        this.ensureCapacity(this.mySize + 1);
        System.arraycopy(this.myData, index2, this.myData, index2 + 1, this.mySize - index2);
        this.setQuick(index2, element2);
        ++this.mySize;
    }

    public int remove(int index2) {
        this.checkRange(index2);
        char oldValue = this.myData[index2];
        int numMoved = this.mySize - index2 - 1;
        if (numMoved > 0) {
            System.arraycopy(this.myData, index2 + 1, this.myData, index2, numMoved);
        }
        --this.mySize;
        return oldValue;
    }

    public void clear() {
        this.mySize = 0;
    }

    public void removeRange(int fromIndex, int toIndex) {
        int numMoved = this.mySize - toIndex;
        System.arraycopy(this.myData, toIndex, this.myData, fromIndex, numMoved);
        this.mySize -= toIndex - fromIndex;
    }

    public void copyRange(int fromIndex, int length, int toIndex) {
        if (length < 0 || fromIndex < 0 || fromIndex + length > this.mySize || toIndex < 0 || toIndex + length > this.mySize) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + "; length: " + length + "; toIndex: " + toIndex + "; mySize: " + this.mySize);
        }
        System.arraycopy(this.myData, fromIndex, this.myData, toIndex, length);
    }

    private void checkRange(int index2) {
        if (index2 >= this.mySize || index2 < 0) {
            throw new IndexOutOfBoundsException("Index: " + index2 + ", Size: " + this.mySize);
        }
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/util/containers/UnsignedShortArrayList";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "toArray";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/util/containers/UnsignedShortArrayList";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "toArray";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

