/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.impl.source.resolve.graphInference;

import java.util.HashSet;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.psi.GenericsUtil;
import ksp.com.intellij.psi.JavaPsiFacade;
import ksp.com.intellij.psi.LambdaUtil;
import ksp.com.intellij.psi.PsiClass;
import ksp.com.intellij.psi.PsiClassType;
import ksp.com.intellij.psi.PsiElementFactory;
import ksp.com.intellij.psi.PsiLambdaExpression;
import ksp.com.intellij.psi.PsiMethod;
import ksp.com.intellij.psi.PsiParameter;
import ksp.com.intellij.psi.PsiSubstitutor;
import ksp.com.intellij.psi.PsiType;
import ksp.com.intellij.psi.PsiTypeParameter;
import ksp.com.intellij.psi.PsiWildcardType;
import ksp.com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import ksp.com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeEqualityConstraint;
import ksp.com.intellij.psi.util.PsiTypesUtil;
import ksp.com.intellij.psi.util.TypeConversionUtil;
import ksp.com.intellij.util.containers.ContainerUtil;
import ksp.org.jetbrains.annotations.Nullable;

public final class FunctionalInterfaceParameterizationUtil {
    private static final Logger LOG = Logger.getInstance(FunctionalInterfaceParameterizationUtil.class);

    public static boolean isWildcardParameterized(@Nullable PsiType classType) {
        if ((classType = LambdaUtil.normalizeFunctionalType(classType)) == null) {
            return false;
        }
        if (classType instanceof PsiClassType) {
            PsiClassType.ClassResolveResult result2 = ((PsiClassType)classType).resolveGenerics();
            PsiClass aClass = result2.getElement();
            if (aClass != null) {
                PsiSubstitutor substitutor2 = result2.getSubstitutor();
                for (PsiTypeParameter parameter2 : aClass.getTypeParameters()) {
                    if (!(substitutor2.substitute(parameter2) instanceof PsiWildcardType)) continue;
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    @Nullable
    public static PsiType getGroundTargetType(@Nullable PsiType psiClassType) {
        return FunctionalInterfaceParameterizationUtil.getGroundTargetType(psiClassType, null);
    }

    @Nullable
    public static PsiType getGroundTargetType(@Nullable PsiType psiClassType, @Nullable PsiLambdaExpression expr) {
        return FunctionalInterfaceParameterizationUtil.getGroundTargetType(psiClassType, expr, true);
    }

    @Nullable
    public static PsiType getGroundTargetType(@Nullable PsiType psiClassType, @Nullable PsiLambdaExpression expr, boolean performFinalCheck) {
        if (!FunctionalInterfaceParameterizationUtil.isWildcardParameterized(psiClassType = LambdaUtil.normalizeFunctionalType(psiClassType))) {
            return psiClassType;
        }
        if (expr != null && expr.hasFormalParameterTypes()) {
            return FunctionalInterfaceParameterizationUtil.getFunctionalTypeExplicit(psiClassType, expr, performFinalCheck);
        }
        return psiClassType instanceof PsiClassType ? FunctionalInterfaceParameterizationUtil.getNonWildcardParameterization((PsiClassType)psiClassType) : null;
    }

    private static PsiType getFunctionalTypeExplicit(PsiType psiClassType, PsiLambdaExpression expr, boolean performFinalCheck) {
        PsiParameter[] lambdaParams = expr.getParameterList().getParameters();
        LOG.assertTrue(psiClassType instanceof PsiClassType, "Unexpected type: " + psiClassType);
        PsiType[] parameters2 = ((PsiClassType)psiClassType).getParameters();
        PsiClassType.ClassResolveResult resolveResult = ((PsiClassType)psiClassType).resolveGenerics();
        PsiClass psiClass = resolveResult.getElement();
        if (psiClass != null) {
            PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(resolveResult);
            if (interfaceMethod == null) {
                return null;
            }
            PsiClass samClass = interfaceMethod.getContainingClass();
            if (samClass == null) {
                return null;
            }
            PsiTypeParameter[] typeParameters2 = psiClass.getTypeParameters();
            if (typeParameters2.length != parameters2.length) {
                return null;
            }
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(psiClass.getProject());
            PsiParameter[] targetMethodParams = interfaceMethod.getParameterList().getParameters();
            if (targetMethodParams.length != lambdaParams.length) {
                return null;
            }
            PsiSubstitutor lambdaSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(samClass, psiClass, PsiSubstitutor.EMPTY);
            InferenceSession session = new InferenceSession(typeParameters2, PsiSubstitutor.EMPTY, expr.getManager(), expr);
            for (int i2 = 0; i2 < targetMethodParams.length; ++i2) {
                PsiType qType = lambdaSubstitutor.substitute(targetMethodParams[i2].getType());
                session.addConstraint(new TypeEqualityConstraint(lambdaParams[i2].getType(), session.substituteWithInferenceVariables(qType)));
            }
            if (!session.repeatInferencePhases()) {
                return null;
            }
            PsiSubstitutor substitutor2 = session.getInstantiations(session.getInferenceVariables());
            PsiType[] newTypeParameters = new PsiType[parameters2.length];
            for (int i3 = 0; i3 < typeParameters2.length; ++i3) {
                PsiTypeParameter typeParameter = typeParameters2[i3];
                newTypeParameters[i3] = substitutor2.getSubstitutionMap().containsKey(typeParameter) ? substitutor2.substitute(typeParameter) : parameters2[i3];
            }
            PsiClassType parameterization = elementFactory.createType(psiClass, newTypeParameters);
            if (!FunctionalInterfaceParameterizationUtil.isWellFormed(psiClass, typeParameters2, newTypeParameters) || performFinalCheck && !psiClassType.isAssignableFrom(parameterization)) {
                return null;
            }
            if (!FunctionalInterfaceParameterizationUtil.isWildcardParameterized(parameterization)) {
                return parameterization;
            }
            return FunctionalInterfaceParameterizationUtil.getNonWildcardParameterization(parameterization);
        }
        return null;
    }

    private static boolean isWellFormed(PsiClass psiClass, PsiTypeParameter[] typeParameters2, PsiType[] newTypeParameters) {
        PsiSubstitutor substitutor2 = PsiSubstitutor.EMPTY.putAll(psiClass, newTypeParameters);
        for (int i2 = 0; i2 < typeParameters2.length; ++i2) {
            for (PsiClassType bound : typeParameters2[i2].getExtendsListTypes()) {
                if (!GenericsUtil.checkNotInBounds(newTypeParameters[i2], substitutor2.substitute(bound), false)) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    public static PsiType getNonWildcardParameterization(PsiClassType psiClassType) {
        PsiClassType.ClassResolveResult result2 = psiClassType.resolveGenerics();
        PsiClass psiClass = result2.getElement();
        if (psiClass != null) {
            PsiTypeParameter[] typeParameters2 = psiClass.getTypeParameters();
            PsiType[] newParameters = new PsiType[typeParameters2.length];
            PsiSubstitutor substitutor2 = result2.getSubstitutor();
            HashSet<PsiTypeParameter> typeParametersSet = ContainerUtil.newHashSet(typeParameters2);
            block0: for (int i2 = 0; i2 < typeParameters2.length; ++i2) {
                PsiType paramType = substitutor2.substitute(typeParameters2[i2]);
                if (paramType instanceof PsiWildcardType) {
                    PsiType bound = ((PsiWildcardType)paramType).getBound();
                    for (PsiClassType paramBound : typeParameters2[i2].getExtendsListTypes()) {
                        if (!PsiTypesUtil.mentionsTypeParameters((PsiType)paramBound, typeParametersSet)) continue;
                        if (bound == null) {
                            return null;
                        }
                        newParameters[i2] = bound;
                        continue block0;
                    }
                    if (((PsiWildcardType)paramType).isSuper()) {
                        newParameters[i2] = bound;
                        continue;
                    }
                    newParameters[i2] = bound != null ? bound : PsiType.getJavaLangObject(psiClass.getManager(), psiClassType.getResolveScope());
                    for (PsiClassType paramBound : typeParameters2[i2].getExtendsListTypes()) {
                        newParameters[i2] = GenericsUtil.getGreatestLowerBound(newParameters[i2], paramBound);
                    }
                    continue;
                }
                newParameters[i2] = paramType;
            }
            if (!FunctionalInterfaceParameterizationUtil.isWellFormed(psiClass, typeParameters2, newParameters)) {
                return null;
            }
            PsiClassType parameterization = JavaPsiFacade.getElementFactory(psiClass.getProject()).createType(psiClass, newParameters);
            if (!psiClassType.isAssignableFrom(parameterization)) {
                return null;
            }
            return parameterization;
        }
        return null;
    }
}

