/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.openapi.extensions;

import java.io.File;
import java.nio.file.Path;
import java.util.Date;
import ksp.com.intellij.openapi.extensions.PluginId;
import ksp.com.intellij.openapi.util.NlsSafe;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.Nls;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public interface PluginDescriptor {
    @NotNull
    public PluginId getPluginId();

    @Nullable
    public ClassLoader getPluginClassLoader();

    @ApiStatus.Experimental
    @NotNull
    default public ClassLoader getClassLoader() {
        ClassLoader classLoader = this.getPluginClassLoader();
        ClassLoader classLoader2 = classLoader == null ? this.getClass().getClassLoader() : classLoader;
        if (classLoader2 == null) {
            PluginDescriptor.$$$reportNull$$$0(0);
        }
        return classLoader2;
    }

    default public boolean isBundled() {
        return false;
    }

    @Deprecated
    default public File getPath() {
        Path path = this.getPluginPath();
        return path == null ? null : path.toFile();
    }

    public Path getPluginPath();

    @Nullable
    @Nls
    public String getDescription();

    @Nullable
    public String getChangeNotes();

    @NlsSafe
    public String getName();

    @Nullable
    public String getProductCode();

    @Nullable
    public Date getReleaseDate();

    public int getReleaseVersion();

    public boolean isLicenseOptional();

    @Deprecated
    public PluginId @NotNull [] getOptionalDependentPluginIds();

    @Nullable
    @NlsSafe
    public String getVendor();

    @Nullable
    @NlsSafe
    default public String getOrganization() {
        return null;
    }

    @NlsSafe
    public String getVersion();

    @Nullable
    public String getResourceBundleBaseName();

    @Nullable
    @NlsSafe
    public String getCategory();

    @Nullable
    @Nls
    default public String getDisplayCategory() {
        return this.getCategory();
    }

    @Nullable
    public String getVendorEmail();

    @Nullable
    public String getVendorUrl();

    @Nullable
    public String getUrl();

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @Nullable
    default public String getDownloads() {
        return null;
    }

    @Nullable
    @NlsSafe
    public String getSinceBuild();

    @Nullable
    @NlsSafe
    public String getUntilBuild();

    default public boolean allowBundledUpdate() {
        return false;
    }

    @ApiStatus.Internal
    default public boolean isImplementationDetail() {
        return false;
    }

    default public boolean isRequireRestart() {
        return false;
    }

    public boolean isEnabled();

    public void setEnabled(boolean var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ksp/com/intellij/openapi/extensions/PluginDescriptor", "getClassLoader"));
    }
}

