/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.openapi.editor;

import java.beans.PropertyChangeListener;
import ksp.com.intellij.openapi.Disposable;
import ksp.com.intellij.openapi.editor.RangeMarker;
import ksp.com.intellij.openapi.editor.event.DocumentListener;
import ksp.com.intellij.openapi.util.NlsSafe;
import ksp.com.intellij.openapi.util.TextRange;
import ksp.com.intellij.openapi.util.UserDataHolder;
import ksp.com.intellij.util.text.CharArrayUtil;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.Contract;
import ksp.org.jetbrains.annotations.NonNls;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public interface Document
extends UserDataHolder {
    public static final Document[] EMPTY_ARRAY = new Document[0];
    @NonNls
    public static final String PROP_WRITABLE = "writable";

    @Contract(pure=true)
    @NotNull
    @NlsSafe
    default public String getText() {
        String string = this.getImmutableCharSequence().toString();
        if (string == null) {
            Document.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    @NlsSafe
    default public String getText(@NotNull TextRange range) {
        if (range == null) {
            Document.$$$reportNull$$$0(1);
        }
        String string = range.substring(this.getText());
        if (string == null) {
            Document.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    @NlsSafe
    default public CharSequence getCharsSequence() {
        CharSequence charSequence = this.getImmutableCharSequence();
        if (charSequence == null) {
            Document.$$$reportNull$$$0(3);
        }
        return charSequence;
    }

    @NotNull
    @Contract(pure=true)
    @NlsSafe
    public CharSequence getImmutableCharSequence();

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    default public char @NotNull [] getChars() {
        char[] cArray = CharArrayUtil.fromSequence(this.getImmutableCharSequence());
        if (cArray == null) {
            Document.$$$reportNull$$$0(4);
        }
        return cArray;
    }

    @Contract(pure=true)
    default public int getTextLength() {
        return this.getImmutableCharSequence().length();
    }

    @Contract(pure=true)
    public int getLineCount();

    @Contract(pure=true)
    public int getLineNumber(int var1);

    @Contract(pure=true)
    public int getLineStartOffset(int var1);

    @Contract(pure=true)
    public int getLineEndOffset(int var1);

    default public boolean isLineModified(int line) {
        return false;
    }

    public void insertString(int var1, @NonNls @NotNull CharSequence var2);

    public void deleteString(int var1, int var2);

    public void replaceString(int var1, int var2, @NlsSafe @NotNull CharSequence var3);

    @Contract(pure=true)
    public boolean isWritable();

    @Contract(pure=true)
    public long getModificationStamp();

    default public void fireReadOnlyModificationAttempt() {
    }

    default public void addDocumentListener(@NotNull DocumentListener listener2) {
        if (listener2 == null) {
            Document.$$$reportNull$$$0(5);
        }
    }

    default public void addDocumentListener(@NotNull DocumentListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            Document.$$$reportNull$$$0(6);
        }
        if (parentDisposable == null) {
            Document.$$$reportNull$$$0(7);
        }
    }

    default public void removeDocumentListener(@NotNull DocumentListener listener2) {
        if (listener2 == null) {
            Document.$$$reportNull$$$0(8);
        }
    }

    @NotNull
    default public RangeMarker createRangeMarker(int startOffset, int endOffset) {
        RangeMarker rangeMarker = this.createRangeMarker(startOffset, endOffset, false);
        if (rangeMarker == null) {
            Document.$$$reportNull$$$0(9);
        }
        return rangeMarker;
    }

    @NotNull
    public RangeMarker createRangeMarker(int var1, int var2, boolean var3);

    default public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            Document.$$$reportNull$$$0(10);
        }
    }

    default public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            Document.$$$reportNull$$$0(11);
        }
    }

    default public void setReadOnly(boolean isReadOnly) {
    }

    @NotNull
    public RangeMarker createGuardedBlock(int var1, int var2);

    default public void removeGuardedBlock(@NotNull RangeMarker block) {
        if (block == null) {
            Document.$$$reportNull$$$0(12);
        }
    }

    @Nullable
    default public RangeMarker getOffsetGuard(int offset) {
        return this.getRangeGuard(offset, offset);
    }

    @Nullable
    default public RangeMarker getRangeGuard(int start, int end) {
        return null;
    }

    default public void startGuardedBlockChecking() {
    }

    default public void stopGuardedBlockChecking() {
    }

    default public void setCyclicBufferSize(int bufferSize) {
    }

    public void setText(@NotNull CharSequence var1);

    @NotNull
    default public RangeMarker createRangeMarker(@NotNull TextRange textRange) {
        if (textRange == null) {
            Document.$$$reportNull$$$0(13);
        }
        RangeMarker rangeMarker = this.createRangeMarker(textRange.getStartOffset(), textRange.getEndOffset());
        if (rangeMarker == null) {
            Document.$$$reportNull$$$0(14);
        }
        return rangeMarker;
    }

    @Contract(pure=true)
    default public int getLineSeparatorLength(int line) {
        return 0;
    }

    default public boolean isInBulkUpdate() {
        return false;
    }

    @Deprecated
    default public void setInBulkUpdate(boolean value2) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/openapi/editor/Document";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/openapi/editor/Document";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharsSequence";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChars";
                break;
            }
            case 9: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createRangeMarker";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addDocumentListener";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeDocumentListener";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeGuardedBlock";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createRangeMarker";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

