/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.diagnostics.rendering;

import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.config.LanguageVersion;
import ksp.org.jetbrains.kotlin.config.LanguageVersionSettings;
import ksp.org.jetbrains.kotlin.diagnostics.rendering.DiagnosticParameterRenderer;
import ksp.org.jetbrains.kotlin.diagnostics.rendering.RenderingContext;
import ksp.org.jetbrains.kotlin.diagnostics.rendering.RuntimeFeatureToFlagMapKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001:\u0001\u0017B\u001b\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ$\u0010\u0013\u001a\u00020\r2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R'\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r0\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0018"}, d2={"Lksp/org/jetbrains/kotlin/diagnostics/rendering/LanguageFeatureMessageRenderer;", "Lksp/org/jetbrains/kotlin/diagnostics/rendering/DiagnosticParameterRenderer;", "Lkotlin/Pair;", "Lksp/org/jetbrains/kotlin/config/LanguageFeature;", "Lksp/org/jetbrains/kotlin/config/LanguageVersionSettings;", "type", "Lksp/org/jetbrains/kotlin/diagnostics/rendering/LanguageFeatureMessageRenderer$Type;", "useHtml", "", "<init>", "(Lorg/jetbrains/kotlin/diagnostics/rendering/LanguageFeatureMessageRenderer$Type;Z)V", "additionalFeatureMessages", "", "", "featureToFlagMap", "getFeatureToFlagMap", "()Ljava/util/Map;", "featureToFlagMap$delegate", "Lkotlin/Lazy;", "render", "obj", "renderingContext", "Lksp/org/jetbrains/kotlin/diagnostics/rendering/RenderingContext;", "Type", "frontend.common-psi"})
public final class LanguageFeatureMessageRenderer
implements DiagnosticParameterRenderer<Pair<? extends LanguageFeature, ? extends LanguageVersionSettings>> {
    @NotNull
    private final Type type;
    private final boolean useHtml;
    @NotNull
    private final Map<LanguageFeature, String> additionalFeatureMessages;
    @NotNull
    private final Lazy featureToFlagMap$delegate;

    @JvmOverloads
    public LanguageFeatureMessageRenderer(@NotNull Type type2, boolean useHtml) {
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        this.type = type2;
        this.useHtml = useHtml;
        this.additionalFeatureMessages = MapsKt.mapOf((Pair)TuplesKt.to((Object)((Object)LanguageFeature.UnitConversionsOnArbitraryExpressions), (Object)"You can also change the original type of this expression to (...) -> Unit"));
        this.featureToFlagMap$delegate = LazyKt.lazy(() -> LanguageFeatureMessageRenderer.featureToFlagMap_delegate$lambda$0(this));
    }

    public /* synthetic */ LanguageFeatureMessageRenderer(Type type2, boolean bl2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            bl2 = false;
        }
        this(type2, bl2);
    }

    private final Map<LanguageFeature, String> getFeatureToFlagMap() {
        Lazy lazy = this.featureToFlagMap$delegate;
        return (Map)lazy.getValue();
    }

    @Override
    @NotNull
    public String render(@NotNull Pair<? extends LanguageFeature, ? extends LanguageVersionSettings> obj, @NotNull RenderingContext renderingContext) {
        Intrinsics.checkNotNullParameter(obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)renderingContext, (String)"renderingContext");
        LanguageFeature feature = (LanguageFeature)((Object)obj.component1());
        LanguageVersionSettings settings = (LanguageVersionSettings)obj.component2();
        LanguageVersion since = feature.getSinceVersion();
        StringBuilder sb = new StringBuilder();
        sb.append("The feature \"").append(feature.getPresentableName()).append("\" is ");
        String string = this.getFeatureToFlagMap().get((Object)feature);
        if (string == null) {
            string = "-XXLanguage:+" + feature.name();
        }
        String featureFlag = string;
        switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1: {
                StringBuilder stringBuilder;
                if (settings.supportsFeature(feature) && settings.getLanguageVersion().compareTo((Enum)LanguageVersion.KOTLIN_2_0) < 0) {
                    stringBuilder = sb.append("not supported in language versions 1.*, please use version 2.0 or later");
                    break;
                }
                if (feature.getTestOnly()) {
                    stringBuilder = sb.append("unsupported.");
                    break;
                }
                if (since == null) {
                    stringBuilder = sb.append("experimental and should be enabled explicitly. This can be done by supplying the compiler argument '" + featureFlag + "', but note that no stability guarantees are provided.");
                    break;
                }
                if (since.compareTo((Enum)settings.getLanguageVersion()) > 0) {
                    stringBuilder = sb.append("only available since language version ").append(since.getVersionString());
                    break;
                }
                if (feature.getSinceApiVersion().compareTo(settings.getApiVersion()) > 0) {
                    stringBuilder = sb.append("only available since API version ").append(feature.getSinceApiVersion().getVersionString());
                    break;
                }
                stringBuilder = sb.append("disabled");
                break;
            }
            case 2: {
                StringBuilder stringBuilder = sb.append("experimental");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String hintUrl = feature.getHintUrl();
        if (hintUrl != null) {
            StringBuilder stringBuilder = this.useHtml ? sb.append(" (").append("see more <a href=\"").append(hintUrl).append("\">here</a>)") : sb.append(" (see: ").append(hintUrl).append(")");
        }
        if (this.additionalFeatureMessages.containsKey((Object)feature)) {
            sb.append(". " + this.additionalFeatureMessages.get((Object)feature));
        }
        String string2 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    @JvmOverloads
    public LanguageFeatureMessageRenderer(@NotNull Type type2) {
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        this(type2, false, 2, null);
    }

    private static final Map featureToFlagMap_delegate$lambda$0(LanguageFeatureMessageRenderer this$0) {
        ClassLoader classLoader = this$0.getClass().getClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getClassLoader(...)");
        return RuntimeFeatureToFlagMapKt.buildRuntimeFeatureToFlagMap(classLoader);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lksp/org/jetbrains/kotlin/diagnostics/rendering/LanguageFeatureMessageRenderer$Type;", "", "<init>", "(Ljava/lang/String;I)V", "UNSUPPORTED", "WARNING", "frontend.common-psi"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type UNSUPPORTED = new Type();
        public static final /* enum */ Type WARNING = new Type();
        private static final /* synthetic */ Type[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value2) {
            return Enum.valueOf(Type.class, value2);
        }

        @NotNull
        public static EnumEntries<Type> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = typeArray = new Type[]{Type.UNSUPPORTED, Type.WARNING};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Type.values().length];
            try {
                nArray[Type.UNSUPPORTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.WARNING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

