/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.patterns;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import ksp.com.intellij.openapi.util.Comparing;
import ksp.com.intellij.openapi.util.Key;
import ksp.com.intellij.patterns.CharPattern;
import ksp.com.intellij.patterns.CollectionPattern;
import ksp.com.intellij.patterns.ElementPattern;
import ksp.com.intellij.patterns.ElementPatternCondition;
import ksp.com.intellij.patterns.InitialPatternCondition;
import ksp.com.intellij.patterns.InitialPatternConditionPlus;
import ksp.com.intellij.patterns.ObjectPattern;
import ksp.com.intellij.patterns.PatternCondition;
import ksp.com.intellij.patterns.StringPattern;
import ksp.com.intellij.util.ProcessingContext;
import ksp.com.intellij.util.SmartList;
import ksp.com.intellij.util.containers.ContainerUtil;
import ksp.org.jetbrains.annotations.NonNls;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public class StandardPatterns {
    private static final FalsePattern FALSE_PATTERN = new FalsePattern();

    @NotNull
    public static StringPattern string() {
        StringPattern stringPattern = StringPattern.STRING_PATTERN;
        if (stringPattern == null) {
            StandardPatterns.$$$reportNull$$$0(0);
        }
        return stringPattern;
    }

    @NotNull
    public static CharPattern character() {
        return new CharPattern();
    }

    @NotNull
    public static <T> ObjectPattern.Capture<T> instanceOf(@NotNull Class<T> aClass) {
        if (aClass == null) {
            StandardPatterns.$$$reportNull$$$0(1);
        }
        return new ObjectPattern.Capture<T>(aClass);
    }

    @SafeVarargs
    @NotNull
    public static <T> ElementPattern<T> instanceOf(Class<T> ... classes) {
        if (classes == null) {
            StandardPatterns.$$$reportNull$$$0(2);
        }
        ElementPattern[] patterns = ContainerUtil.map(classes, StandardPatterns::instanceOf, new ElementPattern[0]);
        return StandardPatterns.or(patterns);
    }

    @NotNull
    public static <T> ElementPattern save(final Key<T> key) {
        return new ObjectPattern.Capture(new InitialPatternCondition(Object.class){

            @Override
            public boolean accepts(@Nullable Object o2, ProcessingContext context2) {
                context2.put(key, o2);
                return true;
            }

            @Override
            public void append(@NotNull @NonNls StringBuilder builder2, String indent) {
                if (builder2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                builder2.append("save(").append(key).append(")");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "ksp/com/intellij/patterns/StandardPatterns$1", "append"));
            }
        });
    }

    @NotNull
    public static ObjectPattern.Capture<Object> object() {
        return StandardPatterns.instanceOf(Object.class);
    }

    @NotNull
    public static <T> ObjectPattern.Capture<T> object(@NotNull T value2) {
        if (value2 == null) {
            StandardPatterns.$$$reportNull$$$0(3);
        }
        ObjectPattern.Capture capture = (ObjectPattern.Capture)StandardPatterns.instanceOf(value2.getClass()).equalTo(value2);
        if (capture == null) {
            StandardPatterns.$$$reportNull$$$0(4);
        }
        return capture;
    }

    @NotNull
    public static <T> CollectionPattern<T> collection(Class<T> aClass) {
        return new CollectionPattern();
    }

    @NotNull
    public static ElementPattern get(final @NotNull @NonNls String key) {
        if (key == null) {
            StandardPatterns.$$$reportNull$$$0(5);
        }
        return new ObjectPattern.Capture(new InitialPatternCondition(Object.class){

            @Override
            public boolean accepts(@Nullable Object o2, ProcessingContext context2) {
                return Comparing.equal(o2, context2.get(key));
            }

            @Override
            public void append(@NotNull @NonNls StringBuilder builder2, String indent) {
                if (builder2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                builder2.append("get(").append(key).append(")");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "ksp/com/intellij/patterns/StandardPatterns$2", "append"));
            }
        });
    }

    @NotNull
    public static <T> CollectionPattern<T> collection() {
        return new CollectionPattern();
    }

    @SafeVarargs
    @NotNull
    public static <E> ElementPattern<E> or(final ElementPattern<? extends E> ... patterns) {
        if (patterns == null) {
            StandardPatterns.$$$reportNull$$$0(6);
        }
        return new ObjectPattern.Capture(new InitialPatternConditionPlus(Object.class){

            @Override
            public boolean accepts(@Nullable Object o2, ProcessingContext context2) {
                for (ElementPattern pattern : patterns) {
                    if (!pattern.accepts(o2, context2)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void append(@NotNull @NonNls StringBuilder builder2, String indent) {
                if (builder2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                boolean first = true;
                for (ElementPattern pattern : patterns) {
                    if (!first) {
                        builder2.append("\n").append(indent);
                    }
                    first = false;
                    pattern.getCondition().append(builder2, indent + "  ");
                }
            }

            @Override
            public List<ElementPattern<?>> getPatterns() {
                return Arrays.asList(patterns);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "ksp/com/intellij/patterns/StandardPatterns$3", "append"));
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    @NotNull
    public static <E> ElementPattern<E> and(ElementPattern<? extends E> ... patterns) {
        void var5_8;
        SmartList<InitialPatternCondition<? extends E>> initial = new SmartList<InitialPatternCondition<? extends E>>();
        for (ElementPattern<E> elementPattern : patterns) {
            initial.add(elementPattern.getCondition().getInitialCondition());
        }
        ObjectPattern.Capture result2 = StandardPatterns.composeInitialConditions(initial);
        ElementPattern<? extends E>[] elementPatternArray = patterns;
        int n2 = elementPatternArray.length;
        boolean bl2 = false;
        while (var5_8 < n2) {
            ElementPattern<E> elementPattern = elementPatternArray[var5_8];
            for (PatternCondition<? extends E> patternCondition : elementPattern.getCondition().getConditions()) {
                result2 = (ObjectPattern.Capture)result2.with(patternCondition);
            }
            ++var5_8;
        }
        ObjectPattern.Capture capture = result2;
        if (capture == null) {
            StandardPatterns.$$$reportNull$$$0(7);
        }
        return capture;
    }

    @NotNull
    private static <E> ObjectPattern.Capture<E> composeInitialConditions(final List<? extends InitialPatternCondition> initial) {
        return new ObjectPattern.Capture(new InitialPatternCondition(Object.class){

            @Override
            public boolean accepts(@Nullable Object o2, ProcessingContext context2) {
                for (InitialPatternCondition pattern : initial) {
                    if (pattern.accepts(o2, context2)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public void append(@NotNull @NonNls StringBuilder builder2, String indent) {
                if (builder2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                boolean first = true;
                for (InitialPatternCondition pattern : initial) {
                    if (!first) {
                        builder2.append("\n").append(indent);
                    }
                    first = false;
                    pattern.append(builder2, indent + "  ");
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "ksp/com/intellij/patterns/StandardPatterns$4", "append"));
            }
        });
    }

    @NotNull
    public static <E> ObjectPattern.Capture<E> not(final ElementPattern<E> pattern) {
        return new ObjectPattern.Capture(new InitialPatternConditionPlus(Object.class){

            @Override
            public boolean accepts(@Nullable Object o2, ProcessingContext context2) {
                return !pattern.accepts(o2, context2);
            }

            @Override
            public void append(@NotNull @NonNls StringBuilder builder2, String indent) {
                if (builder2 == null) {
                    5.$$$reportNull$$$0(0);
                }
                pattern.getCondition().append(builder2.append("not("), indent + "  ");
                builder2.append(")");
            }

            @Override
            public List<ElementPattern<?>> getPatterns() {
                return Collections.singletonList(pattern);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "ksp/com/intellij/patterns/StandardPatterns$5", "append"));
            }
        });
    }

    @NotNull
    public static <T> ObjectPattern.Capture<T> optional(final ElementPattern<T> pattern) {
        return new ObjectPattern.Capture(new InitialPatternCondition(Object.class){

            @Override
            public boolean accepts(@Nullable Object o2, ProcessingContext context2) {
                pattern.accepts(o2, context2);
                return true;
            }
        });
    }

    @NotNull
    public static <E> ElementPattern<E> alwaysFalse() {
        FalsePattern falsePattern = FALSE_PATTERN;
        if (falsePattern == null) {
            StandardPatterns.$$$reportNull$$$0(8);
        }
        return falsePattern;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/patterns/StandardPatterns";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "string";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/patterns/StandardPatterns";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "object";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "and";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "alwaysFalse";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "instanceOf";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "object";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "or";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class FalsePattern
    implements ElementPattern {
        private FalsePattern() {
        }

        @Override
        public boolean accepts(@Nullable Object o2) {
            return false;
        }

        @Override
        public boolean accepts(@Nullable Object o2, ProcessingContext context2) {
            return false;
        }

        public ElementPatternCondition getCondition() {
            return new ElementPatternCondition(new InitialPatternCondition(Object.class){

                @Override
                public boolean accepts(@Nullable Object o2, ProcessingContext context2) {
                    return false;
                }
            });
        }
    }
}

