/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.openapi.extensions.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.intellij.openapi.Disposable;
import ksp.com.intellij.openapi.components.ComponentManager;
import ksp.com.intellij.openapi.extensions.BaseExtensionPointName;
import ksp.com.intellij.openapi.extensions.DefaultPluginDescriptor;
import ksp.com.intellij.openapi.extensions.ExtensionPoint;
import ksp.com.intellij.openapi.extensions.ExtensionPointDescriptor;
import ksp.com.intellij.openapi.extensions.ExtensionPointName;
import ksp.com.intellij.openapi.extensions.ExtensionsArea;
import ksp.com.intellij.openapi.extensions.PluginDescriptor;
import ksp.com.intellij.openapi.extensions.PluginId;
import ksp.com.intellij.openapi.extensions.impl.BeanExtensionPoint;
import ksp.com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import ksp.com.intellij.openapi.extensions.impl.ExtensionsAreaImplKt;
import ksp.com.intellij.openapi.extensions.impl.InterfaceExtensionPoint;
import ksp.com.intellij.openapi.util.Disposer;
import ksp.com.intellij.util.containers.UtilKt;
import ksp.org.jdom.Element;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0006\u0010\u0016\u001a\u00020\u0012J@\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00180\u000b\"\b\b\u0000\u0010\u0018*\u00020\r2\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0003J&\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001f\"\b\b\u0000\u0010\u0018*\u00020\r2\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u00180!H\u0016J \u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u00180\u000b\"\b\b\u0000\u0010\u0018*\u00020\r2\u0006\u0010 \u001a\u00020\u0007H\u0016J\"\u0010\"\u001a\n\u0012\u0004\u0012\u0002H\u0018\u0018\u00010\u000b\"\b\b\u0000\u0010\u0018*\u00020\r2\u0006\u0010 \u001a\u00020\u0007H\u0016J\u0014\u0010#\u001a\u00020\u001c2\n\u0010 \u001a\u0006\u0012\u0002\b\u00030!H\u0016J\u0010\u0010#\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u0007H\u0016J\u0012\u0010$\u001a\u00020\u00122\b\u0010%\u001a\u0004\u0018\u00010\u0000H\u0007J \u0010&\u001a\u00020\u00122\u0016\u0010'\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u0004\u0012\u00020\u00120(H\u0017J,\u0010)\u001a\u00020\u00122\n\u0010*\u001a\u0006\u0012\u0002\b\u00030+2\u0006\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0007J(\u0010)\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u00072\u0006\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020.2\u0006\u00101\u001a\u00020\u001cH\u0017J\u001e\u00102\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\f\u00103\u001a\b\u0012\u0004\u0012\u00020504H\u0007J\u001c\u00102\u001a\u00020\u00122\f\u00106\u001a\b\u0012\u0004\u0012\u000207042\u0006\u0010\u0014\u001a\u00020\u0015J(\u00108\u001a\b\u0012\u0004\u0012\u0002H\u00180\u000b\"\b\b\u0000\u0010\u0018*\u00020\r2\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J>\u00109\u001a\b\u0012\u0004\u0012\u0002H\u00180\u000b\"\b\b\u0000\u0010\u0018*\u00020\r2\u0006\u0010\u0019\u001a\u00020\u00072\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00180:2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u00101\u001a\u00020\u001cH\u0007J\u001e\u0010;\u001a\u00020\u00122\u0016\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\nJ\u001c\u0010<\u001a\u00020\u00122\f\u0010=\u001a\b\u0012\u0004\u0012\u000207042\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010>\u001a\u00020\u0007H\u0016J\u0010\u0010?\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u0007H\u0017J\u001c\u0010@\u001a\u00020\u00122\f\u0010=\u001a\b\u0012\u0004\u0012\u000207042\u0006\u0010\u0014\u001a\u00020\u0015J6\u0010A\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u000e\u0010B\u001a\n\u0012\u0006\b\u0000\u0012\u00020D0C2\u000e\u0010E\u001a\n\u0012\u0006\b\u0000\u0012\u00020D0CR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006F"}, d2={"Lksp/com/intellij/openapi/extensions/impl/ExtensionsAreaImpl;", "Lksp/com/intellij/openapi/extensions/ExtensionsArea;", "componentManager", "Lksp/com/intellij/openapi/components/ComponentManager;", "(Lcom/intellij/openapi/components/ComponentManager;)V", "epTraces", "Ljava/util/HashMap;", "", "", "extensionPoints", "", "Lksp/com/intellij/openapi/extensions/impl/ExtensionPointImpl;", "lock", "", "nameToPointMap", "getNameToPointMap", "()Ljava/util/Map;", "checkThatPointNotDuplicated", "", "pointName", "pluginDescriptor", "Lksp/com/intellij/openapi/extensions/PluginDescriptor;", "clearUserCache", "doRegisterExtensionPoint", "T", "name", "extensionClass", "isInterface", "", "dynamic", "getExtensionPoint", "Lksp/com/intellij/openapi/extensions/ExtensionPoint;", "extensionPointName", "Lksp/com/intellij/openapi/extensions/ExtensionPointName;", "getExtensionPointIfRegistered", "hasExtensionPoint", "notifyAreaReplaced", "newArea", "processExtensionPoints", "consumer", "Lkotlin/Function1;", "registerExtensionPoint", "extensionPoint", "Lksp/com/intellij/openapi/extensions/BaseExtensionPointName;", "extensionPointBeanClass", "kind", "Lksp/com/intellij/openapi/extensions/ExtensionPoint$Kind;", "parentDisposable", "Lksp/com/intellij/openapi/Disposable;", "isDynamic", "registerExtensionPoints", "extensionPointElements", "", "Lksp/org/jdom/Element;", "points", "Lksp/com/intellij/openapi/extensions/ExtensionPointDescriptor;", "registerFakeBeanPoint", "registerPoint", "Ljava/lang/Class;", "reset", "resetExtensionPoints", "descriptors", "toString", "unregisterExtensionPoint", "unregisterExtensionPoints", "unregisterExtensions", "priorityListenerCallbacks", "", "Ljava/lang/Runnable;", "listenerCallbacks", "intellij.platform.extensions"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nExtensionsAreaImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtensionsAreaImpl.kt\ncom/intellij/openapi/extensions/impl/ExtensionsAreaImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,306:1\n1855#2,2:307\n*S KotlinDebug\n*F\n+ 1 ExtensionsAreaImpl.kt\ncom/intellij/openapi/extensions/impl/ExtensionsAreaImpl\n*L\n287#1:307,2\n*E\n"})
public final class ExtensionsAreaImpl
implements ExtensionsArea {
    @NotNull
    private final ComponentManager componentManager;
    @NotNull
    private volatile Map<String, ? extends ExtensionPointImpl<?>> extensionPoints;
    @Nullable
    private final HashMap<String, Throwable> epTraces;
    @NotNull
    private final Object lock;

    public ExtensionsAreaImpl(@NotNull ComponentManager componentManager) {
        Intrinsics.checkNotNullParameter((Object)componentManager, (String)"componentManager");
        this.componentManager = componentManager;
        Map map = Collections.emptyMap();
        Intrinsics.checkNotNullExpressionValue(map, (String)"emptyMap(...)");
        this.extensionPoints = map;
        this.epTraces = null;
        this.lock = new Object();
    }

    @Override
    @NotNull
    public Map<String, ExtensionPointImpl<?>> getNameToPointMap() {
        return this.extensionPoints;
    }

    public final void reset(@NotNull Map<String, ? extends ExtensionPointImpl<?>> nameToPointMap) {
        Intrinsics.checkNotNullParameter(nameToPointMap, (String)"nameToPointMap");
        this.extensionPoints = nameToPointMap;
    }

    @TestOnly
    public final void notifyAreaReplaced(@Nullable ExtensionsAreaImpl newArea) {
        HashSet<String> processedEPs = new HashSet<String>(this.extensionPoints.size());
        for (ExtensionPointImpl<?> point : this.extensionPoints.values()) {
            point.notifyAreaReplaced(this);
            processedEPs.add(point.name);
        }
        if (newArea == null) {
            return;
        }
        for (ExtensionPointImpl<?> point : newArea.extensionPoints.values()) {
            if (processedEPs.contains(point.name)) continue;
            point.notifyAreaReplaced(this);
        }
    }

    @TestOnly
    public final void registerExtensionPoints(@NotNull PluginDescriptor pluginDescriptor, @NotNull List<? extends Element> extensionPointElements) {
        Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
        Intrinsics.checkNotNullParameter(extensionPointElements, (String)"extensionPointElements");
        for (Element element2 : extensionPointElements) {
            String pointName = element2.getAttributeValue("qualifiedName");
            if (pointName == null) {
                String string = element2.getAttributeValue("name");
                if (string == null) {
                    RuntimeException runtimeException = this.componentManager.createError("'name' attribute not specified for extension point in '" + pluginDescriptor + "' plugin", pluginDescriptor.getPluginId());
                    Intrinsics.checkNotNullExpressionValue((Object)runtimeException, (String)"createError(...)");
                    throw (Throwable)runtimeException;
                }
                String name2 = string;
                pointName = pluginDescriptor.getPluginId().getIdString() + '.' + name2;
            }
            String beanClassName = element2.getAttributeValue("beanClass");
            String interfaceClassName = element2.getAttributeValue("interface");
            if (beanClassName == null && interfaceClassName == null) {
                RuntimeException runtimeException = this.componentManager.createError("Neither 'beanClass' nor 'interface' attribute is specified for extension point '" + pointName + "' in '" + pluginDescriptor + "' plugin", pluginDescriptor.getPluginId());
                Intrinsics.checkNotNullExpressionValue((Object)runtimeException, (String)"createError(...)");
                throw (Throwable)runtimeException;
            }
            if (beanClassName != null && interfaceClassName != null) {
                RuntimeException runtimeException = this.componentManager.createError("Both 'beanClass' and 'interface' attributes are specified for extension point '" + pointName + "' in '" + pluginDescriptor + "' plugin", pluginDescriptor.getPluginId());
                Intrinsics.checkNotNullExpressionValue((Object)runtimeException, (String)"createError(...)");
                throw (Throwable)runtimeException;
            }
            boolean dynamic = Boolean.parseBoolean(element2.getAttributeValue("dynamic"));
            String string = pointName;
            Intrinsics.checkNotNull((Object)string);
            String string2 = string;
            String string3 = interfaceClassName;
            if (string3 == null) {
                string3 = beanClassName;
            }
            string = string3;
            Intrinsics.checkNotNull((Object)string);
            this.doRegisterExtensionPoint(string2, string, pluginDescriptor, interfaceClassName != null, dynamic);
        }
    }

    public final boolean unregisterExtensions(@NotNull String extensionPointName, @NotNull PluginDescriptor pluginDescriptor, @NotNull List<? super Runnable> priorityListenerCallbacks, @NotNull List<? super Runnable> listenerCallbacks) {
        Intrinsics.checkNotNullParameter((Object)extensionPointName, (String)"extensionPointName");
        Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
        Intrinsics.checkNotNullParameter(priorityListenerCallbacks, (String)"priorityListenerCallbacks");
        Intrinsics.checkNotNullParameter(listenerCallbacks, (String)"listenerCallbacks");
        ExtensionPointImpl<?> extensionPointImpl = this.extensionPoints.get(extensionPointName);
        if (extensionPointImpl == null) {
            return false;
        }
        ExtensionPointImpl<?> point = extensionPointImpl;
        point.unregisterExtensions(this.componentManager, pluginDescriptor, priorityListenerCallbacks, listenerCallbacks);
        return true;
    }

    public final void resetExtensionPoints(@NotNull List<ExtensionPointDescriptor> descriptors, @NotNull PluginDescriptor pluginDescriptor) {
        Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
        Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
        for (ExtensionPointDescriptor descriptor2 : descriptors) {
            ExtensionPointImpl<?> extensionPointImpl = this.extensionPoints.get(descriptor2.getQualifiedName(pluginDescriptor));
            if (extensionPointImpl == null) continue;
            extensionPointImpl.reset();
        }
    }

    public final void clearUserCache() {
        for (ExtensionPointImpl<?> point : this.extensionPoints.values()) {
            point.clearUserCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unregisterExtensionPoints(@NotNull List<ExtensionPointDescriptor> descriptors, @NotNull PluginDescriptor pluginDescriptor) {
        Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
        Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
        if (descriptors.isEmpty()) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            boolean bl2 = false;
            for (ExtensionPointDescriptor descriptor2 : descriptors) {
                this.extensionPoints = UtilKt.without(this.extensionPoints, descriptor2.getQualifiedName(pluginDescriptor));
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @TestOnly
    public final void registerExtensionPoint(@NotNull BaseExtensionPointName<?> extensionPoint, @NotNull String extensionPointBeanClass, @NotNull ExtensionPoint.Kind kind, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter(extensionPoint, (String)"extensionPoint");
        Intrinsics.checkNotNullParameter((Object)extensionPointBeanClass, (String)"extensionPointBeanClass");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        String extensionPointName = extensionPoint.getName();
        this.registerExtensionPoint(extensionPointName, extensionPointBeanClass, kind, false);
        Disposer.register(parentDisposable, () -> ExtensionsAreaImpl.registerExtensionPoint$lambda$1(this, extensionPointName));
    }

    @Override
    @TestOnly
    public void registerExtensionPoint(@NotNull String extensionPointName, @NotNull String extensionPointBeanClass, @NotNull ExtensionPoint.Kind kind, boolean isDynamic) {
        Intrinsics.checkNotNullParameter((Object)extensionPointName, (String)"extensionPointName");
        Intrinsics.checkNotNullParameter((Object)extensionPointBeanClass, (String)"extensionPointBeanClass");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        DefaultPluginDescriptor pluginDescriptor = new DefaultPluginDescriptor(PluginId.getId("fakeIdForTests"));
        this.doRegisterExtensionPoint(extensionPointName, extensionPointBeanClass, pluginDescriptor, kind == ExtensionPoint.Kind.INTERFACE, isDynamic);
    }

    @TestOnly
    @NotNull
    public final <T> ExtensionPointImpl<T> registerPoint(@NotNull String name2, @NotNull Class<T> extensionClass, @NotNull PluginDescriptor pluginDescriptor, boolean isDynamic) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(extensionClass, (String)"extensionClass");
        Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
        String string = extensionClass.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return this.doRegisterExtensionPoint(name2, string, pluginDescriptor, extensionClass.isInterface() || (extensionClass.getModifiers() & 0x400) != 0, isDynamic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    private final <T> ExtensionPointImpl<T> doRegisterExtensionPoint(String name2, String extensionClass, PluginDescriptor pluginDescriptor, boolean isInterface, boolean dynamic) {
        ExtensionPointImpl extensionPointImpl;
        if (isInterface) {
            ComponentManager componentManager = this.componentManager;
            extensionPointImpl = new InterfaceExtensionPoint(name2, extensionClass, pluginDescriptor, componentManager, null, dynamic, false);
        } else {
            extensionPointImpl = new BeanExtensionPoint(name2, extensionClass, pluginDescriptor, this.componentManager, dynamic);
        }
        ExtensionPointImpl point = extensionPointImpl;
        this.checkThatPointNotDuplicated(name2, point.getPluginDescriptor());
        Object object = this.lock;
        synchronized (object) {
            boolean bl2 = false;
            this.extensionPoints = UtilKt.with(this.extensionPoints, name2, point);
            Unit unit = Unit.INSTANCE;
        }
        return point;
    }

    @TestOnly
    @NotNull
    public final <T> ExtensionPointImpl<T> registerFakeBeanPoint(@NotNull String name2, @NotNull PluginDescriptor pluginDescriptor) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
        String string = Object.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return this.doRegisterExtensionPoint(name2, string, pluginDescriptor, false, false);
    }

    private final void checkThatPointNotDuplicated(String pointName, PluginDescriptor pluginDescriptor) {
        ExtensionPointImpl<?> extensionPointImpl = this.extensionPoints.get(pointName);
        if (extensionPointImpl == null) {
            return;
        }
        PluginId pluginId = extensionPointImpl.getPluginDescriptor().getPluginId();
        Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"getPluginId(...)");
        PluginId id1 = pluginId;
        PluginId pluginId2 = pluginDescriptor.getPluginId();
        Intrinsics.checkNotNullExpressionValue((Object)pluginId2, (String)"getPluginId(...)");
        PluginId id2 = pluginId2;
        String message = "Duplicate registration for EP '" + pointName + "': first in " + id1 + ", second in " + id2;
        RuntimeException runtimeException = this.componentManager.createError(message, pluginDescriptor.getPluginId());
        Intrinsics.checkNotNullExpressionValue((Object)runtimeException, (String)"createError(...)");
        throw (Throwable)runtimeException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerExtensionPoints(@NotNull List<ExtensionPointDescriptor> points, @NotNull PluginDescriptor pluginDescriptor) {
        Intrinsics.checkNotNullParameter(points, (String)"points");
        Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
        HashMap map = new HashMap();
        ExtensionsAreaImplKt.createExtensionPoints(points, this.componentManager, map, pluginDescriptor);
        Object object = this.lock;
        synchronized (object) {
            boolean bl2 = false;
            this.extensionPoints = UtilKt.withAll(this.extensionPoints, map);
            Unit unit = Unit.INSTANCE;
        }
    }

    @NotNull
    public <T> ExtensionPointImpl<T> getExtensionPoint(@NotNull String extensionPointName) {
        Intrinsics.checkNotNullParameter((Object)extensionPointName, (String)"extensionPointName");
        ExtensionPoint extensionPoint = this.getExtensionPointIfRegistered(extensionPointName);
        if (extensionPoint == null) {
            throw new IllegalArgumentException("Missing extension point: " + extensionPointName + " in container " + this.componentManager);
        }
        return extensionPoint;
    }

    @Nullable
    public <T> ExtensionPointImpl<T> getExtensionPointIfRegistered(@NotNull String extensionPointName) {
        Intrinsics.checkNotNullParameter((Object)extensionPointName, (String)"extensionPointName");
        return this.extensionPoints.get(extensionPointName);
    }

    @Override
    @NotNull
    public <T> ExtensionPoint<T> getExtensionPoint(@NotNull ExtensionPointName<T> extensionPointName) {
        Intrinsics.checkNotNullParameter(extensionPointName, (String)"extensionPointName");
        return this.getExtensionPoint(extensionPointName.getName());
    }

    @Override
    @TestOnly
    public void processExtensionPoints(@NotNull Function1<? super ExtensionPointImpl<?>, Unit> consumer2) {
        Intrinsics.checkNotNullParameter(consumer2, (String)"consumer");
        Iterable $this$forEach$iv = this.extensionPoints.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            consumer2.invoke(element$iv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TestOnly
    public void unregisterExtensionPoint(@NotNull String extensionPointName) {
        Intrinsics.checkNotNullParameter((Object)extensionPointName, (String)"extensionPointName");
        ExtensionPoint extensionPoint = this.getExtensionPointIfRegistered(extensionPointName);
        if (extensionPoint == null) {
            return;
        }
        ExtensionPoint extensionPoint2 = extensionPoint;
        ((ExtensionPointImpl)extensionPoint2).reset();
        Object object = this.lock;
        synchronized (object) {
            boolean bl2 = false;
            this.extensionPoints = UtilKt.without(this.extensionPoints, extensionPointName);
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public boolean hasExtensionPoint(@NotNull String extensionPointName) {
        Intrinsics.checkNotNullParameter((Object)extensionPointName, (String)"extensionPointName");
        return this.extensionPoints.containsKey(extensionPointName);
    }

    @Override
    public boolean hasExtensionPoint(@NotNull ExtensionPointName<?> extensionPointName) {
        Intrinsics.checkNotNullParameter(extensionPointName, (String)"extensionPointName");
        return this.hasExtensionPoint(extensionPointName.getName());
    }

    @NotNull
    public String toString() {
        return this.componentManager.toString();
    }

    private static final void registerExtensionPoint$lambda$1(ExtensionsAreaImpl this$0, String $extensionPointName) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$extensionPointName, (String)"$extensionPointName");
        this$0.unregisterExtensionPoint($extensionPointName);
    }
}

