/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.js.backend.ast;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsName;
import ksp.org.jetbrains.kotlin.js.util.Maps;

public abstract class JsScope {
    @NotNull
    private final String description;
    private Map<String, JsName> names;
    private final JsScope parent;

    public JsScope(JsScope parent2, @NotNull String description) {
        if (description == null) {
            JsScope.$$$reportNull$$$0(0);
        }
        this.names = Collections.emptyMap();
        this.description = description;
        this.parent = parent2;
    }

    protected JsScope(@NotNull String description) {
        if (description == null) {
            JsScope.$$$reportNull$$$0(1);
        }
        this.names = Collections.emptyMap();
        this.description = description;
        this.parent = null;
    }

    @NotNull
    public JsName declareName(@NotNull String identifier) {
        JsName name2;
        if (identifier == null) {
            JsScope.$$$reportNull$$$0(2);
        }
        JsName jsName = (name2 = this.findOwnName(identifier)) != null ? name2 : this.doCreateName(identifier);
        if (jsName == null) {
            JsScope.$$$reportNull$$$0(3);
        }
        return jsName;
    }

    @NotNull
    public static JsName declareTemporaryName(@NotNull String suggestedName) {
        if (suggestedName == null) {
            JsScope.$$$reportNull$$$0(4);
        }
        assert (!suggestedName.isEmpty());
        return new JsName(suggestedName, true);
    }

    @Nullable
    public final JsName findName(@NotNull String ident) {
        JsName name2;
        if (ident == null) {
            JsScope.$$$reportNull$$$0(5);
        }
        if ((name2 = this.findOwnName(ident)) == null && this.parent != null) {
            return this.parent.findName(ident);
        }
        return name2;
    }

    public boolean hasOwnName(@NotNull String name2) {
        if (name2 == null) {
            JsScope.$$$reportNull$$$0(6);
        }
        return this.names.containsKey(name2);
    }

    private boolean hasName(@NotNull String name2) {
        if (name2 == null) {
            JsScope.$$$reportNull$$$0(7);
        }
        return this.hasOwnName(name2) || this.parent != null && this.parent.hasName(name2);
    }

    public final JsScope getParent() {
        return this.parent;
    }

    public final String toString() {
        if (this.parent != null) {
            return this.description + "->" + this.parent;
        }
        return this.description;
    }

    public void copyOwnNames(JsScope other) {
        if (!other.names.isEmpty()) {
            this.names = new HashMap<String, JsName>(this.names);
            this.names.putAll(other.names);
        }
    }

    @NotNull
    public String getDescription() {
        String string = this.description;
        if (string == null) {
            JsScope.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    protected JsName doCreateName(@NotNull String ident) {
        if (ident == null) {
            JsScope.$$$reportNull$$$0(9);
        }
        JsName name2 = new JsName(ident, false);
        this.names = Maps.put(this.names, ident, name2);
        JsName jsName = name2;
        if (jsName == null) {
            JsScope.$$$reportNull$$$0(10);
        }
        return jsName;
    }

    protected JsName findOwnName(@NotNull String ident) {
        if (ident == null) {
            JsScope.$$$reportNull$$$0(11);
        }
        return this.names.get(ident);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 8: 
            case 10: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 3: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/org/jetbrains/kotlin/js/backend/ast/JsScope";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suggestedName";
                break;
            }
            case 5: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ident";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/org/jetbrains/kotlin/js/backend/ast/JsScope";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "declareName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "declareName";
                break;
            }
            case 3: 
            case 8: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "declareTemporaryName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasOwnName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "hasName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doCreateName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findOwnName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

