/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.descriptors.ClassKind;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.fir.FirPureAbstractElement;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.EnumEntryInitializationCheckProcessor;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.EnumEntryInitializationInfoData;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import ksp.org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import ksp.org.jetbrains.kotlin.fir.expressions.FirAnonymousObjectExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.references.FirControlFlowGraphReference;
import ksp.org.jetbrains.kotlin.fir.resolve.dfa.FirControlFlowGraphReferenceImplKt;
import ksp.org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import ksp.org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirEnumEntrySymbol;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ.\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0002J&\u0010\u0014\u001a\u00020\u00072\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a8\u0006\u0018"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirEnumEntryInitializationChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "<init>", "()V", "check", "", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;)V", "checkClass", "klass", "Lksp/org/jetbrains/kotlin/fir/declarations/FirClass;", "enumEntrySymbols", "", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirEnumEntrySymbol;", "checkEnumEntries", "enumEntries", "", "Lksp/org/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirEnumEntryInitializationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirEnumEntryInitializationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirEnumEntryInitializationChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,118:1\n70#2:119\n37#3:120\n1634#4,3:121\n1634#4,3:124\n*S KotlinDebug\n*F\n+ 1 FirEnumEntryInitializationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirEnumEntryInitializationChecker\n*L\n36#1:119\n36#1:120\n40#1:121,3\n57#1:124,3\n*E\n"})
public final class FirEnumEntryInitializationChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirEnumEntryInitializationChecker INSTANCE = new FirEnumEntryInitializationChecker();

    private FirEnumEntryInitializationChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirRegularClass declaration2) {
        void destination$iv;
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        FirClass $this$isEnumClass$iv = declaration2;
        boolean $i$f$isEnumClass = false;
        Object $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
        boolean $i$f$isEnumClass22 = false;
        if (!($this$isEnumClass$iv$iv == ClassKind.ENUM_CLASS)) {
            return;
        }
        if (!context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.ProperUninitializedEnumEntryAccessAnalysis)) {
            return;
        }
        List<FirEnumEntry> enumEntries = DeclarationUtilsKt.collectEnumEntries(declaration2, context2.getSession());
        if (enumEntries.isEmpty()) {
            return;
        }
        $this$isEnumClass$iv$iv = enumEntries;
        Collection $i$f$isEnumClass22 = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            FirEnumEntry firEnumEntry = (FirEnumEntry)item$iv;
            void var13_15 = destination$iv;
            boolean bl2 = false;
            var13_15.add(it.getSymbol());
        }
        Set enumEntrySymbols = (Set)destination$iv;
        this.checkClass(declaration2, enumEntrySymbols, context2, reporter);
        this.checkEnumEntries(enumEntries, context2, reporter);
    }

    private final void checkClass(FirClass klass, Set<FirEnumEntrySymbol> enumEntrySymbols, CheckerContext context2, DiagnosticReporter reporter) {
        Object object = klass.getControlFlowGraphReference();
        if (object == null || (object = FirControlFlowGraphReferenceImplKt.getControlFlowGraph((FirControlFlowGraphReference)object)) == null) {
            return;
        }
        Object graph2 = object;
        EnumEntryInitializationInfoData data = new EnumEntryInitializationInfoData(enumEntrySymbols, (FirBasedSymbol)klass.getSymbol(), (ControlFlowGraph)graph2);
        EnumEntryInitializationCheckProcessor.INSTANCE.check(data, true, context2, reporter);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkEnumEntries(List<? extends FirEnumEntry> enumEntries, CheckerContext context2, DiagnosticReporter reporter) {
        void $this$mapTo$iv;
        Iterable iterable = enumEntries;
        Collection collection = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            FirEnumEntry firEnumEntry = (FirEnumEntry)item$iv;
            Collection collection2 = collection;
            boolean bl2 = false;
            collection2.add(it.getSymbol());
        }
        Set enumEntrySymbols = (Set)collection;
        for (FirEnumEntry firEnumEntry : enumEntries) {
            FirExpression firExpression = firEnumEntry.getInitializer();
            FirPureAbstractElement firPureAbstractElement = firExpression instanceof FirAnonymousObjectExpression ? (FirAnonymousObjectExpression)firExpression : null;
            if (firPureAbstractElement == null || (firPureAbstractElement = firPureAbstractElement.getAnonymousObject()) == null) continue;
            FirPureAbstractElement entryObject = firPureAbstractElement;
            this.checkClass((FirClass)entryObject, enumEntrySymbols, context2, reporter);
            enumEntrySymbols.remove(firEnumEntry.getSymbol());
        }
    }
}

