/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.openapi.application;

import java.time.ZonedDateTime;
import java.util.Calendar;
import ksp.com.intellij.diagnostic.LoadingState;
import ksp.com.intellij.openapi.application.ApplicationManager;
import ksp.com.intellij.openapi.extensions.PluginId;
import ksp.com.intellij.openapi.util.BuildNumber;
import ksp.com.intellij.openapi.util.NlsSafe;
import ksp.com.intellij.openapi.util.text.StringUtil;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public abstract class ApplicationInfo {
    public static ApplicationInfo getInstance() {
        return ApplicationManager.getApplication().getService(ApplicationInfo.class);
    }

    public abstract Calendar getBuildDate();

    @ApiStatus.Internal
    @ApiStatus.Experimental
    @NotNull
    public abstract ZonedDateTime getBuildTime();

    @NotNull
    public abstract BuildNumber getBuild();

    @NotNull
    public abstract String getApiVersion();

    public abstract String getMajorVersion();

    public abstract String getMinorVersion();

    public abstract String getMicroVersion();

    public abstract String getPatchVersion();

    @NlsSafe
    public abstract String getVersionName();

    @NlsSafe
    public final String getMinorVersionMainPart() {
        String value2 = StringUtil.substringBefore(this.getMinorVersion(), ".");
        return value2 == null ? this.getMinorVersion() : value2;
    }

    @NlsSafe
    public abstract String getCompanyName();

    @NlsSafe
    public abstract String getShortCompanyName();

    public abstract String getCompanyURL();

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @Nullable
    public abstract String getProductUrl();

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @Nullable
    public abstract String getJetBrainsTvUrl();

    public abstract boolean hasHelp();

    public abstract boolean hasContextHelp();

    @NlsSafe
    @NotNull
    public abstract String getFullVersion();

    @NlsSafe
    public final String getShortVersion() {
        return this.getMajorVersion() + '.' + this.getMinorVersionMainPart();
    }

    @NlsSafe
    @NotNull
    public abstract String getStrictVersion();

    public static boolean helpAvailable() {
        if (!LoadingState.COMPONENTS_LOADED.isOccurred()) {
            return false;
        }
        ApplicationInfo info = ApplicationInfo.getInstance();
        return info != null && info.hasHelp();
    }

    public static boolean contextHelpAvailable() {
        if (!LoadingState.COMPONENTS_LOADED.isOccurred()) {
            return false;
        }
        ApplicationInfo info = ApplicationInfo.getInstance();
        return info != null && info.hasContextHelp();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public String getBuildNumber() {
        return this.getBuild().asString();
    }

    public boolean isEAP() {
        return false;
    }

    public abstract String getFullApplicationName();

    @Nullable
    public String getSplashImageUrl() {
        return null;
    }

    @ApiStatus.Internal
    public abstract boolean isEssentialPlugin(@NotNull String var1);

    @ApiStatus.Internal
    public abstract boolean isEssentialPlugin(@NotNull PluginId var1);
}

