/*
 * Copyright 2010-2020 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.psi.stubs.elements

import ksp.com.intellij.psi.PsiElement
import ksp.com.intellij.psi.stubs.StubElement
import ksp.com.intellij.psi.stubs.StubInputStream
import ksp.com.intellij.psi.stubs.StubOutputStream
import ksp.org.jetbrains.kotlin.psi.KtContractEffect
import ksp.org.jetbrains.kotlin.psi.stubs.KotlinContractEffectStub
import ksp.org.jetbrains.kotlin.psi.stubs.impl.KotlinContractEffectStubImpl

class KtContractEffectElementType(debugName: String, psiClass: Class<KtContractEffect>) :
    KtStubElementType<KotlinContractEffectStub, KtContractEffect>(debugName, psiClass, KotlinContractEffectStub::class.java) {
    override fun serialize(stub: KotlinContractEffectStub, dataStream: StubOutputStream) {
    }

    override fun deserialize(dataStream: StubInputStream, parentStub: StubElement<PsiElement>?): KotlinContractEffectStub {
        return KotlinContractEffectStubImpl(parentStub, this)
    }

    override fun createStub(psi: KtContractEffect, parentStub: StubElement<*>?): KotlinContractEffectStub {
        return KotlinContractEffectStubImpl(parentStub, this)
    }
}
