/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.fir.builder

import ksp.com.intellij.psi.PsiElement
import ksp.org.jetbrains.kotlin.diagnostics.*
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1
import ksp.org.jetbrains.kotlin.diagnostics.Severity.ERROR
import ksp.org.jetbrains.kotlin.diagnostics.SourceElementPositioningStrategies
import ksp.org.jetbrains.kotlin.diagnostics.rendering.BaseDiagnosticRendererFactory
import ksp.org.jetbrains.kotlin.diagnostics.rendering.RootDiagnosticRendererFactory
import ksp.org.jetbrains.kotlin.fir.diagnostics.FirDiagnosticsContainer

/**
 * Generated from: [org.jetbrains.kotlin.fir.builder.SYNTAX_DIAGNOSTIC_LIST]
 */
@Suppress("IncorrectFormatting")
object FirSyntaxErrors : FirDiagnosticsContainer() {
    // Syntax
    val SYNTAX: KtDiagnosticFactory1<String> = KtDiagnosticFactory1("SYNTAX", ERROR, SourceElementPositioningStrategies.SYNTAX_ERROR, PsiElement::class)

    override fun getRendererFactory(): BaseDiagnosticRendererFactory = FirSyntaxErrorsDefaultMessages
}
