/*
 * Copyright 2010-2022 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.fir.analysis.checkers.type

import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter
import ksp.org.jetbrains.kotlin.fir.FirFunctionTypeParameter
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.syntax.FirSyntaxChecker
import ksp.org.jetbrains.kotlin.fir.types.FirFunctionTypeRef
import ksp.org.jetbrains.kotlin.psi.KtParameter

abstract class FirFunctionalTypeParameterSyntaxChecker : FirFunctionTypeRefChecker(
    MppCheckerKind.Common
), FirSyntaxChecker<FirFunctionTypeParameter, KtParameter> {
    context(context: CheckerContext, reporter: DiagnosticReporter)
    override fun check(typeRef: FirFunctionTypeRef) {
        for (parameter in typeRef.parameters) {
            checkSyntax(parameter, context, reporter)
        }
    }
}
