/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression

import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.isExplicitParentOfResolvedQualifier
import ksp.org.jetbrains.kotlin.fir.declarations.utils.isCompanion
import ksp.org.jetbrains.kotlin.fir.declarations.utils.visibility
import ksp.org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier

object FirInlineBodyResolvedQualifierChecker : FirResolvedQualifierChecker(MppCheckerKind.Common) {
    context(context: CheckerContext, reporter: DiagnosticReporter)
    override fun check(expression: FirResolvedQualifier) {
        val inlineFunctionBodyContext = context.inlineFunctionBodyContext ?: return
        val accessedClass = expression.symbol ?: return
        val source = expression.source ?: return
        if (accessedClass.isCompanion && !expression.isExplicitParentOfResolvedQualifier(context)) {
            inlineFunctionBodyContext.checkAccessedDeclaration(
                source, expression, accessedClass, accessedClass.visibility,
            )
        }
    }
}
