/*
 * Copyright 2010-2025 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.cli.common.arguments

import ksp.org.jetbrains.kotlin.config.LanguageFeature

/**
 * Instructs the annotated argument to disable the specified [org.jetbrains.kotlin.config.LanguageFeature] when set to `true`.
 */
@Target(AnnotationTarget.FIELD)
@Repeatable
annotation class Disables(val feature: LanguageFeature)
