// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package ksp.com.intellij.lang.jvm.util;

import ksp.com.intellij.lang.jvm.JvmClass;
import ksp.com.intellij.lang.jvm.JvmMethod;
import ksp.org.jetbrains.annotations.NotNull;

import java.util.List;

import static com.intellij.util.containers.ContainerUtil.filter;

/**
 * This class holds default implementations of {@link JvmClass} methods.
 */
public final class JvmClassDefaults {

  private JvmClassDefaults() {}

  public static JvmMethod @NotNull [] findMethodsByName(@NotNull JvmClass clazz, @NotNull String methodName) {
    List<JvmMethod> result = filter(clazz.getMethods(), it -> it.getName().equals(methodName));
    return result.toArray(JvmMethod.EMPTY_ARRAY);
  }
}
