/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.checkers;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.builtins.StandardNames;
import ksp.org.jetbrains.kotlin.config.LanguageVersionSettings;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassKind;
import ksp.org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.Modality;
import ksp.org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import ksp.org.jetbrains.kotlin.descriptors.annotations.KotlinRetention;
import ksp.org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.name.FqName;
import ksp.org.jetbrains.kotlin.psi.KtAnnotated;
import ksp.org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import ksp.org.jetbrains.kotlin.psi.KtAnnotationEntry;
import ksp.org.jetbrains.kotlin.psi.KtAnnotationUseSiteTarget;
import ksp.org.jetbrains.kotlin.psi.KtClassOrObject;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import ksp.org.jetbrains.kotlin.resolve.AdditionalAnnotationChecker;
import ksp.org.jetbrains.kotlin.resolve.AnnotationChecker;
import ksp.org.jetbrains.kotlin.resolve.BindingContext;
import ksp.org.jetbrains.kotlin.resolve.BindingTrace;
import ksp.org.jetbrains.kotlin.resolve.checkers.OptInDescription;
import ksp.org.jetbrains.kotlin.resolve.checkers.OptInMarkerDeclarationAnnotationChecker;
import ksp.org.jetbrains.kotlin.resolve.checkers.OptInNames;
import ksp.org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker;
import ksp.org.jetbrains.kotlin.resolve.checkers.OptInUsageCheckerUtilsKt;
import ksp.org.jetbrains.kotlin.resolve.constants.ConstantValue;
import ksp.org.jetbrains.kotlin.resolve.constants.KClassValue;
import ksp.org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import ksp.org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J>\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J2\u0010\u0013\u001a\u00020\u00072\u0010\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J<\u0010\u0019\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0010\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J2\u0010\u001a\u001a\u00020\u00072\u0010\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001e\u0010\u001b\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lksp/org/jetbrains/kotlin/resolve/checkers/OptInMarkerDeclarationAnnotationChecker;", "Lksp/org/jetbrains/kotlin/resolve/AdditionalAnnotationChecker;", "module", "Lksp/org/jetbrains/kotlin/descriptors/ModuleDescriptor;", "<init>", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;)V", "checkEntries", "", "entries", "", "Lksp/org/jetbrains/kotlin/psi/KtAnnotationEntry;", "actualTargets", "Lksp/org/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "trace", "Lksp/org/jetbrains/kotlin/resolve/BindingTrace;", "annotated", "Lksp/org/jetbrains/kotlin/psi/KtAnnotated;", "languageVersionSettings", "Lksp/org/jetbrains/kotlin/config/LanguageVersionSettings;", "checkOptInUsage", "annotationClasses", "Lksp/org/jetbrains/kotlin/resolve/constants/ConstantValue;", "entry", "annotationFqName", "Lksp/org/jetbrains/kotlin/name/FqName;", "checkSubclassOptInUsage", "checkArgumentsAreMarkers", "checkMarkerTargetsAndRetention", "frontend"})
@SourceDebugExtension(value={"SMAP\nOptInMarkerDeclarationAnnotationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OptInMarkerDeclarationAnnotationChecker.kt\norg/jetbrains/kotlin/resolve/checkers/OptInMarkerDeclarationAnnotationChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,201:1\n1761#2,3:202\n1285#2,2:205\n1299#2,4:207\n295#2,2:211\n295#2,2:213\n*S KotlinDebug\n*F\n+ 1 OptInMarkerDeclarationAnnotationChecker.kt\norg/jetbrains/kotlin/resolve/checkers/OptInMarkerDeclarationAnnotationChecker\n*L\n57#1:202,3\n169#1:205,2\n169#1:207,4\n170#1:211,2\n186#1:213,2\n*E\n"})
public final class OptInMarkerDeclarationAnnotationChecker
implements AdditionalAnnotationChecker {
    @NotNull
    private final ModuleDescriptor module;

    public OptInMarkerDeclarationAnnotationChecker(@NotNull ModuleDescriptor module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        this.module = module2;
    }

    @Override
    public void checkEntries(@NotNull List<? extends KtAnnotationEntry> entries, @NotNull List<? extends KotlinTarget> actualTargets, @NotNull BindingTrace trace, @Nullable KtAnnotated annotated, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        Intrinsics.checkNotNullParameter(actualTargets, (String)"actualTargets");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        boolean hasOptIn = false;
        for (KtAnnotationEntry ktAnnotationEntry : entries) {
            AnnotationUseSiteTarget annotationUseSiteTarget;
            boolean bl2;
            ClassDescriptor annotationClass;
            block13: {
                List<ConstantValue<?>> annotationClasses;
                AnnotationDescriptor annotation;
                if ((AnnotationDescriptor)trace.getBindingContext().get(BindingContext.ANNOTATION, ktAnnotationEntry) == null) continue;
                FqName fqName = annotation.getFqName();
                if (Intrinsics.areEqual((Object)fqName, (Object)OptInNames.INSTANCE.getOPT_IN_FQ_NAME())) {
                    annotationClasses = OptInUsageCheckerUtilsKt.getOptInAnnotationArgs(annotation);
                    this.checkOptInUsage(annotationClasses, trace, ktAnnotationEntry, OptInNames.INSTANCE.getOPT_IN_FQ_NAME());
                } else if (Intrinsics.areEqual((Object)fqName, (Object)OptInNames.INSTANCE.getSUBCLASS_OPT_IN_REQUIRED_FQ_NAME())) {
                    annotationClasses = OptInUsageCheckerUtilsKt.getOptInAnnotationArgs(annotation);
                    this.checkSubclassOptInUsage(annotated, annotationClasses, trace, ktAnnotationEntry, OptInNames.INSTANCE.getSUBCLASS_OPT_IN_REQUIRED_FQ_NAME());
                } else if (Intrinsics.areEqual((Object)fqName, (Object)OptInNames.INSTANCE.getREQUIRES_OPT_IN_FQ_NAME())) {
                    hasOptIn = true;
                }
                if (DescriptorUtilsKt.getAnnotationClass(annotation) == null) continue;
                Iterable $this$any$iv = annotationClass.getAnnotations();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        AnnotationDescriptor it = (AnnotationDescriptor)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getFqName(), (Object)OptInNames.INSTANCE.getREQUIRES_OPT_IN_FQ_NAME())) continue;
                        bl2 = true;
                        break block13;
                    }
                    bl2 = false;
                }
            }
            if (!bl2) continue;
            Set<KotlinTarget> applicableTargets = AnnotationChecker.Companion.applicableTargetSet(annotationClass);
            Set possibleTargets = CollectionsKt.intersect((Iterable)applicableTargets, (Iterable)actualTargets);
            KtAnnotationUseSiteTarget ktAnnotationUseSiteTarget = ktAnnotationEntry.getUseSiteTarget();
            AnnotationUseSiteTarget annotationUseSiteTarget2 = annotationUseSiteTarget = ktAnnotationUseSiteTarget != null ? ktAnnotationUseSiteTarget.getAnnotationUseSiteTarget() : null;
            if (possibleTargets.contains((Object)KotlinTarget.PROPERTY_GETTER) || annotationUseSiteTarget == AnnotationUseSiteTarget.PROPERTY_GETTER) {
                trace.report(Errors.OPT_IN_MARKER_ON_WRONG_TARGET.on((KtAnnotationEntry)((PsiElement)ktAnnotationEntry), "getter"));
            }
            if (possibleTargets.contains((Object)KotlinTarget.VALUE_PARAMETER) && annotationUseSiteTarget == null || annotationUseSiteTarget == AnnotationUseSiteTarget.RECEIVER || annotationUseSiteTarget == AnnotationUseSiteTarget.SETTER_PARAMETER || annotationUseSiteTarget == AnnotationUseSiteTarget.CONSTRUCTOR_PARAMETER) {
                trace.report(Errors.OPT_IN_MARKER_ON_WRONG_TARGET.on((KtAnnotationEntry)((PsiElement)ktAnnotationEntry), "parameter"));
            }
            if (possibleTargets.contains((Object)KotlinTarget.LOCAL_VARIABLE)) {
                trace.report(Errors.OPT_IN_MARKER_ON_WRONG_TARGET.on((KtAnnotationEntry)((PsiElement)ktAnnotationEntry), "variable"));
            }
            if (annotationUseSiteTarget != AnnotationUseSiteTarget.FIELD && annotationUseSiteTarget != AnnotationUseSiteTarget.PROPERTY_DELEGATE_FIELD) continue;
            trace.report(Errors.OPT_IN_MARKER_ON_WRONG_TARGET.on((KtAnnotationEntry)((PsiElement)ktAnnotationEntry), "field"));
        }
        if (hasOptIn) {
            this.checkMarkerTargetsAndRetention(entries, trace);
        }
    }

    private final void checkOptInUsage(List<? extends ConstantValue<?>> annotationClasses, BindingTrace trace, KtAnnotationEntry entry, FqName annotationFqName) {
        if (annotationClasses.isEmpty()) {
            trace.report(Errors.OPT_IN_WITHOUT_ARGUMENTS.on((KtAnnotationEntry)((PsiElement)entry)));
            return;
        }
        this.checkArgumentsAreMarkers(annotationClasses, trace, entry, annotationFqName);
    }

    private final void checkSubclassOptInUsage(KtAnnotated annotated, List<? extends ConstantValue<?>> annotationClasses, BindingTrace trace, KtAnnotationEntry entry, FqName annotationFqName) {
        ClassDescriptor descriptor2;
        KtAnnotated ktAnnotated = annotated;
        if (ktAnnotated instanceof KtAnnotatedExpression) {
            if (((KtAnnotatedExpression)annotated).getBaseExpression() instanceof KtObjectLiteralExpression) {
                trace.report(Errors.SUBCLASS_OPT_IN_INAPPLICABLE.on((KtAnnotationEntry)((PsiElement)entry), "object"));
            }
            return;
        }
        if (ktAnnotated instanceof KtClassOrObject && (descriptor2 = (ClassDescriptor)trace.get(BindingContext.CLASS, annotated)) != null) {
            ClassKind classKind2 = descriptor2.getKind();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)classKind2), (String)"getKind(...)");
            ClassKind kind = classKind2;
            if (kind == ClassKind.OBJECT || kind == ClassKind.ENUM_CLASS || kind == ClassKind.ANNOTATION_CLASS) {
                trace.report(Errors.SUBCLASS_OPT_IN_INAPPLICABLE.on((KtAnnotationEntry)((PsiElement)entry), kind.toString()));
                return;
            }
            if (kind != ClassKind.ENUM_ENTRY) {
                Modality modality = descriptor2.getModality();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)modality), (String)"getModality(...)");
                Modality modality2 = modality;
                if (modality2 != Modality.ABSTRACT && modality2 != Modality.OPEN) {
                    trace.report(Errors.SUBCLASS_OPT_IN_INAPPLICABLE.on((KtAnnotationEntry)((PsiElement)entry), "" + (Object)((Object)modality2) + ' ' + (Object)((Object)kind)));
                    return;
                }
                if (descriptor2.isFun()) {
                    trace.report(Errors.SUBCLASS_OPT_IN_INAPPLICABLE.on((KtAnnotationEntry)((PsiElement)entry), "fun interface"));
                    return;
                }
                if (((KtClassOrObject)annotated).isLocal()) {
                    trace.report(Errors.SUBCLASS_OPT_IN_INAPPLICABLE.on((KtAnnotationEntry)((PsiElement)entry), "local " + (Object)((Object)kind)));
                    return;
                }
            }
        }
        this.checkArgumentsAreMarkers(annotationClasses, trace, entry, annotationFqName);
    }

    private final void checkArgumentsAreMarkers(List<? extends ConstantValue<?>> annotationClasses, BindingTrace trace, KtAnnotationEntry entry, FqName annotationFqName) {
        Iterator iterator2 = ((Iterable)annotationClasses).iterator();
        int n2 = 0;
        while (iterator2.hasNext()) {
            KtExpression source;
            ClassDescriptor classDescriptor;
            ClassifierDescriptor classifierDescriptor;
            int index2 = n2++;
            ConstantValue annotationClass = (ConstantValue)iterator2.next();
            Object object = annotationClass instanceof KClassValue ? (KClassValue)annotationClass : null;
            ClassifierDescriptor classifierDescriptor2 = classifierDescriptor = object != null && (object = ((KClassValue)object).getArgumentType(this.module)) != null && (object = ((KotlinType)object).getConstructor()) != null ? object.getDeclarationDescriptor() : null;
            if ((classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null) == null) continue;
            classDescriptor = classDescriptor;
            OptInUsageChecker.Companion $this$checkArgumentsAreMarkers_u24lambda_u241 = OptInUsageChecker.Companion;
            boolean bl2 = false;
            OptInDescription optInDescription = OptInUsageChecker.Companion.loadOptInForMarkerAnnotation$frontend$default($this$checkArgumentsAreMarkers_u24lambda_u241, classDescriptor, false, false, 3, null);
            if (optInDescription != null) continue;
            if (entry.getValueArguments().get(index2).getArgumentExpression() == null) {
                return;
            }
            if (Intrinsics.areEqual((Object)annotationFqName, (Object)OptInNames.INSTANCE.getSUBCLASS_OPT_IN_REQUIRED_FQ_NAME())) {
                trace.report(Errors.SUBCLASS_OPT_IN_ARGUMENT_IS_NOT_MARKER.on((KtExpression)((PsiElement)source), DescriptorUtilsKt.getFqNameSafe(classDescriptor)));
                continue;
            }
            trace.report(Errors.OPT_IN_ARGUMENT_IS_NOT_MARKER.on((KtExpression)((PsiElement)source), DescriptorUtilsKt.getFqNameSafe(classDescriptor)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkMarkerTargetsAndRetention(List<? extends KtAnnotationEntry> entries, BindingTrace trace) {
        Object v5;
        block9: {
            Object v1;
            Set associatedEntries;
            block8: {
                Iterable $this$associateWith$iv = entries;
                boolean $i$f$associateWith = false;
                LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
                Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
                boolean $i$f$associateWithTo = false;
                Object object = $this$associateWithTo$iv$iv.iterator();
                while (object.hasNext()) {
                    void entry;
                    Object element$iv$iv = object.next();
                    KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)element$iv$iv;
                    Object t2 = element$iv$iv;
                    Map map = result$iv;
                    boolean bl2 = false;
                    AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)trace.getBindingContext().get(BindingContext.ANNOTATION, entry);
                    map.put(t2, annotationDescriptor);
                }
                associatedEntries = ((Map)result$iv).entrySet();
                Iterable $this$firstOrNull$iv = associatedEntries;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    AnnotationDescriptor descriptor2;
                    object = (Map.Entry)element$iv;
                    boolean bl3 = false;
                    AnnotationDescriptor annotationDescriptor = descriptor2 = (AnnotationDescriptor)object.getValue();
                    if (!Intrinsics.areEqual((Object)(annotationDescriptor != null ? annotationDescriptor.getFqName() : null), (Object)StandardNames.FqNames.target)) continue;
                    v1 = element$iv;
                    break block8;
                }
                v1 = null;
            }
            Map.Entry targetEntry = v1;
            if (targetEntry != null) {
                AnnotationDescriptor descriptor3;
                KtAnnotationEntry entry = (KtAnnotationEntry)targetEntry.getKey();
                AnnotationDescriptor annotationDescriptor = descriptor3 = (AnnotationDescriptor)targetEntry.getValue();
                Intrinsics.checkNotNull((Object)annotationDescriptor);
                Set<KotlinTarget> set = AnnotationChecker.Companion.loadAnnotationTargets(annotationDescriptor);
                if (set == null) {
                    return;
                }
                Set<KotlinTarget> allowedTargets = set;
                Set wrongTargets = CollectionsKt.intersect((Iterable)allowedTargets, (Iterable)OptInDescription.Companion.getWRONG_TARGETS_FOR_MARKER());
                if (!((Collection)wrongTargets).isEmpty()) {
                    trace.report(Errors.OPT_IN_MARKER_WITH_WRONG_TARGET.on((KtAnnotationEntry)((PsiElement)entry), CollectionsKt.joinToString$default((Iterable)wrongTargets, null, null, null, (int)0, null, (Function1)((Function1)checkMarkerTargetsAndRetention.1.INSTANCE), (int)31, null)));
                }
            }
            Iterable $this$firstOrNull$iv = associatedEntries;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                AnnotationDescriptor descriptor4;
                Map.Entry entry = (Map.Entry)element$iv;
                boolean bl4 = false;
                AnnotationDescriptor annotationDescriptor = descriptor4 = (AnnotationDescriptor)entry.getValue();
                if (!Intrinsics.areEqual((Object)(annotationDescriptor != null ? annotationDescriptor.getFqName() : null), (Object)StandardNames.FqNames.retention)) continue;
                v5 = element$iv;
                break block9;
            }
            v5 = null;
        }
        Map.Entry retentionEntry = v5;
        if (retentionEntry != null) {
            AnnotationDescriptor descriptor5;
            KtAnnotationEntry entry = (KtAnnotationEntry)retentionEntry.getKey();
            AnnotationDescriptor annotationDescriptor = descriptor5 = (AnnotationDescriptor)retentionEntry.getValue();
            if ((annotationDescriptor != null ? DescriptorUtilsKt.getAnnotationRetention(annotationDescriptor) : null) == KotlinRetention.SOURCE) {
                trace.report(Errors.OPT_IN_MARKER_WITH_WRONG_RETENTION.on(entry));
            }
        }
    }
}

