/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.psi.tree.IElementType;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtNodeTypes;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.FirElement;
import ksp.org.jetbrains.kotlin.fir.analysis.FirSourceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirVariable;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirStatement;
import ksp.org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import ksp.org.jetbrains.kotlin.lexer.KtKeywordToken;
import ksp.org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirWhenSubjectChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirWhenExpressionChecker;", "<init>", "()V", "check", "", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;)V", "checkers"})
public final class FirWhenSubjectChecker
extends FirExpressionChecker<FirWhenExpression> {
    @NotNull
    public static final FirWhenSubjectChecker INSTANCE = new FirWhenSubjectChecker();

    private FirWhenSubjectChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirWhenExpression expression2) {
        FirVariable subjectVariable;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        FirVariable firVariable = expression2.getSubjectVariable();
        FirExpression subject = firVariable != null ? firVariable.getInitializer() : null;
        FirVariable firVariable2 = subjectVariable = expression2.getSubjectVariable();
        Object object = firVariable2 != null ? (FirElement)firVariable2 : (FirElement)subject;
        if (object == null || (object = ((FirStatement)object).getSource()) == null) {
            return;
        }
        Object source = object;
        Object object2 = subject;
        if (Intrinsics.areEqual((Object)(object2 != null && (object2 = ((FirExpression)object2).getSource()) != null ? ((KtSourceElement)object2).getElementType() : null), (Object)KtNodeTypes.DESTRUCTURING_DECLARATION)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getILLEGAL_DECLARATION_IN_WHEN_SUBJECT(), (Object)"destructuring declaration", null, 16, null);
        } else {
            KtSourceElement ktSourceElement;
            Object object3 = subjectVariable;
            if (object3 != null && (object3 = ((FirVariable)object3).getSource()) != null) {
                KtKeywordToken ktKeywordToken = KtTokens.VAR_KEYWORD;
                Intrinsics.checkNotNullExpressionValue((Object)ktKeywordToken, (String)"VAR_KEYWORD");
                ktSourceElement = FirSourceUtilsKt.getChild$default((KtSourceElement)object3, ktKeywordToken, 0, 0, false, 14, null);
            } else {
                ktSourceElement = null;
            }
            if (ktSourceElement != null) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getILLEGAL_DECLARATION_IN_WHEN_SUBJECT(), (Object)"var", null, 16, null);
            } else {
                KtSourceElement ktSourceElement2;
                Object object4 = subjectVariable;
                if (object4 != null && (object4 = ((FirVariable)object4).getSource()) != null) {
                    IElementType iElementType = KtNodeTypes.PROPERTY_DELEGATE;
                    Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"PROPERTY_DELEGATE");
                    ktSourceElement2 = FirSourceUtilsKt.getChild$default((KtSourceElement)object4, iElementType, 0, 0, false, 14, null);
                } else {
                    ktSourceElement2 = null;
                }
                if (ktSourceElement2 != null) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getILLEGAL_DECLARATION_IN_WHEN_SUBJECT(), (Object)"delegated property", null, 16, null);
                } else if (subjectVariable != null && subjectVariable.getInitializer() == null) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getILLEGAL_DECLARATION_IN_WHEN_SUBJECT(), (Object)"variable without initializer", null, 16, null);
                }
            }
        }
    }
}

