/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.config.AnalysisFlags;
import ksp.org.jetbrains.kotlin.config.ApiVersion;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import ksp.org.jetbrains.kotlin.fir.FirSession;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirNonSuppressibleErrorNamesKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import ksp.org.jetbrains.kotlin.fir.expressions.ConstantArgumentKind;
import ksp.org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import ksp.org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import ksp.org.jetbrains.kotlin.fir.expressions.FirArrayLiteral;
import ksp.org.jetbrains.kotlin.fir.expressions.FirConstChecksKt;
import ksp.org.jetbrains.kotlin.fir.expressions.FirErrorExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import ksp.org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import ksp.org.jetbrains.kotlin.fir.references.FirErrorNamedReference;
import ksp.org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import ksp.org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.name.ClassId;
import ksp.org.jetbrains.kotlin.name.FqName;
import ksp.org.jetbrains.kotlin.name.Name;
import ksp.org.jetbrains.kotlin.name.StandardClassIds;
import ksp.org.jetbrains.kotlin.resolve.RequireKotlinConstants;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0002H\u0016R\u00020\u000fR\u00020\u0011j\u0006\u0010\u0010\u001a\u00020\u000fj\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0014J*\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0013\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\"\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0013\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J*\u0010\u001c\u001a\u00020\u000e2\b\u0010\u001d\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J@\u0010 \u001a\u00020\u000e2\b\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010\u001d\u001a\u0004\u0018\u00010\t2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00170$2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J \u0010%\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J \u0010&\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J6\u0010'\u001a\u00020\u000e2\b\u0010(\u001a\u0004\u0018\u00010)2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00170$2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J,\u0010*\u001a\u00020\u000e2\b\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u000fH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirAnnotationExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirAnnotationCallChecker;", "<init>", "()V", "versionArgumentName", "Lksp/org/jetbrains/kotlin/name/Name;", "deprecatedSinceKotlinFqName", "Lksp/org/jetbrains/kotlin/name/FqName;", "sinceKotlinFqName", "annotationFqNamesWithVersion", "", "check", "", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;)V", "checkAnnotationArgumentWithSubElements", "Lksp/org/jetbrains/kotlin/diagnostics/KtDiagnosticFactory0;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirExpression;", "session", "Lksp/org/jetbrains/kotlin/fir/FirSession;", "parseVersionExpressionOrReport", "Lksp/org/jetbrains/kotlin/config/ApiVersion;", "checkAnnotationsWithVersion", "fqName", "annotation", "Lksp/org/jetbrains/kotlin/fir/expressions/FirAnnotation;", "checkDeprecatedSinceKotlin", "source", "Lksp/org/jetbrains/kotlin/KtSourceElement;", "argumentMapping", "", "checkAnnotationUsedAsAnnotationArgument", "checkNotAClass", "checkErrorSuppression", "annotationClassId", "Lksp/org/jetbrains/kotlin/name/ClassId;", "checkContextFunctionTypeParams", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirAnnotationExpressionChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirAnnotationExpressionChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirAnnotationExpressionChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,264:1\n1#2:265\n*E\n"})
public final class FirAnnotationExpressionChecker
extends FirExpressionChecker<FirAnnotationCall> {
    @NotNull
    public static final FirAnnotationExpressionChecker INSTANCE = new FirAnnotationExpressionChecker();
    @NotNull
    private static final Name versionArgumentName;
    @NotNull
    private static final FqName deprecatedSinceKotlinFqName;
    @NotNull
    private static final FqName sinceKotlinFqName;
    @NotNull
    private static final Set<FqName> annotationFqNamesWithVersion;

    private FirAnnotationExpressionChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirAnnotationCall expression2) {
        ClassId annotationClassId;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Map<Name, FirExpression> argumentMapping2 = expression2.getArgumentMapping().getMapping();
        ClassId classId = annotationClassId = FirAnnotationUtilsKt.toAnnotationClassId(expression2, context2.getSession());
        FqName fqName = classId != null ? classId.asSingleFqName() : null;
        for (FirExpression arg : argumentMapping2.values()) {
            FirExpression argExpression;
            KtDiagnosticFactory0 ktDiagnosticFactory0;
            FirExpression firExpression = arg instanceof FirErrorExpression ? (FirErrorExpression)arg : null;
            if (firExpression == null || (firExpression = ((FirErrorExpression)firExpression).getExpression()) == null) {
                firExpression = arg;
            }
            if ((ktDiagnosticFactory0 = this.checkAnnotationArgumentWithSubElements(argExpression = firExpression, context2.getSession(), reporter, context2)) == null) continue;
            KtDiagnosticFactory0 it = ktDiagnosticFactory0;
            boolean bl2 = false;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)argExpression.getSource(), it, null, 8, null);
        }
        this.checkAnnotationsWithVersion(fqName, expression2, context2, reporter);
        this.checkDeprecatedSinceKotlin(expression2.getSource(), fqName, argumentMapping2, context2, reporter);
        this.checkAnnotationUsedAsAnnotationArgument(expression2, context2, reporter);
        this.checkNotAClass(expression2, context2, reporter);
        this.checkErrorSuppression(annotationClassId, argumentMapping2, reporter, context2);
        this.checkContextFunctionTypeParams(expression2.getSource(), annotationClassId, reporter, context2);
    }

    private final KtDiagnosticFactory0 checkAnnotationArgumentWithSubElements(FirExpression expression2, FirSession session, DiagnosticReporter reporter, CheckerContext context2) {
        FirExpression firExpression = expression2;
        if (firExpression instanceof FirArrayLiteral) {
            return FirAnnotationExpressionChecker.checkAnnotationArgumentWithSubElements$checkArgumentList(session, reporter, context2, ((FirArrayLiteral)expression2).getArgumentList());
        }
        if (firExpression instanceof FirVarargArgumentsExpression) {
            for (FirExpression arg : ((FirVarargArgumentsExpression)expression2).getArguments()) {
                FirExpression unwrappedArg = FirExpressionUtilKt.unwrapArgument(arg);
                KtDiagnosticFactory0 ktDiagnosticFactory0 = this.checkAnnotationArgumentWithSubElements(unwrappedArg, session, reporter, context2);
                if (ktDiagnosticFactory0 == null) continue;
                KtDiagnosticFactory0 it = ktDiagnosticFactory0;
                boolean bl2 = false;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)unwrappedArg.getSource(), it, (DiagnosticContext)context2, null, 8, null);
            }
        } else {
            KtDiagnosticFactory0 ktDiagnosticFactory0;
            switch (WhenMappings.$EnumSwitchMapping$0[FirConstChecksKt.computeConstantExpressionKind(expression2, session, true).ordinal()]) {
                case 1: {
                    ktDiagnosticFactory0 = FirErrors.INSTANCE.getANNOTATION_ARGUMENT_MUST_BE_CONST();
                    break;
                }
                case 2: {
                    ktDiagnosticFactory0 = FirErrors.INSTANCE.getANNOTATION_ARGUMENT_MUST_BE_ENUM_CONST();
                    break;
                }
                case 3: {
                    ktDiagnosticFactory0 = FirErrors.INSTANCE.getANNOTATION_ARGUMENT_MUST_BE_KCLASS_LITERAL();
                    break;
                }
                case 4: {
                    ktDiagnosticFactory0 = FirErrors.INSTANCE.getANNOTATION_ARGUMENT_KCLASS_LITERAL_OF_TYPE_PARAMETER_ERROR();
                    break;
                }
                case 5: {
                    ktDiagnosticFactory0 = FirErrors.INSTANCE.getNON_CONST_VAL_USED_IN_CONSTANT_EXPRESSION();
                    break;
                }
                case 6: 
                case 7: {
                    if (expression2 instanceof FirFunctionCall) {
                        ktDiagnosticFactory0 = FirAnnotationExpressionChecker.checkAnnotationArgumentWithSubElements$checkArgumentList(session, reporter, context2, ((FirFunctionCall)expression2).getArgumentList());
                        break;
                    }
                    ktDiagnosticFactory0 = null;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return ktDiagnosticFactory0;
        }
        return null;
    }

    private final ApiVersion parseVersionExpressionOrReport(FirExpression expression2, CheckerContext context2, DiagnosticReporter reporter) {
        FirLiteralExpression firLiteralExpression = expression2 instanceof FirLiteralExpression ? (FirLiteralExpression)expression2 : null;
        if (firLiteralExpression == null) {
            return null;
        }
        FirLiteralExpression constantExpression = firLiteralExpression;
        Object object = constantExpression.getValue();
        String string = object instanceof String ? (String)object : null;
        if (string == null) {
            return null;
        }
        String stringValue = string;
        CharSequence charSequence = stringValue;
        if (!RequireKotlinConstants.INSTANCE.getVERSION_REGEX().matches(charSequence)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirLiteralExpression)expression2).getSource(), FirErrors.INSTANCE.getILLEGAL_KOTLIN_VERSION_STRING_VALUE(), (DiagnosticContext)context2, null, 8, null);
            return null;
        }
        ApiVersion version = ApiVersion.Companion.parse(stringValue);
        if (version == null) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirLiteralExpression)expression2).getSource(), FirErrors.INSTANCE.getILLEGAL_KOTLIN_VERSION_STRING_VALUE(), (DiagnosticContext)context2, null, 8, null);
        }
        return version;
    }

    private final void checkAnnotationsWithVersion(FqName fqName, FirAnnotation annotation, CheckerContext context2, DiagnosticReporter reporter) {
        ApiVersion specified;
        if (!CollectionsKt.contains((Iterable)annotationFqNamesWithVersion, (Object)fqName)) {
            return;
        }
        FirExpression firExpression = FirAnnotationUtilsKt.findArgumentByName$default(annotation, versionArgumentName, false, 2, null);
        if (firExpression == null) {
            return;
        }
        FirExpression versionExpression = firExpression;
        ApiVersion apiVersion = this.parseVersionExpressionOrReport(versionExpression, context2, reporter);
        if (apiVersion == null) {
            return;
        }
        ApiVersion version = apiVersion;
        if (Intrinsics.areEqual((Object)fqName, (Object)sinceKotlinFqName) && version.compareTo(specified = FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession()).getApiVersion()) > 0) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)versionExpression.getSource(), FirErrors.INSTANCE.getNEWER_VERSION_IN_SINCE_KOTLIN(), (Object)specified.getVersionString(), (DiagnosticContext)context2, null, 16, null);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void checkDeprecatedSinceKotlin(KtSourceElement source, FqName fqName, Map<Name, ? extends FirExpression> argumentMapping, CheckerContext context, DiagnosticReporter reporter) {
        if (!Intrinsics.areEqual((Object)fqName, (Object)FirAnnotationExpressionChecker.deprecatedSinceKotlinFqName)) {
            return;
        }
        if (argumentMapping.size() == 0) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getDEPRECATED_SINCE_KOTLIN_WITHOUT_ARGUMENTS(), (DiagnosticContext)context, null, 8, null);
        }
        warningSince = null;
        errorSince = null;
        hiddenSince = null;
        for (Map.Entry<Name, ? extends FirExpression> var10_11 : argumentMapping.entrySet()) {
            block28: {
                name = var10_11.getKey();
                argument = var10_11.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)name.getIdentifier(), (String)"getIdentifier(...)");
                switch (identifier.hashCode()) {
                    case -855220304: {
                        if (!identifier.equals("hiddenSince")) {
                            break;
                        }
                        ** GOTO lbl23
                    }
                    case -2027506434: {
                        if (!identifier.equals("warningSince")) {
                            break;
                        }
                        ** GOTO lbl23
                    }
                    case 1624782354: {
                        if (!identifier.equals("errorSince")) break;
lbl23:
                        // 3 sources

                        if ((version = this.parseVersionExpressionOrReport(argument, context, reporter)) == null) break;
                        var15_16 = identifier;
                        tmp = -1;
                        switch (var15_16.hashCode()) {
                            case -855220304: {
                                if (var15_16.equals("hiddenSince")) {
                                    tmp = 1;
                                }
                                break;
                            }
                            case -2027506434: {
                                if (var15_16.equals("warningSince")) {
                                    tmp = 2;
                                }
                                break;
                            }
                            case 1624782354: {
                                if (var15_16.equals("errorSince")) {
                                    tmp = 3;
                                }
                                break;
                            }
                        }
                        switch (tmp) {
                            case 2: {
                                warningSince = version;
                                break block28;
                            }
                            case 3: {
                                errorSince = version;
                                break block28;
                            }
                            case 1: {
                                hiddenSince = version;
                            }
                        }
                    }
                }
            }
        }
        isReportDeprecatedSinceKotlinWithUnorderedVersions = false;
        if (warningSince != null) {
            if (errorSince != null) {
                v0 = isReportDeprecatedSinceKotlinWithUnorderedVersions = warningSince.compareTo(errorSince) > 0;
            }
            if (hiddenSince != null && !isReportDeprecatedSinceKotlinWithUnorderedVersions) {
                v1 = isReportDeprecatedSinceKotlinWithUnorderedVersions = warningSince.compareTo(hiddenSince) > 0;
            }
        }
        if (errorSince != null && hiddenSince != null && !isReportDeprecatedSinceKotlinWithUnorderedVersions) {
            v2 = isReportDeprecatedSinceKotlinWithUnorderedVersions = errorSince.compareTo(hiddenSince) > 0;
        }
        if (isReportDeprecatedSinceKotlinWithUnorderedVersions) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getDEPRECATED_SINCE_KOTLIN_WITH_UNORDERED_VERSIONS(), (DiagnosticContext)context, null, 8, null);
        }
    }

    private final void checkAnnotationUsedAsAnnotationArgument(FirAnnotationCall expression2, CheckerContext context2, DiagnosticReporter reporter) {
        List<FirExpression> args = expression2.getArgumentList().getArguments();
        for (FirExpression arg : args) {
            for (FirAnnotation ann : FirExpressionUtilKt.unwrapArgument(arg).getAnnotations()) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)ann.getSource(), FirErrors.INSTANCE.getANNOTATION_USED_AS_ANNOTATION_ARGUMENT(), (DiagnosticContext)context2, null, 8, null);
            }
        }
    }

    private final void checkNotAClass(FirAnnotationCall expression2, CheckerContext context2, DiagnosticReporter reporter) {
        FirTypeRef annotationTypeRef = expression2.getAnnotationTypeRef();
        if (expression2.getCalleeReference() instanceof FirErrorNamedReference && !(annotationTypeRef instanceof FirErrorTypeRef) && !(FirTypeUtilsKt.getConeType(annotationTypeRef) instanceof ConeClassLikeType)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotationTypeRef.getSource(), FirErrors.INSTANCE.getNOT_A_CLASS(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    private final void checkErrorSuppression(ClassId annotationClassId, Map<Name, ? extends FirExpression> argumentMapping2, DiagnosticReporter reporter, CheckerContext context2) {
        if (context2.getLanguageVersionSettings().getFlag(AnalysisFlags.getDontWarnOnErrorSuppression()).booleanValue()) {
            return;
        }
        if (!Intrinsics.areEqual((Object)annotationClassId, (Object)StandardClassIds.Annotations.INSTANCE.getSuppress())) {
            return;
        }
        Object object = argumentMapping2.get(StandardClassIds.Annotations.ParameterNames.INSTANCE.getSuppressNames());
        if (object == null || (object = FirAnnotationUtilsKt.unwrapVarargValue((FirExpression)object)) == null) {
            return;
        }
        Object nameExpressions = object;
        Iterator iterator2 = nameExpressions.iterator();
        while (iterator2.hasNext()) {
            String string;
            String name2;
            FirExpression nameExpression = (FirExpression)iterator2.next();
            FirLiteralExpression firLiteralExpression = nameExpression instanceof FirLiteralExpression ? (FirLiteralExpression)nameExpression : null;
            Object object2 = firLiteralExpression != null ? firLiteralExpression.getValue() : null;
            if ((object2 instanceof String ? (String)object2 : null) == null) continue;
            name2 = name2;
            object2 = name2;
            if (FirNonSuppressibleErrorNamesKt.getFIR_NON_SUPPRESSIBLE_ERROR_NAMES().contains(object2)) {
                string = name2;
            } else {
                if (!Intrinsics.areEqual((Object)object2, (Object)"errors")) continue;
                string = "all errors";
            }
            String parameter2 = string;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirLiteralExpression)nameExpression).getSource(), FirErrors.INSTANCE.getERROR_SUPPRESSION(), (Object)parameter2, (DiagnosticContext)context2, null, 16, null);
        }
    }

    private final void checkContextFunctionTypeParams(KtSourceElement source, ClassId annotationClassId, DiagnosticReporter reporter, CheckerContext context2) {
        if (!Intrinsics.areEqual((Object)annotationClassId, (Object)StandardClassIds.Annotations.INSTANCE.getContextFunctionTypeParams())) {
            return;
        }
        FirHelpersKt.requireFeatureSupport$default(source, LanguageFeature.ContextReceivers, context2, reporter, null, 8, null);
    }

    private static final KtDiagnosticFactory0 checkAnnotationArgumentWithSubElements$checkArgumentList(FirSession $session, DiagnosticReporter $reporter, CheckerContext $context, FirArgumentList args) {
        boolean usedNonConst = false;
        for (FirExpression arg : args.getArguments()) {
            KtSourceElement sourceForReport = arg.getSource();
            KtDiagnosticFactory0 err = INSTANCE.checkAnnotationArgumentWithSubElements(arg, $session, $reporter, $context);
            if (err == null) continue;
            if (!Intrinsics.areEqual((Object)err, (Object)FirErrors.INSTANCE.getANNOTATION_ARGUMENT_MUST_BE_KCLASS_LITERAL())) {
                usedNonConst = true;
            }
            KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)sourceForReport, err, (DiagnosticContext)$context, null, 8, null);
        }
        return usedNonConst ? FirErrors.INSTANCE.getNON_CONST_VAL_USED_IN_CONSTANT_EXPRESSION() : null;
    }

    static {
        Name name2 = Name.identifier("version");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        versionArgumentName = name2;
        deprecatedSinceKotlinFqName = new FqName("kotlin.DeprecatedSinceKotlin");
        sinceKotlinFqName = new FqName("kotlin.SinceKotlin");
        Object[] objectArray = new FqName[]{RequireKotlinConstants.INSTANCE.getFQ_NAME(), sinceKotlinFqName};
        annotationFqNamesWithVersion = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ConstantArgumentKind.values().length];
            try {
                nArray[ConstantArgumentKind.NOT_CONST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConstantArgumentKind.ENUM_NOT_CONST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConstantArgumentKind.NOT_KCLASS_LITERAL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConstantArgumentKind.KCLASS_LITERAL_OF_TYPE_PARAMETER_ERROR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConstantArgumentKind.NOT_CONST_VAL_IN_CONST_EXPRESSION.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConstantArgumentKind.VALID_CONST.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConstantArgumentKind.RESOLUTION_ERROR.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

