/*
 * Decompiled with CFR 0.152.
 */
package ksp.one.util.streamex;

import java.util.BitSet;
import java.util.HashMap;
import java.util.IntSummaryStatistics;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.IntBinaryOperator;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.IntUnaryOperator;
import java.util.function.ObjIntConsumer;
import java.util.function.Supplier;
import java.util.stream.Collector;
import ksp.one.util.streamex.Internals;
import ksp.one.util.streamex.MergingCollector;

public interface IntCollector<A, R>
extends MergingCollector<Integer, A, R> {
    public ObjIntConsumer<A> intAccumulator();

    @Override
    default public BiConsumer<A, Integer> accumulator() {
        return this.intAccumulator()::accept;
    }

    default public <RR> IntCollector<A, RR> andThen(Function<R, RR> finisher) {
        return IntCollector.of(this.supplier(), this.intAccumulator(), this.merger(), this.finisher().andThen(finisher));
    }

    public static <R> IntCollector<R, R> of(Supplier<R> supplier, ObjIntConsumer<R> intAccumulator, BiConsumer<R, R> merger) {
        return new Internals.IntCollectorImpl(supplier, intAccumulator, merger, Function.identity(), Internals.ID_CHARACTERISTICS);
    }

    public static <A, R> IntCollector<?, R> of(Collector<Integer, A, R> collector) {
        if (collector instanceof IntCollector) {
            return (IntCollector)collector;
        }
        return IntCollector.mappingToObj(Integer::valueOf, collector);
    }

    public static <A, R> IntCollector<A, R> of(Supplier<A> supplier, ObjIntConsumer<A> intAccumulator, BiConsumer<A, A> merger, Function<A, R> finisher) {
        return new Internals.IntCollectorImpl<A, R>(supplier, intAccumulator, merger, finisher, Internals.NO_CHARACTERISTICS);
    }

    public static IntCollector<?, String> joining(CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        return Internals.PartialCollector.joining(delimiter, prefix, suffix, true).asInt(Internals.joinAccumulatorInt(delimiter));
    }

    public static IntCollector<?, String> joining(CharSequence delimiter) {
        return Internals.PartialCollector.joining(delimiter, null, null, false).asInt(Internals.joinAccumulatorInt(delimiter));
    }

    public static IntCollector<?, Long> counting() {
        return Internals.PartialCollector.longSum().asInt((box, i2) -> {
            box[0] = box[0] + 1L;
        });
    }

    public static IntCollector<?, Integer> countingInt() {
        return Internals.PartialCollector.intSum().asInt((box, i2) -> {
            box[0] = box[0] + 1;
        });
    }

    public static IntCollector<?, Integer> summing() {
        return Internals.PartialCollector.intSum().asInt((box, i2) -> {
            box[0] = box[0] + i2;
        });
    }

    public static IntCollector<?, OptionalDouble> averaging() {
        return IntCollector.of(Internals.AverageLong::new, Internals.AverageLong::accept, Internals.AverageLong::combine, Internals.AverageLong::result);
    }

    public static IntCollector<?, OptionalInt> min() {
        return IntCollector.reducing(Integer::min);
    }

    public static IntCollector<?, OptionalInt> max() {
        return IntCollector.reducing(Integer::max);
    }

    public static <A, R> IntCollector<?, R> mapping(IntUnaryOperator mapper, IntCollector<A, R> downstream) {
        ObjIntConsumer downstreamAccumulator = downstream.intAccumulator();
        return new Internals.IntCollectorImpl(downstream.supplier(), (r2, t2) -> downstreamAccumulator.accept(r2, mapper.applyAsInt(t2)), downstream.merger(), downstream.finisher(), downstream.characteristics());
    }

    public static <U, A, R> IntCollector<?, R> mappingToObj(IntFunction<U> mapper, Collector<U, A, R> downstream) {
        BiConsumer accumulator = downstream.accumulator();
        if (downstream instanceof MergingCollector) {
            return new Internals.IntCollectorImpl<Object, R>(downstream.supplier(), (acc, i2) -> accumulator.accept(acc, mapper.apply(i2)), ((MergingCollector)downstream).merger(), downstream.finisher(), downstream.characteristics());
        }
        return Internals.Box.partialCollector(downstream).asInt((box, i2) -> accumulator.accept(box.a, mapper.apply(i2)));
    }

    public static IntCollector<?, OptionalInt> reducing(IntBinaryOperator op) {
        return IntCollector.of(Internals.PrimitiveBox::new, (A box, int i2) -> {
            if (!box.b) {
                box.b = true;
                box.i = i2;
            } else {
                box.i = op.applyAsInt(box.i, i2);
            }
        }, (A box1, A box2) -> {
            if (box2.b) {
                if (!box1.b) {
                    box1.from((Internals.PrimitiveBox)box2);
                } else {
                    box1.i = op.applyAsInt(box1.i, box2.i);
                }
            }
        }, Internals.PrimitiveBox::asInt);
    }

    public static IntCollector<?, Integer> reducing(int identity, IntBinaryOperator op) {
        return IntCollector.of(() -> new int[]{identity}, (A box, int i2) -> {
            box[0] = op.applyAsInt(box[0], i2);
        }, (A box1, A box2) -> {
            box1[0] = op.applyAsInt(box1[0], box2[0]);
        }, Internals.UNBOX_INT);
    }

    public static IntCollector<?, IntSummaryStatistics> summarizing() {
        return IntCollector.of(IntSummaryStatistics::new, IntSummaryStatistics::accept, IntSummaryStatistics::combine);
    }

    public static IntCollector<?, Map<Boolean, int[]>> partitioningBy(IntPredicate predicate) {
        return IntCollector.partitioningBy(predicate, IntCollector.toArray());
    }

    public static <A, D> IntCollector<?, Map<Boolean, D>> partitioningBy(IntPredicate predicate, IntCollector<A, D> downstream) {
        ObjIntConsumer downstreamAccumulator = downstream.intAccumulator();
        ObjIntConsumer<Internals.BooleanMap> accumulator = (result2, t2) -> downstreamAccumulator.accept(predicate.test(t2) ? result2.trueValue : result2.falseValue, t2);
        return Internals.BooleanMap.partialCollector(downstream).asInt(accumulator);
    }

    public static <K> IntCollector<?, Map<K, int[]>> groupingBy(IntFunction<? extends K> classifier) {
        return IntCollector.groupingBy(classifier, IntCollector.toArray());
    }

    public static <K, D, A> IntCollector<?, Map<K, D>> groupingBy(IntFunction<? extends K> classifier, IntCollector<A, D> downstream) {
        return IntCollector.groupingBy(classifier, HashMap::new, downstream);
    }

    public static <K, D, A, M extends Map<K, D>> IntCollector<?, M> groupingBy(IntFunction<? extends K> classifier, Supplier<M> mapFactory, IntCollector<A, D> downstream) {
        Supplier downstreamSupplier = downstream.supplier();
        Function<Object, Object> supplier = k2 -> downstreamSupplier.get();
        ObjIntConsumer downstreamAccumulator = downstream.intAccumulator();
        ObjIntConsumer<Map> accumulator = (m4, t2) -> {
            Object key = Objects.requireNonNull(classifier.apply(t2));
            Object container = m4.computeIfAbsent(key, supplier);
            downstreamAccumulator.accept(container, t2);
        };
        return Internals.PartialCollector.grouping(mapFactory, downstream).asInt(accumulator);
    }

    public static IntCollector<?, BitSet> toBitSet() {
        return IntCollector.of(BitSet::new, BitSet::set, BitSet::or);
    }

    public static IntCollector<?, int[]> toArray() {
        return IntCollector.of(Internals.IntBuffer::new, Internals.IntBuffer::add, Internals.IntBuffer::addAll, Internals.IntBuffer::toArray);
    }

    public static IntCollector<?, byte[]> toByteArray() {
        return IntCollector.of(Internals.ByteBuffer::new, Internals.ByteBuffer::add, Internals.ByteBuffer::addAll, Internals.ByteBuffer::toArray);
    }

    public static IntCollector<?, char[]> toCharArray() {
        return IntCollector.of(Internals.CharBuffer::new, Internals.CharBuffer::add, Internals.CharBuffer::addAll, Internals.CharBuffer::toArray);
    }

    public static IntCollector<?, short[]> toShortArray() {
        return IntCollector.of(Internals.ShortBuffer::new, Internals.ShortBuffer::add, Internals.ShortBuffer::addAll, Internals.ShortBuffer::toArray);
    }

    public static IntCollector<?, boolean[]> toBooleanArray(IntPredicate predicate) {
        return Internals.PartialCollector.booleanArray().asInt((box, t2) -> {
            if (predicate.test(t2)) {
                ((BitSet)box.a).set(box.b);
            }
            box.b = StrictMath.addExact(box.b, 1);
        });
    }
}

