/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util.xmlb;

import java.lang.reflect.Method;
import ksp.com.intellij.openapi.util.Comparing;
import ksp.com.intellij.openapi.util.JDOMUtil;
import ksp.com.intellij.util.ThreeState;
import ksp.com.intellij.util.xmlb.BeanBinding;
import ksp.com.intellij.util.xmlb.Binding;
import ksp.com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import ksp.com.intellij.util.xmlb.TagBinding;
import ksp.org.jdom.Element;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.annotations.TestOnly;

public class SkipDefaultsSerializationFilter
extends SkipDefaultValuesSerializationFilters {
    @TestOnly
    @ApiStatus.Internal
    public SkipDefaultsSerializationFilter() {
    }

    public SkipDefaultsSerializationFilter(Object ... defaultBeans) {
        super(defaultBeans);
    }

    boolean equal(@Nullable Binding binding, @Nullable Object currentValue, @Nullable Object defaultValue) {
        Binding referencedBinding;
        if (defaultValue instanceof Element && currentValue instanceof Element) {
            return JDOMUtil.areElementsEqual((Element)currentValue, (Element)defaultValue);
        }
        if (currentValue == defaultValue) {
            return true;
        }
        if (currentValue == null || defaultValue == null) {
            return false;
        }
        if (binding instanceof TagBinding && (referencedBinding = ((TagBinding)binding).binding) instanceof BeanBinding) {
            BeanBinding classBinding = (BeanBinding)referencedBinding;
            ThreeState compareByFields = classBinding.compareByFields;
            if (compareByFields == ThreeState.UNSURE) {
                Method method = null;
                try {
                    method = classBinding.beanClass.getDeclaredMethod("equals", Object.class);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                classBinding.compareByFields = compareByFields = method == null ? ThreeState.YES : ThreeState.NO;
            }
            if (compareByFields == ThreeState.YES) {
                return classBinding.equalByFields(currentValue, defaultValue, this);
            }
        }
        return Comparing.equal(currentValue, defaultValue);
    }
}

