/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import ksp.com.intellij.lang.java.JavaLanguage;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.openapi.util.Comparing;
import ksp.com.intellij.openapi.util.text.StringUtil;
import ksp.com.intellij.psi.JavaPsiFacade;
import ksp.com.intellij.psi.JavaResolveResult;
import ksp.com.intellij.psi.PsiAnonymousClass;
import ksp.com.intellij.psi.PsiArrayType;
import ksp.com.intellij.psi.PsiCapturedWildcardType;
import ksp.com.intellij.psi.PsiClass;
import ksp.com.intellij.psi.PsiClassType;
import ksp.com.intellij.psi.PsiDiamondType;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiElementFactory;
import ksp.com.intellij.psi.PsiExpression;
import ksp.com.intellij.psi.PsiExpressionList;
import ksp.com.intellij.psi.PsiFile;
import ksp.com.intellij.psi.PsiIntersectionType;
import ksp.com.intellij.psi.PsiJavaCodeReferenceElement;
import ksp.com.intellij.psi.PsiManager;
import ksp.com.intellij.psi.PsiMethod;
import ksp.com.intellij.psi.PsiNewExpression;
import ksp.com.intellij.psi.PsiParameter;
import ksp.com.intellij.psi.PsiReferenceParameterList;
import ksp.com.intellij.psi.PsiResolveHelper;
import ksp.com.intellij.psi.PsiStatement;
import ksp.com.intellij.psi.PsiSubstitutor;
import ksp.com.intellij.psi.PsiType;
import ksp.com.intellij.psi.PsiTypeElement;
import ksp.com.intellij.psi.PsiTypeParameter;
import ksp.com.intellij.psi.PsiTypeParameterListOwner;
import ksp.com.intellij.psi.PsiTypeVisitor;
import ksp.com.intellij.psi.PsiWildcardType;
import ksp.com.intellij.psi.codeStyle.JavaCodeStyleManager;
import ksp.com.intellij.psi.impl.source.tree.java.PsiMethodCallExpressionImpl;
import ksp.com.intellij.psi.infos.CandidateInfo;
import ksp.com.intellij.psi.infos.MethodCandidateInfo;
import ksp.com.intellij.psi.scope.PsiConflictResolver;
import ksp.com.intellij.psi.scope.conflictResolvers.JavaMethodsConflictResolver;
import ksp.com.intellij.psi.scope.processor.MethodCandidatesProcessor;
import ksp.com.intellij.psi.search.GlobalSearchScope;
import ksp.com.intellij.psi.util.CachedValueProvider;
import ksp.com.intellij.psi.util.CachedValuesManager;
import ksp.com.intellij.psi.util.PsiModificationTracker;
import ksp.com.intellij.psi.util.PsiTreeUtil;
import ksp.com.intellij.psi.util.PsiUtil;
import ksp.com.intellij.psi.util.TypeConversionUtil;
import ksp.com.intellij.util.Function;
import ksp.com.intellij.util.IncorrectOperationException;
import ksp.com.intellij.util.VisibilityUtil;
import ksp.com.intellij.util.text.UniqueNameGenerator;
import ksp.org.jetbrains.annotations.NonNls;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public class PsiDiamondTypeImpl
extends PsiDiamondType {
    private static final Logger LOG = Logger.getInstance(PsiDiamondTypeImpl.class);
    private final PsiManager myManager;
    private final PsiTypeElement myTypeElement;

    public PsiDiamondTypeImpl(PsiManager manager, PsiTypeElement psiTypeElement) {
        this.myManager = manager;
        this.myTypeElement = psiTypeElement;
    }

    @Override
    @NotNull
    public String getPresentableText() {
        return "";
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        return "";
    }

    @Override
    @NotNull
    public String getInternalCanonicalText() {
        return "Diamond Type";
    }

    @Override
    public boolean isValid() {
        return false;
    }

    @Override
    public boolean equalsToText(@NotNull @NonNls String text) {
        if (text == null) {
            PsiDiamondTypeImpl.$$$reportNull$$$0(0);
        }
        return text.isEmpty();
    }

    @Override
    public <A> A accept(@NotNull PsiTypeVisitor<A> visitor2) {
        if (visitor2 == null) {
            PsiDiamondTypeImpl.$$$reportNull$$$0(1);
        }
        return visitor2.visitDiamondType(this);
    }

    @Override
    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope(this.myManager.getProject());
        if (globalSearchScope == null) {
            PsiDiamondTypeImpl.$$$reportNull$$$0(2);
        }
        return globalSearchScope;
    }

    @Override
    public PsiType @NotNull [] getSuperTypes() {
        PsiType[] psiTypeArray = new PsiType[]{PsiDiamondTypeImpl.getJavaLangObject(this.myManager, this.getResolveScope())};
        if (psiTypeArray == null) {
            PsiDiamondTypeImpl.$$$reportNull$$$0(3);
        }
        return psiTypeArray;
    }

    @Override
    public PsiDiamondType.DiamondInferenceResult resolveInferredTypes() {
        PsiNewExpression newExpression = this.getNewExpression();
        if (newExpression == null) {
            return PsiDiamondType.DiamondInferenceResult.NULL_RESULT;
        }
        return PsiDiamondTypeImpl.resolveInferredTypes(newExpression);
    }

    private PsiNewExpression getNewExpression() {
        PsiJavaCodeReferenceElement classReference;
        PsiElement typeElementWithDiamondTypeArgument = this.myTypeElement.getParent();
        PsiNewExpression newExpression = PsiTreeUtil.getParentOfType(typeElementWithDiamondTypeArgument, PsiNewExpression.class, true, PsiTypeElement.class, PsiStatement.class);
        if (newExpression != null && (classReference = newExpression.getClassOrAnonymousClassReference()) != null && classReference.getParameterList() == typeElementWithDiamondTypeArgument) {
            return newExpression;
        }
        return null;
    }

    @Override
    @Nullable
    public JavaResolveResult getStaticFactory() {
        PsiNewExpression newExpression = this.getNewExpression();
        return newExpression != null ? PsiDiamondTypeImpl.getStaticFactory(newExpression, newExpression) : null;
    }

    public static PsiDiamondType.DiamondInferenceResult resolveInferredTypes(PsiNewExpression newExpression) {
        return PsiDiamondTypeImpl.resolveInferredTypes(newExpression, newExpression);
    }

    public static PsiDiamondType.DiamondInferenceResult resolveInferredTypes(PsiNewExpression newExpression, PsiElement context2) {
        PsiElement resolve2;
        PsiAnonymousClass anonymousClass = newExpression.getAnonymousClass();
        if (anonymousClass != null && !PsiUtil.isLanguageLevel9OrHigher(newExpression) && (resolve2 = anonymousClass.getBaseClassReference().resolve()) instanceof PsiClass) {
            return PsiDiamondType.DiamondInferenceResult.ANONYMOUS_INNER_RESULT;
        }
        PsiReferenceParameterList referenceParameterList = PsiTreeUtil.getChildOfType(newExpression, PsiReferenceParameterList.class);
        if (referenceParameterList != null && referenceParameterList.getTypeParameterElements().length > 0) {
            return PsiDiamondType.DiamondInferenceResult.EXPLICIT_CONSTRUCTOR_TYPE_ARGS;
        }
        PsiDiamondType.DiamondInferenceResult inferenceResult = PsiDiamondTypeImpl.resolveInferredTypesNoCheck(newExpression, context2);
        if (anonymousClass != null && PsiUtil.isLanguageLevel9OrHigher(newExpression)) {
            InferredAnonymousTypeVisitor anonymousTypeVisitor = new InferredAnonymousTypeVisitor(context2);
            for (PsiType type2 : inferenceResult.getInferredTypes()) {
                Boolean accepted = type2.accept(anonymousTypeVisitor);
                if (accepted == null || accepted.booleanValue()) continue;
                return PsiDiamondType.DiamondInferenceResult.ANONYMOUS_INNER_RESULT;
            }
        }
        return inferenceResult;
    }

    private static JavaResolveResult getStaticFactory(PsiNewExpression newExpression, PsiElement context2) {
        return context2 == newExpression && !MethodCandidateInfo.isOverloadCheck(newExpression.getArgumentList()) ? (JavaResolveResult)CachedValuesManager.getCachedValue(newExpression, () -> new CachedValueProvider.Result<JavaResolveResult>(PsiDiamondTypeImpl.getStaticFactoryCandidateInfo(newExpression, newExpression), PsiModificationTracker.MODIFICATION_COUNT)) : PsiDiamondTypeImpl.getStaticFactoryCandidateInfo(newExpression, context2);
    }

    public static PsiDiamondType.DiamondInferenceResult resolveInferredTypesNoCheck(PsiNewExpression newExpression, PsiElement context2) {
        JavaResolveResult staticFactoryCandidateInfo = PsiDiamondTypeImpl.getStaticFactory(newExpression, context2);
        if (staticFactoryCandidateInfo == null) {
            return PsiDiamondType.DiamondInferenceResult.NULL_RESULT;
        }
        if (!(staticFactoryCandidateInfo instanceof MethodCandidateInfo)) {
            return PsiDiamondType.DiamondInferenceResult.UNRESOLVED_CONSTRUCTOR;
        }
        LOG.assertTrue(!PsiMethodCallExpressionImpl.doWePerformGenericMethodOverloadResolutionNow(newExpression, PsiUtil.getLanguageLevel(newExpression)), "diamond evaluation during overload resolution");
        PsiSubstitutor substitutor2 = staticFactoryCandidateInfo.getSubstitutor();
        final String errorMessage = ((MethodCandidateInfo)staticFactoryCandidateInfo).getInferenceErrorMessageAssumeAlreadyComputed();
        if (errorMessage == null && ((MethodCandidateInfo)staticFactoryCandidateInfo).isErased()) {
            return PsiDiamondType.DiamondInferenceResult.RAW_RESULT;
        }
        PsiMethod staticFactory = ((MethodCandidateInfo)staticFactoryCandidateInfo).getElement();
        PsiTypeParameter[] parameters2 = staticFactory.getTypeParameters();
        PsiElement staticFactoryContext = staticFactory.getContext();
        PsiClass psiClass = PsiTreeUtil.getContextOfType(staticFactoryContext, PsiClass.class, false);
        if (psiClass == null) {
            LOG.error("failed for expression:" + newExpression);
            return PsiDiamondType.DiamondInferenceResult.NULL_RESULT;
        }
        PsiTypeParameter[] classParameters = psiClass.getTypeParameters();
        PsiJavaCodeReferenceElement classOrAnonymousClassReference = newExpression.getClassOrAnonymousClassReference();
        LOG.assertTrue(classOrAnonymousClassReference != null);
        PsiDiamondType.DiamondInferenceResult result2 = new PsiDiamondType.DiamondInferenceResult(classOrAnonymousClassReference.getReferenceName() + "<>"){

            @Override
            public String getErrorMessage() {
                return errorMessage != null ? PsiDiamondType.DiamondInferenceResult.NULL_RESULT.getErrorMessage() : super.getErrorMessage();
            }
        };
        if (errorMessage == null && PsiUtil.isRawSubstitutor(staticFactory, substitutor2)) {
            if (!PsiUtil.isLanguageLevel8OrHigher(newExpression) && PsiUtil.skipParenthesizedExprUp(newExpression.getParent()) instanceof PsiExpressionList) {
                for (PsiTypeParameter ignored : parameters2) {
                    result2.addInferredType(PsiType.getJavaLangObject(newExpression.getManager(), GlobalSearchScope.allScope(newExpression.getProject())));
                }
            }
            return result2;
        }
        block1: for (PsiTypeParameter parameter2 : parameters2) {
            for (PsiTypeParameter classParameter : classParameters) {
                if (!Comparing.strEqual(classParameter.getName(), parameter2.getName())) continue;
                result2.addInferredType(substitutor2.substitute(parameter2));
                continue block1;
            }
        }
        return result2;
    }

    private static JavaResolveResult getStaticFactoryCandidateInfo(@NotNull PsiNewExpression newExpression, PsiElement context2) {
        if (newExpression == null) {
            PsiDiamondTypeImpl.$$$reportNull$$$0(4);
        }
        return ourDiamondGuard.doPreventingRecursion(context2, false, () -> {
            PsiMethod staticFactory;
            PsiExpressionList argumentList = newExpression.getArgumentList();
            if (argumentList == null) {
                return null;
            }
            PsiFile containingFile2 = argumentList.getContainingFile();
            if (containingFile2 == null) {
                return null;
            }
            JavaMethodsConflictResolver resolver = new JavaMethodsConflictResolver(argumentList, null, PsiUtil.getLanguageLevel(containingFile2), containingFile2);
            List<CandidateInfo> results = PsiDiamondTypeImpl.collectStaticFactories(newExpression);
            CandidateInfo result2 = results != null ? resolver.resolveConflict(new ArrayList<CandidateInfo>(results)) : null;
            PsiMethod psiMethod = staticFactory = result2 != null ? (PsiMethod)result2.getElement() : null;
            if (staticFactory == null) {
                return JavaResolveResult.EMPTY;
            }
            MethodCandidateInfo staticFactoryCandidateInfo = PsiDiamondTypeImpl.createMethodCandidate((MethodCandidateInfo)result2, context2, false, argumentList);
            if (!staticFactory.isVarArgs()) {
                return staticFactoryCandidateInfo;
            }
            ArrayList<CandidateInfo> conflicts = new ArrayList<CandidateInfo>();
            conflicts.add(staticFactoryCandidateInfo);
            conflicts.add(PsiDiamondTypeImpl.createMethodCandidate((MethodCandidateInfo)result2, context2, true, argumentList));
            return resolver.resolveConflict(conflicts);
        });
    }

    @Nullable
    public static List<CandidateInfo> collectStaticFactories(PsiNewExpression newExpression) {
        return (List)CachedValuesManager.getCachedValue(newExpression, () -> new CachedValueProvider.Result<List<CandidateInfo>>(PsiDiamondTypeImpl.collectStaticFactoriesInner(newExpression), PsiModificationTracker.MODIFICATION_COUNT));
    }

    private static List<CandidateInfo> collectStaticFactoriesInner(final PsiNewExpression newExpression) {
        final PsiExpressionList argumentList = newExpression.getArgumentList();
        if (argumentList == null) {
            return null;
        }
        final PsiClass psiClass = PsiDiamondTypeImpl.findClass(newExpression);
        if (psiClass == null) {
            return null;
        }
        ArrayList candidates2 = new ArrayList();
        PsiMethod[] constructors2 = psiClass.getConstructors();
        if (constructors2.length == 0) {
            constructors2 = new PsiMethod[]{null};
        }
        PsiFile containingFile2 = argumentList.getContainingFile();
        MethodCandidatesProcessor processor = new MethodCandidatesProcessor(argumentList, containingFile2, new PsiConflictResolver[0], candidates2){

            @Override
            protected boolean isAccepted(@NotNull PsiMethod candidate) {
                if (candidate == null) {
                    2.$$$reportNull$$$0(0);
                }
                return true;
            }

            @Override
            protected PsiClass getContainingClass(@NotNull PsiMethod method) {
                if (method == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (newExpression.getAnonymousClass() != null) {
                    return PsiTreeUtil.getContextOfType((PsiElement)argumentList, PsiClass.class, false);
                }
                return psiClass;
            }

            @Override
            protected boolean acceptVarargs() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "candidate";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "method";
                        break;
                    }
                }
                objectArray2[1] = "ksp/com/intellij/psi/PsiDiamondTypeImpl$2";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isAccepted";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getContainingClass";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        processor.setArgumentList(argumentList);
        for (PsiMethod constructor : constructors2) {
            PsiTypeParameter[] params = PsiDiamondTypeImpl.getAllTypeParams(constructor, psiClass);
            PsiMethod staticFactory = PsiDiamondTypeImpl.generateStaticFactory(constructor, psiClass, params, newExpression.getClassReference());
            if (staticFactory == null) continue;
            processor.add(staticFactory, PsiSubstitutor.EMPTY);
        }
        return processor.getResults();
    }

    @Nullable
    private static PsiClass findClass(PsiNewExpression newExpression) {
        PsiJavaCodeReferenceElement classReference = newExpression.getClassOrAnonymousClassReference();
        if (classReference != null) {
            String text = classReference.getReferenceName();
            if (text != null) {
                PsiClass aClass;
                Project project = newExpression.getProject();
                JavaPsiFacade facade = JavaPsiFacade.getInstance(project);
                PsiResolveHelper resolveHelper = facade.getResolveHelper();
                PsiExpression newExpressionQualifier = newExpression.getQualifier();
                PsiElement qualifierElement = classReference.getQualifier();
                String qualifier2 = qualifierElement != null ? qualifierElement.getText() : "";
                String qualifiedName2 = StringUtil.getQualifiedName(qualifier2, text);
                if (newExpressionQualifier != null && (aClass = PsiUtil.resolveClassInClassTypeOnly(newExpressionQualifier.getType())) != null) {
                    return aClass.findInnerClassByName(qualifiedName2, false);
                }
                return resolveHelper.resolveReferencedClass(qualifiedName2, newExpression);
            }
            return null;
        }
        return null;
    }

    @Nullable
    private static PsiMethod generateStaticFactory(@Nullable PsiMethod constructor, PsiClass containingClass, PsiTypeParameter[] params, PsiJavaCodeReferenceElement reference2) {
        PsiElement qualifier2;
        StringBuilder buf = new StringBuilder();
        String modifier = VisibilityUtil.getVisibilityModifier(constructor != null ? constructor.getModifierList() : containingClass.getModifierList());
        if (!"packageLocal".equals(modifier)) {
            buf.append(modifier);
            buf.append(" ");
        }
        buf.append("static ");
        buf.append("<");
        UniqueNameGenerator generator = new UniqueNameGenerator();
        buf.append(StringUtil.join(params, psiTypeParameter -> {
            PsiClassType[] extendsListTypes;
            String extendsList = "";
            if (psiTypeParameter.getLanguage().isKindOf(JavaLanguage.INSTANCE) && (extendsListTypes = psiTypeParameter.getExtendsListTypes()).length > 0) {
                Function<PsiClassType, String> canonicalTypePresentationFun = type2 -> type2.getCanonicalText();
                extendsList = " extends " + StringUtil.join(extendsListTypes, canonicalTypePresentationFun, "&");
            }
            return generator.generateUniqueName(psiTypeParameter.getName()) + extendsList;
        }, ", "));
        buf.append(">");
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(containingClass.getProject());
        String qualifiedName2 = containingClass.getQualifiedName();
        PsiElement psiElement = qualifier2 = reference2 != null ? reference2.getQualifier() : null;
        if (qualifier2 instanceof PsiJavaCodeReferenceElement) {
            JavaResolveResult resolveResult = ((PsiJavaCodeReferenceElement)qualifier2).advancedResolve(false);
            PsiElement element2 = resolveResult.getElement();
            if (element2 instanceof PsiClass) {
                String outerClassSubstitutedQName = elementFactory.createType((PsiClass)element2, resolveResult.getSubstitutor()).getInternalCanonicalText();
                qualifiedName2 = outerClassSubstitutedQName + "." + containingClass.getName();
            }
        } else if (reference2 != null && qualifier2 == null && containingClass.getContainingClass() != null) {
            qualifiedName2 = null;
        }
        buf.append(qualifiedName2 != null ? qualifiedName2 : containingClass.getName());
        PsiTypeParameter[] parameters2 = containingClass.getTypeParameters();
        buf.append("<");
        buf.append(StringUtil.join(parameters2, psiTypeParameter -> psiTypeParameter.getName(), ", "));
        buf.append("> ");
        String staticFactoryName = "staticFactory";
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance(containingClass.getProject());
        staticFactoryName = styleManager.suggestUniqueVariableName(staticFactoryName, (PsiElement)containingClass, false);
        buf.append(staticFactoryName);
        if (constructor == null) {
            buf.append("()");
        } else {
            buf.append("(").append(StringUtil.join(constructor.getParameterList().getParameters(), new Function<PsiParameter, String>(){
                int myIdx;

                @Override
                public String fun(PsiParameter psiParameter) {
                    return psiParameter.getType().getCanonicalText() + " p" + this.myIdx++;
                }
            }, ",")).append(")");
            PsiClassType[] types2 = constructor.getThrowsList().getReferencedTypes();
            if (types2.length > 0) {
                buf.append("throws ").append(StringUtil.join(types2, type2 -> type2.getCanonicalText(), ", "));
            }
        }
        buf.append("{}");
        try {
            return elementFactory.createMethodFromText(buf.toString(), constructor != null ? constructor : containingClass);
        }
        catch (IncorrectOperationException e2) {
            return null;
        }
    }

    private static PsiTypeParameter @NotNull [] getAllTypeParams(PsiTypeParameterListOwner listOwner, PsiClass containingClass) {
        LinkedHashSet params = new LinkedHashSet();
        Collections.addAll(params, containingClass.getTypeParameters());
        if (listOwner != null) {
            Collections.addAll(params, listOwner.getTypeParameters());
        }
        PsiTypeParameter[] psiTypeParameterArray = params.toArray(PsiTypeParameter.EMPTY_ARRAY);
        if (psiTypeParameterArray == null) {
            PsiDiamondTypeImpl.$$$reportNull$$$0(5);
        }
        return psiTypeParameterArray;
    }

    private static MethodCandidateInfo createMethodCandidate(@NotNull MethodCandidateInfo staticFactoryMethod, final PsiElement parent2, final boolean varargs, final PsiExpressionList argumentList) {
        if (staticFactoryMethod == null) {
            PsiDiamondTypeImpl.$$$reportNull$$$0(6);
        }
        return new MethodCandidateInfo(staticFactoryMethod.getElement(), PsiSubstitutor.EMPTY, !staticFactoryMethod.isAccessible(), false, argumentList, parent2, null, null){
            private PsiType[] myExpressionTypes;

            @Override
            public boolean isVarargs() {
                return varargs;
            }

            @Override
            protected PsiElement getParent() {
                return parent2;
            }

            @Override
            public PsiType[] getArgumentTypes() {
                if (this.myExpressionTypes == null) {
                    PsiType[] expressionTypes = argumentList.getExpressionTypes();
                    if (MethodCandidateInfo.isOverloadCheck()) {
                        return expressionTypes;
                    }
                    this.myExpressionTypes = expressionTypes;
                }
                return this.myExpressionTypes;
            }
        };
    }

    public static boolean hasDefaultConstructor(@NotNull PsiClass psiClass) {
        PsiMethod[] constructors2;
        if (psiClass == null) {
            PsiDiamondTypeImpl.$$$reportNull$$$0(7);
        }
        for (PsiMethod method : constructors2 = psiClass.getConstructors()) {
            if (!method.getParameterList().isEmpty()) continue;
            return true;
        }
        return constructors2.length == 0;
    }

    public static boolean haveConstructorsGenericsParameters(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            PsiDiamondTypeImpl.$$$reportNull$$$0(8);
        }
        for (final PsiMethod method : psiClass.getConstructors()) {
            for (PsiParameter parameter2 : method.getParameterList().getParameters()) {
                PsiType type2 = parameter2.getType();
                Boolean accept2 = type2.accept(new PsiTypeVisitor<Boolean>(){

                    @Override
                    public Boolean visitArrayType(@NotNull PsiArrayType arrayType2) {
                        if (arrayType2 == null) {
                            5.$$$reportNull$$$0(0);
                        }
                        return arrayType2.getComponentType().accept(this);
                    }

                    @Override
                    public Boolean visitClassType(@NotNull PsiClassType classType) {
                        if (classType == null) {
                            5.$$$reportNull$$$0(1);
                        }
                        for (PsiType psiType : classType.getParameters()) {
                            Boolean typeParamFound;
                            if (psiType == null || (typeParamFound = psiType.accept(this)) == null || !typeParamFound.booleanValue()) continue;
                            return true;
                        }
                        PsiClass aClass = PsiUtil.resolveClassInType(classType);
                        return aClass instanceof PsiTypeParameter && ((PsiTypeParameter)aClass).getOwner() == method;
                    }

                    @Override
                    public Boolean visitWildcardType(@NotNull PsiWildcardType wildcardType) {
                        PsiType bound;
                        if (wildcardType == null) {
                            5.$$$reportNull$$$0(2);
                        }
                        if ((bound = wildcardType.getBound()) == null) {
                            return false;
                        }
                        return bound.accept(this);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n2) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "arrayType";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "classType";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "wildcardType";
                                break;
                            }
                        }
                        objectArray2[1] = "ksp/com/intellij/psi/PsiDiamondTypeImpl$5";
                        switch (n2) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "visitArrayType";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "visitClassType";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "visitWildcardType";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
                if (accept2 == null || !accept2.booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/psi/PsiDiamondTypeImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpression";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "staticFactoryMethod";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/psi/PsiDiamondTypeImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveScope";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperTypes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllTypeParams";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "equalsToText";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getStaticFactoryCandidateInfo";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createMethodCandidate";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "hasDefaultConstructor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "haveConstructorsGenericsParameters";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class InferredAnonymousTypeVisitor
    extends PsiTypeVisitor<Boolean> {
        private final PsiElement myExpression;

        InferredAnonymousTypeVisitor(PsiElement expression2) {
            this.myExpression = expression2;
        }

        @Override
        @Nullable
        public Boolean visitType(@NotNull PsiType type2) {
            if (type2 == null) {
                InferredAnonymousTypeVisitor.$$$reportNull$$$0(0);
            }
            return true;
        }

        @Override
        @Nullable
        public Boolean visitCapturedWildcardType(@NotNull PsiCapturedWildcardType capturedWildcardType) {
            if (capturedWildcardType == null) {
                InferredAnonymousTypeVisitor.$$$reportNull$$$0(1);
            }
            return false;
        }

        @Override
        @Nullable
        public Boolean visitIntersectionType(@NotNull PsiIntersectionType intersectionType) {
            if (intersectionType == null) {
                InferredAnonymousTypeVisitor.$$$reportNull$$$0(2);
            }
            return false;
        }

        @Override
        @Nullable
        public Boolean visitClassType(@NotNull PsiClassType classType) {
            PsiClassType.ClassResolveResult resolveResult;
            PsiClass psiClass;
            if (classType == null) {
                InferredAnonymousTypeVisitor.$$$reportNull$$$0(3);
            }
            if ((psiClass = (resolveResult = classType.resolveGenerics()).getElement()) != null) {
                if (psiClass instanceof PsiTypeParameter && TypeConversionUtil.isFreshVariable((PsiTypeParameter)psiClass)) {
                    return false;
                }
                if (!PsiUtil.isAccessible(psiClass, this.myExpression, null)) {
                    return false;
                }
                for (PsiType psiType : resolveResult.getSubstitutor().getSubstitutionMap().values()) {
                    Boolean accepted = psiType != null ? psiType.accept(this) : null;
                    if (accepted == null || accepted.booleanValue()) continue;
                    return false;
                }
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "capturedWildcardType";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "intersectionType";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classType";
                    break;
                }
            }
            objectArray2[1] = "ksp/com/intellij/psi/PsiDiamondTypeImpl$InferredAnonymousTypeVisitor";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitCapturedWildcardType";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitIntersectionType";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClassType";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

