/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.patterns;

import java.util.Objects;
import ksp.com.intellij.openapi.util.Ref;
import ksp.com.intellij.patterns.ElementPattern;
import ksp.com.intellij.patterns.PatternCondition;
import ksp.com.intellij.patterns.PatternConditionPlus;
import ksp.com.intellij.patterns.PsiJavaPatterns;
import ksp.com.intellij.patterns.PsiMemberPattern;
import ksp.com.intellij.psi.PsiClass;
import ksp.com.intellij.psi.PsiMethod;
import ksp.com.intellij.psi.PsiParameter;
import ksp.com.intellij.psi.PsiParameterList;
import ksp.com.intellij.psi.PsiType;
import ksp.com.intellij.psi.search.searches.SuperMethodsSearch;
import ksp.com.intellij.psi.util.TypeConversionUtil;
import ksp.com.intellij.util.ArrayUtilRt;
import ksp.com.intellij.util.PairProcessor;
import ksp.com.intellij.util.ProcessingContext;
import ksp.org.jetbrains.annotations.NonNls;
import ksp.org.jetbrains.annotations.NotNull;

public class PsiMethodPattern
extends PsiMemberPattern<PsiMethod, PsiMethodPattern> {
    public PsiMethodPattern() {
        super(PsiMethod.class);
    }

    public PsiMethodPattern withParameterCount(final @NonNls int paramCount) {
        return (PsiMethodPattern)this.with(new PatternCondition<PsiMethod>("withParameterCount"){

            @Override
            public boolean accepts(@NotNull PsiMethod method, ProcessingContext context2) {
                if (method == null) {
                    1.$$$reportNull$$$0(0);
                }
                return method.getParameterList().getParametersCount() == paramCount;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "ksp/com/intellij/patterns/PsiMethodPattern$1", "accepts"));
            }
        });
    }

    public PsiMethodPattern withParameters(String ... inputTypes) {
        final String[] types2 = inputTypes.length == 0 ? ArrayUtilRt.EMPTY_STRING_ARRAY : inputTypes;
        return (PsiMethodPattern)this.with(new PatternCondition<PsiMethod>("withParameters"){

            @Override
            public boolean accepts(@NotNull PsiMethod psiMethod, ProcessingContext context2) {
                if (psiMethod == null) {
                    2.$$$reportNull$$$0(0);
                }
                PsiParameterList parameterList2 = psiMethod.getParameterList();
                int dotsIndex = -1;
                while (++dotsIndex < types2.length && !Objects.equals("..", types2[dotsIndex])) {
                }
                if (dotsIndex == types2.length && parameterList2.getParametersCount() != dotsIndex || dotsIndex < types2.length && parameterList2.getParametersCount() < dotsIndex) {
                    return false;
                }
                if (dotsIndex > 0) {
                    PsiParameter[] psiParameters = parameterList2.getParameters();
                    for (int i2 = 0; i2 < dotsIndex; ++i2) {
                        if (Objects.equals("?", types2[i2]) || this.typeEquivalent(psiParameters[i2].getType(), types2[i2])) continue;
                        return false;
                    }
                }
                return true;
            }

            private boolean typeEquivalent(PsiType type2, String expectedText) {
                PsiType erasure = TypeConversionUtil.erasure(type2);
                return erasure != null && erasure.equalsToText(expectedText);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "ksp/com/intellij/patterns/PsiMethodPattern$2", "accepts"));
            }
        });
    }

    @NotNull
    public PsiMethodPattern definedInClass(@NonNls String qname) {
        PsiMethodPattern psiMethodPattern = this.definedInClass(PsiJavaPatterns.psiClass().withQualifiedName(qname));
        if (psiMethodPattern == null) {
            PsiMethodPattern.$$$reportNull$$$0(0);
        }
        return psiMethodPattern;
    }

    @NotNull
    public PsiMethodPattern definedInClass(ElementPattern<? extends PsiClass> pattern) {
        PsiMethodPattern psiMethodPattern = (PsiMethodPattern)this.with(new PatternConditionPlus<PsiMethod, PsiClass>("definedInClass", pattern){

            @Override
            public boolean processValues(PsiMethod t2, ProcessingContext context2, PairProcessor<? super PsiClass, ? super ProcessingContext> processor) {
                if (!processor.process(t2.getContainingClass(), context2)) {
                    return false;
                }
                Ref<Boolean> result2 = Ref.create(Boolean.TRUE);
                SuperMethodsSearch.search(t2, null, true, false).forEach(signature -> {
                    if (!processor.process(signature.getMethod().getContainingClass(), context2)) {
                        result2.set(Boolean.FALSE);
                        return false;
                    }
                    return true;
                });
                return result2.get();
            }
        });
        if (psiMethodPattern == null) {
            PsiMethodPattern.$$$reportNull$$$0(1);
        }
        return psiMethodPattern;
    }

    public PsiMethodPattern constructor(final boolean isConstructor) {
        return (PsiMethodPattern)this.with(new PatternCondition<PsiMethod>("constructor"){

            @Override
            public boolean accepts(@NotNull PsiMethod method, ProcessingContext context2) {
                if (method == null) {
                    4.$$$reportNull$$$0(0);
                }
                return method.isConstructor() == isConstructor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "ksp/com/intellij/patterns/PsiMethodPattern$4", "accepts"));
            }
        });
    }

    public PsiMethodPattern withThrowsList(final ElementPattern<?> pattern) {
        return (PsiMethodPattern)this.with(new PatternCondition<PsiMethod>("withThrowsList"){

            @Override
            public boolean accepts(@NotNull PsiMethod method, ProcessingContext context2) {
                if (method == null) {
                    5.$$$reportNull$$$0(0);
                }
                return pattern.accepts(method.getThrowsList());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "ksp/com/intellij/patterns/PsiMethodPattern$5", "accepts"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ksp/com/intellij/patterns/PsiMethodPattern", "definedInClass"));
    }
}

