/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.js.checkers.declaration;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import ksp.com.intellij.lang.LighterASTNode;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.tree.IElementType;
import ksp.com.intellij.util.diff.FlyweightCapableTreeStructure;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtFakePsiSourceElement;
import ksp.org.jetbrains.kotlin.KtFakeSourceElementKind;
import ksp.org.jetbrains.kotlin.KtLightSourceElement;
import ksp.org.jetbrains.kotlin.KtNodeTypes;
import ksp.org.jetbrains.kotlin.KtPsiSourceElement;
import ksp.org.jetbrains.kotlin.KtRealPsiSourceElement;
import ksp.org.jetbrains.kotlin.KtRealSourceElementKind;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.KtSourceElementKind;
import ksp.org.jetbrains.kotlin.KtSourceElementKt;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.UtilsKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsHelpersKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirFile;
import ksp.org.jetbrains.kotlin.psi.KtPsiUtil;
import ksp.org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import ksp.org.jetbrains.kotlin.util.LightTreeUtilsKt;
import ksp.org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsPackageDirectiveChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirFile;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFileChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.js"})
@SourceDebugExtension(value={"SMAP\nFirJsPackageDirectiveChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJsPackageDirectiveChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsPackageDirectiveChecker\n+ 2 FirSourceUtils.kt\norg/jetbrains/kotlin/fir/analysis/FirSourceUtilsKt\n+ 3 KtSourceElement.kt\norg/jetbrains/kotlin/KtSourceElementKt\n+ 4 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,42:1\n42#2,7:43\n64#2:50\n96#2,6:51\n66#2:57\n102#2:58\n49#2:59\n50#2:65\n105#2,5:66\n67#2:71\n110#2,2:74\n113#2:77\n69#2:78\n51#2,2:79\n80#2:81\n96#2,6:82\n82#2:88\n102#2:89\n53#2:97\n105#2,5:98\n83#2:103\n110#2,4:104\n85#2:108\n54#2:109\n879#3,5:60\n885#3,7:90\n234#4:72\n1869#5:73\n1870#5:76\n*S KotlinDebug\n*F\n+ 1 FirJsPackageDirectiveChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsPackageDirectiveChecker\n*L\n29#1:43,7\n29#1:50\n29#1:51,6\n29#1:57\n29#1:58\n29#1:59\n29#1:65\n29#1:66,5\n29#1:71\n29#1:74,2\n29#1:77\n29#1:78\n29#1:79,2\n29#1:81\n29#1:82,6\n29#1:88\n29#1:89\n29#1:97\n29#1:98,5\n29#1:103\n29#1:104,4\n29#1:108\n29#1:109\n29#1:60,5\n29#1:90,7\n29#1:72\n29#1:73\n29#1:76\n*E\n"})
public final class FirJsPackageDirectiveChecker
extends FirDeclarationChecker<FirFile> {
    @NotNull
    public static final FirJsPackageDirectiveChecker INSTANCE = new FirJsPackageDirectiveChecker();

    private FirJsPackageDirectiveChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull FirFile declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (UtilsKt.getPackageFqName(declaration2).isRoot()) {
            return;
        }
        if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.JsAllowInvalidCharsIdentifiersEscaping)) {
            return;
        }
        KtSourceElement ktSourceElement = declaration2.getPackageDirective().getSource();
        if (ktSourceElement != null) {
            void types$iv;
            void $this$forEachChildOfType_u24default$iv;
            KtSourceElement ktSourceElement2 = ktSourceElement;
            Set set = SetsKt.setOf((Object)KtNodeTypes.REFERENCE_EXPRESSION);
            int depth$iv = -1;
            boolean reverse$iv = false;
            boolean $i$f$forEachChildOfType = false;
            void var9_9 = $this$forEachChildOfType_u24default$iv;
            if (var9_9 instanceof KtPsiSourceElement) {
                PsiElement $this$forEachChildOfType$iv$iv = ((KtPsiSourceElement)$this$forEachChildOfType_u24default$iv).getPsi();
                boolean $i$f$forEachChildOfType2 = false;
                boolean $i$f$forEachChildOfType3 = false;
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)$this$forEachChildOfType$iv$iv, (Object)0)};
                List stack$iv$iv$iv = CollectionsKt.mutableListOf((Object[])pairArray);
                while (!((Collection)stack$iv$iv$iv).isEmpty()) {
                    void $this$forEach$iv$iv$iv$iv;
                    Iterable $this$butIf$iv$iv$iv$iv;
                    PsiElement it$iv$iv;
                    pairArray = (Pair[])AddToStdlibKt.popLast(stack$iv$iv$iv);
                    Object element$iv$iv$iv = pairArray.component1();
                    int currentDepth$iv$iv$iv = ((Number)pairArray.component2()).intValue();
                    if (currentDepth$iv$iv$iv != 0) {
                        PsiElement psiElement = (PsiElement)element$iv$iv$iv;
                        void var18_26 = types$iv;
                        boolean bl2 = false;
                        IElementType iElementType = it$iv$iv.getNode().getElementType();
                        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
                        if (var18_26.contains(iElementType)) {
                            String name2;
                            KtPsiSourceElement ktPsiSourceElement;
                            PsiElement it$iv = (PsiElement)element$iv$iv$iv;
                            boolean bl3 = false;
                            PsiElement $this$toKtPsiSourceElement_u24default$iv$iv = it$iv;
                            KtSourceElementKind kind$iv$iv = KtRealSourceElementKind.INSTANCE;
                            boolean $i$f$toKtPsiSourceElement = false;
                            KtSourceElementKind ktSourceElementKind = kind$iv$iv;
                            if (ktSourceElementKind instanceof KtRealSourceElementKind) {
                                ktPsiSourceElement = new KtRealPsiSourceElement($this$toKtPsiSourceElement_u24default$iv$iv);
                            } else if (ktSourceElementKind instanceof KtFakeSourceElementKind) {
                                ktPsiSourceElement = new KtFakePsiSourceElement($this$toKtPsiSourceElement_u24default$iv$iv, (KtFakeSourceElementKind)kind$iv$iv);
                            } else {
                                throw new NoWhenBranchMatchedException();
                            }
                            KtSourceElement it = ktPsiSourceElement;
                            boolean bl4 = false;
                            Intrinsics.checkNotNullExpressionValue((Object)KtPsiUtil.unquoteIdentifier(String.valueOf(KtSourceElementKt.getText(it))), (String)"unquoteIdentifier(...)");
                            if (!Intrinsics.areEqual((Object)FirJsHelpersKt.sanitizeName(name2), (Object)name2)) {
                                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it, FirErrors.INSTANCE.getINVALID_CHARACTERS(), (Object)(name2 + " contains illegal characters"), (DiagnosticContext)context2, null, 16, null);
                            }
                        }
                    }
                    if (currentDepth$iv$iv$iv == depth$iv) continue;
                    it$iv$iv = (PsiElement)element$iv$iv$iv;
                    boolean bl5 = false;
                    List list = SequencesKt.toList((Sequence)PsiUtilsKt.getAllChildren(it$iv$iv));
                    boolean condition$iv$iv$iv$iv = true;
                    boolean $i$f$butIf22 = false;
                    void it$iv$iv$iv = $this$butIf$iv$iv$iv$iv;
                    boolean bl6 = false;
                    $this$butIf$iv$iv$iv$iv = CollectionsKt.asReversed((List)it$iv$iv$iv);
                    boolean $i$f$forEach = false;
                    Iterator $i$f$butIf22 = $this$forEach$iv$iv$iv$iv.iterator();
                    while ($i$f$butIf22.hasNext()) {
                        Object element$iv$iv$iv$iv;
                        Object child$iv$iv$iv = element$iv$iv$iv$iv = $i$f$butIf22.next();
                        boolean bl7 = false;
                        ((Collection)stack$iv$iv$iv).add(TuplesKt.to(child$iv$iv$iv, (Object)(currentDepth$iv$iv$iv + 1)));
                    }
                }
            } else if (var9_9 instanceof KtLightSourceElement) {
                LighterASTNode $this$forEachChildOfType$iv$iv = ((KtLightSourceElement)$this$forEachChildOfType_u24default$iv).getLighterASTNode();
                FlyweightCapableTreeStructure<LighterASTNode> treeStructure$iv$iv = ((KtLightSourceElement)$this$forEachChildOfType_u24default$iv).getTreeStructure();
                boolean $i$f$forEachChildOfType4 = false;
                boolean $i$f$forEachChildOfType5 = false;
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)$this$forEachChildOfType$iv$iv, (Object)0)};
                List stack$iv$iv$iv = CollectionsKt.mutableListOf((Object[])pairArray);
                while (!((Collection)stack$iv$iv$iv).isEmpty()) {
                    void $this$forEach$iv$iv$iv$iv;
                    Iterable $this$butIf$iv$iv$iv$iv;
                    LighterASTNode it$iv$iv;
                    pairArray = (Pair[])AddToStdlibKt.popLast(stack$iv$iv$iv);
                    Object element$iv$iv$iv = pairArray.component1();
                    int currentDepth$iv$iv$iv = ((Number)pairArray.component2()).intValue();
                    if (currentDepth$iv$iv$iv != 0) {
                        LighterASTNode lighterASTNode = (LighterASTNode)element$iv$iv$iv;
                        void var19_29 = types$iv;
                        boolean bl8 = false;
                        IElementType iElementType = it$iv$iv.getTokenType();
                        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getTokenType(...)");
                        if (var19_29.contains(iElementType)) {
                            String name3;
                            void $this$toKtLightSourceElement_u24default$iv$iv;
                            LighterASTNode it$iv = (LighterASTNode)element$iv$iv$iv;
                            boolean bl9 = false;
                            LighterASTNode kind$iv$iv = it$iv;
                            FlyweightCapableTreeStructure<LighterASTNode> tree$iv$iv = ((KtLightSourceElement)$this$forEachChildOfType_u24default$iv).getTreeStructure();
                            KtSourceElementKind kind$iv$iv2 = KtRealSourceElementKind.INSTANCE;
                            int startOffset$iv$iv = $this$toKtLightSourceElement_u24default$iv$iv.getStartOffset();
                            int endOffset$iv$iv = $this$toKtLightSourceElement_u24default$iv$iv.getEndOffset();
                            boolean $i$f$toKtLightSourceElement = false;
                            KtSourceElement it = new KtLightSourceElement((LighterASTNode)$this$toKtLightSourceElement_u24default$iv$iv, startOffset$iv$iv, endOffset$iv$iv, tree$iv$iv, kind$iv$iv2);
                            boolean bl10 = false;
                            Intrinsics.checkNotNullExpressionValue((Object)KtPsiUtil.unquoteIdentifier(String.valueOf(KtSourceElementKt.getText(it))), (String)"unquoteIdentifier(...)");
                            if (!Intrinsics.areEqual((Object)FirJsHelpersKt.sanitizeName(name3), (Object)name3)) {
                                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it, FirErrors.INSTANCE.getINVALID_CHARACTERS(), (Object)(name3 + " contains illegal characters"), (DiagnosticContext)context2, null, 16, null);
                            }
                        }
                    }
                    if (currentDepth$iv$iv$iv == depth$iv) continue;
                    it$iv$iv = (LighterASTNode)element$iv$iv$iv;
                    boolean bl11 = false;
                    List<LighterASTNode> element$iv$iv$iv$iv = LightTreeUtilsKt.getChildren(it$iv$iv, treeStructure$iv$iv);
                    boolean condition$iv$iv$iv$iv = true;
                    boolean $i$f$butIf = false;
                    void it$iv$iv$iv = $this$butIf$iv$iv$iv$iv;
                    boolean bl12 = false;
                    $this$butIf$iv$iv$iv$iv = CollectionsKt.asReversed((List)it$iv$iv$iv);
                    boolean $i$f$forEach = false;
                    Iterator iterator2 = $this$forEach$iv$iv$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        Object element$iv$iv$iv$iv2;
                        Object child$iv$iv$iv = element$iv$iv$iv$iv2 = iterator2.next();
                        boolean bl13 = false;
                        ((Collection)stack$iv$iv$iv).add(TuplesKt.to(child$iv$iv$iv, (Object)(currentDepth$iv$iv$iv + 1)));
                    }
                }
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
    }
}

