/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.cli.jvm.compiler;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.psi.search.GlobalSearchScope;
import ksp.com.intellij.util.SmartList;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import ksp.org.jetbrains.kotlin.cli.jvm.compiler.JvmPackagePartProviderKt;
import ksp.org.jetbrains.kotlin.cli.jvm.index.JavaRoot;
import ksp.org.jetbrains.kotlin.config.LanguageVersionSettings;
import ksp.org.jetbrains.kotlin.load.kotlin.JvmPackagePartProviderBase;
import ksp.org.jetbrains.kotlin.metadata.jvm.deserialization.ModuleMapping;
import ksp.org.jetbrains.kotlin.resolve.JvmCompilerDeserializationConfiguration;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001c\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR \u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000f0\u000eX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0019"}, d2={"Lksp/org/jetbrains/kotlin/cli/jvm/compiler/JvmPackagePartProvider;", "Lksp/org/jetbrains/kotlin/load/kotlin/JvmPackagePartProviderBase;", "Lksp/com/intellij/openapi/vfs/VirtualFile;", "languageVersionSettings", "Lksp/org/jetbrains/kotlin/config/LanguageVersionSettings;", "scope", "Lksp/com/intellij/psi/search/GlobalSearchScope;", "<init>", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lcom/intellij/psi/search/GlobalSearchScope;)V", "deserializationConfiguration", "Lksp/org/jetbrains/kotlin/resolve/JvmCompilerDeserializationConfiguration;", "getDeserializationConfiguration", "()Lorg/jetbrains/kotlin/resolve/JvmCompilerDeserializationConfiguration;", "loadedModules", "", "Lksp/org/jetbrains/kotlin/load/kotlin/JvmPackagePartProviderBase$ModuleMappingInfo;", "getLoadedModules", "()Ljava/util/List;", "addRoots", "", "roots", "", "Lksp/org/jetbrains/kotlin/cli/jvm/index/JavaRoot;", "messageCollector", "Lksp/org/jetbrains/kotlin/cli/common/messages/MessageCollector;", "cli-base"})
public final class JvmPackagePartProvider
extends JvmPackagePartProviderBase<VirtualFile> {
    @NotNull
    private final GlobalSearchScope scope;
    @NotNull
    private final JvmCompilerDeserializationConfiguration deserializationConfiguration;
    @NotNull
    private final List<JvmPackagePartProviderBase.ModuleMappingInfo<VirtualFile>> loadedModules;

    public JvmPackagePartProvider(@NotNull LanguageVersionSettings languageVersionSettings, @NotNull GlobalSearchScope scope) {
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.scope = scope;
        this.deserializationConfiguration = new JvmCompilerDeserializationConfiguration(languageVersionSettings);
        this.loadedModules = new SmartList();
    }

    @Override
    @NotNull
    public JvmCompilerDeserializationConfiguration getDeserializationConfiguration() {
        return this.deserializationConfiguration;
    }

    @Override
    @NotNull
    protected List<JvmPackagePartProviderBase.ModuleMappingInfo<VirtualFile>> getLoadedModules() {
        return this.loadedModules;
    }

    public final void addRoots(@NotNull List<JavaRoot> roots, @NotNull MessageCollector messageCollector) {
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        Intrinsics.checkNotNullParameter((Object)messageCollector, (String)"messageCollector");
        for (JavaRoot javaRoot : roots) {
            VirtualFile metaInf;
            VirtualFile root = javaRoot.component1();
            JavaRoot.RootType type2 = javaRoot.component2();
            if (type2 != JavaRoot.RootType.BINARY || !this.scope.contains(root) || root.findChild("META-INF") == null) continue;
            Iterator iterator2 = ArrayIteratorKt.iterator((Object[])metaInf.getChildren());
            while (iterator2.hasNext()) {
                VirtualFile moduleFile = (VirtualFile)iterator2.next();
                String string = moduleFile.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (!StringsKt.endsWith$default((String)string, (String)"kotlin_module", (boolean)false, (int)2, null)) continue;
                Function0 function0 = () -> JvmPackagePartProvider.addRoots$lambda$0(moduleFile);
                String string2 = moduleFile.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                String string3 = moduleFile.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
                ModuleMapping moduleMapping = JvmPackagePartProviderKt.tryLoadModuleMapping((Function0<byte[]>)function0, string2, string3, this.getDeserializationConfiguration(), messageCollector);
                if (moduleMapping == null) continue;
                ModuleMapping it = moduleMapping;
                boolean bl2 = false;
                List<JvmPackagePartProviderBase.ModuleMappingInfo<VirtualFile>> list = this.getLoadedModules();
                String string4 = moduleFile.getNameWithoutExtension();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getNameWithoutExtension(...)");
                list.add(new JvmPackagePartProviderBase.ModuleMappingInfo<VirtualFile>(root, it, string4));
            }
        }
    }

    private static final byte[] addRoots$lambda$0(VirtualFile $moduleFile) {
        byte[] byArray = $moduleFile.contentsToByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"contentsToByteArray(...)");
        return byArray;
    }
}

