/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.backend.jvm.lower;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.backend.common.lower.DefaultArgumentStubGenerator;
import ksp.org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import ksp.org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import ksp.org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import ksp.org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import ksp.org.jetbrains.kotlin.backend.jvm.JvmLoweredStatementOrigin;
import ksp.org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import ksp.org.jetbrains.kotlin.backend.jvm.lower.JvmDefaultArgumentFunctionFactory;
import ksp.org.jetbrains.kotlin.backend.jvm.lower.JvmLocalDeclarationsLowering;
import ksp.org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import ksp.org.jetbrains.kotlin.ir.IrElement;
import ksp.org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import ksp.org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import ksp.org.jetbrains.kotlin.ir.builders.IrBuilder;
import ksp.org.jetbrains.kotlin.ir.declarations.IrClass;
import ksp.org.jetbrains.kotlin.ir.declarations.IrConstructor;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFunction;
import ksp.org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import ksp.org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import ksp.org.jetbrains.kotlin.ir.expressions.IrExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrStatementOriginImpl;
import ksp.org.jetbrains.kotlin.ir.types.IrType;
import ksp.org.jetbrains.kotlin.ir.util.IrUtilsKt;

@PhaseDescription(name="DefaultArgumentsStubGenerator", prerequisite={JvmLocalDeclarationsLowering.class})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0014J\u001c\u0010\f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tH\u0014J\b\u0010\u0011\u001a\u00020\u0012H\u0014\u00a8\u0006\u0013"}, d2={"Lksp/org/jetbrains/kotlin/backend/jvm/lower/JvmDefaultArgumentStubGenerator;", "Lksp/org/jetbrains/kotlin/backend/common/lower/DefaultArgumentStubGenerator;", "Lksp/org/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "context", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "defaultArgumentStubVisibility", "Lksp/org/jetbrains/kotlin/descriptors/DescriptorVisibility;", "function", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFunction;", "useConstructorMarker", "", "generateSuperCallHandlerCheckIfNeeded", "", "Lksp/org/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder;", "irFunction", "newIrFunction", "getOriginForCallToImplementation", "Lksp/org/jetbrains/kotlin/ir/expressions/IrStatementOriginImpl;", "backend.jvm.lower"})
public final class JvmDefaultArgumentStubGenerator
extends DefaultArgumentStubGenerator<JvmBackendContext> {
    public JvmDefaultArgumentStubGenerator(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2, new JvmDefaultArgumentFunctionFactory(context2), false, false, false, 16, null);
    }

    @Override
    @NotNull
    protected DescriptorVisibility defaultArgumentStubVisibility(@NotNull IrFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return JvmIrUtilsKt.getJvmVisibilityOfDefaultArgumentStub(function2);
    }

    @Override
    protected boolean useConstructorMarker(@NotNull IrFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return function2 instanceof IrConstructor || Intrinsics.areEqual((Object)function2.getOrigin(), (Object)JvmLoweredDeclarationOrigin.INSTANCE.getSTATIC_INLINE_CLASS_CONSTRUCTOR()) || Intrinsics.areEqual((Object)function2.getOrigin(), (Object)JvmLoweredDeclarationOrigin.INSTANCE.getSTATIC_MULTI_FIELD_VALUE_CLASS_CONSTRUCTOR());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void generateSuperCallHandlerCheckIfNeeded(@NotNull IrBlockBodyBuilder $this$generateSuperCallHandlerCheckIfNeeded, @NotNull IrFunction irFunction, @NotNull IrFunction newIrFunction) {
        void $this$generateSuperCallHandlerCheckIfNeeded_u24lambda_u240;
        IrElement irElement;
        block4: {
            block3: {
                Intrinsics.checkNotNullParameter((Object)$this$generateSuperCallHandlerCheckIfNeeded, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
                Intrinsics.checkNotNullParameter((Object)newIrFunction, (String)"newIrFunction");
                if (!(irFunction instanceof IrSimpleFunction) || !((JvmBackendContext)this.getContext()).getShouldGenerateHandlerParameterForDefaultBodyFun() || IrUtilsKt.isTopLevelDeclaration(irFunction)) break block3;
                irElement = ((IrSimpleFunction)irFunction).getParent();
                IrClass irClass = irElement instanceof IrClass ? (IrClass)irElement : null;
                boolean bl2 = irClass != null ? IrUtilsKt.isFinalClass(irClass) : false;
                if (!bl2) break block4;
            }
            return;
        }
        IrValueParameter handlerDeclaration = (IrValueParameter)CollectionsKt.last(newIrFunction.getValueParameters());
        IrElement irElement2 = irElement = ExpressionHelpersKt.irCall((IrBuilder)$this$generateSuperCallHandlerCheckIfNeeded, ((JvmBackendContext)this.getContext()).getSymbols().getThrowUnsupportedOperationException());
        IrExpression irExpression = LowerUtilsKt.irNot($this$generateSuperCallHandlerCheckIfNeeded, ExpressionHelpersKt.irEqualsNull($this$generateSuperCallHandlerCheckIfNeeded, ExpressionHelpersKt.irGet($this$generateSuperCallHandlerCheckIfNeeded, handlerDeclaration)));
        IrType irType = $this$generateSuperCallHandlerCheckIfNeeded.getContext().getIrBuiltIns().getUnitType();
        IrBuilder irBuilder = $this$generateSuperCallHandlerCheckIfNeeded;
        IrBlockBodyBuilder irBlockBodyBuilder = $this$generateSuperCallHandlerCheckIfNeeded;
        boolean bl3 = false;
        $this$generateSuperCallHandlerCheckIfNeeded_u24lambda_u240.putValueArgument(0, ExpressionHelpersKt.irString($this$generateSuperCallHandlerCheckIfNeeded, "Super calls with default arguments not supported in this target, function: " + irFunction.getName().asString()));
        Unit unit = Unit.INSTANCE;
        irBlockBodyBuilder.unaryPlus(ExpressionHelpersKt.irIfThen$default(irBuilder, irType, irExpression, (IrExpression)irElement, null, 8, null));
    }

    @Override
    @NotNull
    protected IrStatementOriginImpl getOriginForCallToImplementation() {
        return JvmLoweredStatementOrigin.INSTANCE.getDEFAULT_STUB_CALL_TO_IMPLEMENTATION();
    }
}

