/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.jvm.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.builtins.StandardNames;
import ksp.org.jetbrains.kotlin.descriptors.Modality;
import ksp.org.jetbrains.kotlin.descriptors.Visibilities;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import ksp.org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import ksp.org.jetbrains.kotlin.fir.java.JavaUtilsKt;
import ksp.org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.name.Name;
import ksp.org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ\u0014\u0010\u000e\u001a\u00020\u000f*\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\f\u0010\u0012\u001a\u00020\u000f*\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmNameChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "check", "", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)V", "isRenamableFunction", "", "function", "Lksp/org/jetbrains/kotlin/fir/declarations/FirFunction;", "isValueClassThatRequiresMangling", "Lksp/org/jetbrains/kotlin/fir/declarations/FirRegularClass;", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirJvmNameChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJvmNameChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmNameChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,71:1\n37#2:72\n11#2:73\n31#2:74\n49#2:75\n*S KotlinDebug\n*F\n+ 1 FirJvmNameChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmNameChecker\n*L\n52#1:72\n53#1:73\n53#1:74\n68#1:75\n*E\n"})
public final class FirJvmNameChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirJvmNameChecker INSTANCE = new FirJvmNameChecker();

    private FirJvmNameChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirDeclaration declaration2) {
        block9: {
            FirAnnotation jvmName;
            block10: {
                FirRegularClass containingClass;
                block11: {
                    block8: {
                        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
                        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                        FirAnnotation firAnnotation = JavaUtilsKt.findJvmNameAnnotation(declaration2);
                        if (firAnnotation == null) {
                            return;
                        }
                        jvmName = firAnnotation;
                        FirExpression firExpression = FirAnnotationUtilsKt.findArgumentByName$default(jvmName, StandardNames.NAME, false, 2, null);
                        if (firExpression == null) {
                            return;
                        }
                        FirExpression name2 = firExpression;
                        if (!Intrinsics.areEqual((Object)FirTypeUtilsKt.getResolvedType(name2), (Object)context2.getSession().getBuiltinTypes().getStringType().getConeType())) {
                            return;
                        }
                        FirLiteralExpression firLiteralExpression = name2 instanceof FirLiteralExpression ? (FirLiteralExpression)name2 : null;
                        Object object = firLiteralExpression != null ? firLiteralExpression.getValue() : null;
                        String string = object instanceof String ? (String)object : null;
                        if (string == null) {
                            return;
                        }
                        String value2 = string;
                        if (!Name.isValidIdentifier(value2)) {
                            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)jvmName.getSource(), FirJvmErrors.INSTANCE.getILLEGAL_JVM_NAME(), null, 8, null);
                        }
                        if (!(declaration2 instanceof FirFunction) || this.isRenamableFunction(context2, (FirFunction)declaration2)) break block8;
                        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)jvmName.getSource(), FirJvmErrors.INSTANCE.getINAPPLICABLE_JVM_NAME(), null, 8, null);
                        break block9;
                    }
                    if (!(declaration2 instanceof FirCallableDeclaration)) break block9;
                    containingClass = ResolveUtilsKt.getContainingClass((FirCallableDeclaration)declaration2);
                    FirMemberDeclaration $this$isOverride$iv = (FirMemberDeclaration)declaration2;
                    boolean $i$f$isOverride = false;
                    if ($this$isOverride$iv.getStatus().isOverride()) break block10;
                    if (containingClass == null) break block11;
                    FirMemberDeclaration $this$modality$iv = containingClass;
                    boolean $i$f$getModality = false;
                    if ($this$modality$iv.getStatus().getModality() == Modality.FINAL) break block11;
                    FirMemberDeclaration $this$isOverridable$iv = (FirMemberDeclaration)declaration2;
                    boolean $i$f$isOverridable = false;
                    if ($this$isOverridable$iv.getStatus().getModality() != Modality.FINAL && !Intrinsics.areEqual((Object)$this$isOverridable$iv.getStatus().getVisibility(), (Object)Visibilities.Private.INSTANCE)) break block10;
                }
                FirRegularClass firRegularClass = containingClass;
                boolean bl2 = firRegularClass != null ? this.isValueClassThatRequiresMangling(firRegularClass) : false;
                if (!bl2) break block9;
            }
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)jvmName.getSource(), FirJvmErrors.INSTANCE.getINAPPLICABLE_JVM_NAME(), null, 8, null);
        }
    }

    private final boolean isRenamableFunction(CheckerContext $this$isRenamableFunction, FirFunction function2) {
        FirClassLikeSymbol<?> containingClass = FirHelpersKt.getContainingClassSymbol(function2);
        return containingClass != null || !function2.getSymbol().getCallableId().isLocal();
    }

    private final boolean isValueClassThatRequiresMangling(FirRegularClass $this$isValueClassThatRequiresMangling) {
        FirClass $this$isInlineOrValue$iv = $this$isValueClassThatRequiresMangling;
        boolean $i$f$isInlineOrValue = false;
        return ($this$isInlineOrValue$iv.getStatus().isInline() || $this$isInlineOrValue$iv.getStatus().isValue()) && !Intrinsics.areEqual((Object)$this$isValueClassThatRequiresMangling.getName(), (Object)StandardClassIds.INSTANCE.getResult().getShortClassName());
    }
}

