/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.types.expressions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.google.common.collect.Lists;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.builtins.FunctionTypesKt;
import ksp.org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.config.LanguageVersionSettings;
import ksp.org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.SourceElement;
import ksp.org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.annotations.Annotations;
import ksp.org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.diagnostics.PsiDiagnosticUtils;
import ksp.org.jetbrains.kotlin.extensions.internal.TypeResolutionInterceptor;
import ksp.org.jetbrains.kotlin.psi.KtAnnotationEntry;
import ksp.org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import ksp.org.jetbrains.kotlin.psi.KtBlockExpression;
import ksp.org.jetbrains.kotlin.psi.KtDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import ksp.org.jetbrains.kotlin.psi.KtElement;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.psi.KtFunction;
import ksp.org.jetbrains.kotlin.psi.KtFunctionLiteral;
import ksp.org.jetbrains.kotlin.psi.KtLambdaExpression;
import ksp.org.jetbrains.kotlin.psi.KtNamedDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtNamedFunction;
import ksp.org.jetbrains.kotlin.psi.KtParameter;
import ksp.org.jetbrains.kotlin.psi.KtParameterList;
import ksp.org.jetbrains.kotlin.psi.KtPropertyAccessor;
import ksp.org.jetbrains.kotlin.psi.KtReturnExpression;
import ksp.org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import ksp.org.jetbrains.kotlin.psi.KtTreeVisitor;
import ksp.org.jetbrains.kotlin.psi.KtVisitor;
import ksp.org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import ksp.org.jetbrains.kotlin.psi.psiUtil.ReservedCheckingKt;
import ksp.org.jetbrains.kotlin.psi.stubs.KotlinPlaceHolderStub;
import ksp.org.jetbrains.kotlin.resolve.AnnotationResolver;
import ksp.org.jetbrains.kotlin.resolve.BindingContext;
import ksp.org.jetbrains.kotlin.resolve.BindingContextUtils;
import ksp.org.jetbrains.kotlin.resolve.BindingTrace;
import ksp.org.jetbrains.kotlin.resolve.DeclarationsCheckerBuilder;
import ksp.org.jetbrains.kotlin.resolve.FunctionDescriptorResolver;
import ksp.org.jetbrains.kotlin.resolve.FunctionDescriptorUtil;
import ksp.org.jetbrains.kotlin.resolve.IdentifierChecker;
import ksp.org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import ksp.org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import ksp.org.jetbrains.kotlin.resolve.calls.inference.BuilderInferenceSession;
import ksp.org.jetbrains.kotlin.resolve.calls.inference.model.TypeVariableTypeConstructor;
import ksp.org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import ksp.org.jetbrains.kotlin.resolve.calls.tower.KotlinResolutionCallbacksImpl;
import ksp.org.jetbrains.kotlin.resolve.checkers.TrailingCommaChecker;
import ksp.org.jetbrains.kotlin.resolve.checkers.UnderscoreChecker;
import ksp.org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import ksp.org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import ksp.org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import ksp.org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import ksp.org.jetbrains.kotlin.types.CommonSupertypes;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import ksp.org.jetbrains.kotlin.types.SimpleType;
import ksp.org.jetbrains.kotlin.types.TypeUtils;
import ksp.org.jetbrains.kotlin.types.UnwrappedType;
import ksp.org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import ksp.org.jetbrains.kotlin.types.expressions.CoercionStrategy;
import ksp.org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import ksp.org.jetbrains.kotlin.types.expressions.ExpressionTypingInternals;
import ksp.org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import ksp.org.jetbrains.kotlin.types.expressions.ExpressionTypingVisitor;
import ksp.org.jetbrains.kotlin.types.expressions.FunctionsTypingVisitorKt;
import ksp.org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import ksp.org.jetbrains.kotlin.types.expressions.ValueParameterResolver;
import ksp.org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;
import ksp.org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u000bH\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u000bH\u0002J\f\u0010\u0016\u001a\u00020\u000e*\u00020\u0017H\u0002J\f\u0010\u0018\u001a\u00020\u000e*\u00020\u0017H\u0002J(\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000eH\u0002J,\u0010\u001d\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0017H\u0002J$\u0010\u001f\u001a\u0004\u0018\u00010\u00172\u0006\u0010 \u001a\u00020!2\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\"\u001a\u0004\u0018\u00010\u0017H\u0002J\u001e\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010 \u001a\u00020!2\u0006\u0010&\u001a\u00020'H\u0002J\u001e\u0010(\u001a\u00020)2\u0006\u0010\b\u001a\u00020*2\u0006\u0010&\u001a\u00020'2\u0006\u0010+\u001a\u00020\u0017J\u001e\u0010#\u001a\b\u0012\u0004\u0012\u00020%0,2\u0006\u0010\b\u001a\u00020*2\u0006\u0010&\u001a\u00020'H\u0002\u00a8\u0006-"}, d2={"Lksp/org/jetbrains/kotlin/types/expressions/FunctionsTypingVisitor;", "Lksp/org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitor;", "facade", "Lksp/org/jetbrains/kotlin/types/expressions/ExpressionTypingInternals;", "<init>", "(Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingInternals;)V", "visitNamedFunction", "Lksp/org/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "function", "Lksp/org/jetbrains/kotlin/psi/KtNamedFunction;", "data", "Lksp/org/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "context", "isDeclaration", "", "statementScope", "Lksp/org/jetbrains/kotlin/resolve/scopes/LexicalWritableScope;", "visitLambdaExpression", "expression", "Lksp/org/jetbrains/kotlin/psi/KtLambdaExpression;", "createFunctionLiteralDescriptor", "Lksp/org/jetbrains/kotlin/descriptors/impl/AnonymousFunctionDescriptor;", "isBuiltinFunctionalType", "Lksp/org/jetbrains/kotlin/types/KotlinType;", "isSuspendFunctionType", "computeReturnType", "functionDescriptor", "Lksp/org/jetbrains/kotlin/descriptors/impl/SimpleFunctionDescriptorImpl;", "functionTypeExpected", "computeUnsafeReturnType", "expectedReturnType", "computeReturnTypeBasedOnReturnExpressions", "functionLiteral", "Lksp/org/jetbrains/kotlin/psi/KtFunctionLiteral;", "typeOfBodyExpression", "collectReturns", "", "Lksp/org/jetbrains/kotlin/psi/KtReturnExpression;", "trace", "Lksp/org/jetbrains/kotlin/resolve/BindingTrace;", "checkTypesForReturnStatements", "", "Lksp/org/jetbrains/kotlin/psi/KtDeclarationWithBody;", "actualReturnType", "", "frontend"})
@SourceDebugExtension(value={"SMAP\nFunctionsTypingVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FunctionsTypingVisitor.kt\norg/jetbrains/kotlin/types/expressions/FunctionsTypingVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,404:1\n1869#2,2:405\n1761#2,3:407\n774#2:410\n865#2:411\n866#2:413\n1#3:412\n*S KotlinDebug\n*F\n+ 1 FunctionsTypingVisitor.kt\norg/jetbrains/kotlin/types/expressions/FunctionsTypingVisitor\n*L\n163#1:405,2\n314#1:407,3\n330#1:410\n330#1:411\n330#1:413\n*E\n"})
public final class FunctionsTypingVisitor
extends ExpressionTypingVisitor {
    public FunctionsTypingVisitor(@NotNull ExpressionTypingInternals facade) {
        Intrinsics.checkNotNullParameter((Object)facade, (String)"facade");
        super(facade);
    }

    @Override
    @NotNull
    public KotlinTypeInfo visitNamedFunction(@NotNull KtNamedFunction function2, @NotNull ExpressionTypingContext data) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return this.visitNamedFunction(function2, data, false, null);
    }

    @NotNull
    public final KotlinTypeInfo visitNamedFunction(@NotNull KtNamedFunction function2, @NotNull ExpressionTypingContext context2, boolean isDeclaration, @Nullable LexicalWritableScope statementScope) {
        KotlinTypeInfo kotlinTypeInfo;
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!isDeclaration) {
            if (!function2.getTypeParameters().isEmpty()) {
                context2.trace.report(Errors.TYPE_PARAMETERS_NOT_ALLOWED.on((KtDeclaration)((PsiElement)function2)));
            }
            if (function2.getName() != null) {
                BindingTrace bindingTrace = context2.trace;
                PsiElement psiElement = function2.getNameIdentifier();
                Intrinsics.checkNotNull((Object)psiElement);
                bindingTrace.report(Errors.ANONYMOUS_FUNCTION_WITH_NAME.on(psiElement));
            }
            for (KtParameter parameter2 : function2.getValueParameters()) {
                if (parameter2.hasDefaultValue()) {
                    context2.trace.report(Errors.ANONYMOUS_FUNCTION_PARAMETER_WITH_DEFAULT_VALUE.on((KtParameter)((PsiElement)parameter2)));
                }
                if (!parameter2.isVarArg()) continue;
                context2.trace.report(Errors.USELESS_VARARG_ON_PARAMETER.on((KtParameter)((PsiElement)parameter2)));
            }
        }
        SimpleFunctionDescriptor functionDescriptor = null;
        if (isDeclaration) {
            boolean parameter2;
            FunctionDescriptorResolver functionDescriptorResolver = this.components.functionDescriptorResolver;
            DeclarationDescriptor declarationDescriptor = context2.scope.getOwnerDescriptor();
            LexicalScope lexicalScope = context2.scope;
            Intrinsics.checkNotNullExpressionValue((Object)lexicalScope, (String)"scope");
            BindingTrace bindingTrace = context2.trace;
            Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"trace");
            DataFlowInfo dataFlowInfo = context2.dataFlowInfo;
            Intrinsics.checkNotNullExpressionValue((Object)dataFlowInfo, (String)"dataFlowInfo");
            functionDescriptor = functionDescriptorResolver.resolveFunctionDescriptor(declarationDescriptor, lexicalScope, function2, bindingTrace, dataFlowInfo, context2.inferenceSession);
            boolean bl2 = parameter2 = statementScope != null;
            if (_Assertions.ENABLED && !parameter2) {
                boolean $i$a$-assert-FunctionsTypingVisitor$visitNamedFunction$22 = false;
                String $i$a$-assert-FunctionsTypingVisitor$visitNamedFunction$22 = "statementScope must be not null for function: " + function2.getName() + " at location " + PsiDiagnosticUtils.atLocation(function2);
                throw new AssertionError((Object)$i$a$-assert-FunctionsTypingVisitor$visitNamedFunction$22);
            }
            LexicalWritableScope lexicalWritableScope = statementScope;
            Intrinsics.checkNotNull((Object)lexicalWritableScope);
            lexicalWritableScope.addFunctionDescriptor(functionDescriptor);
        } else {
            FunctionDescriptorResolver functionDescriptorResolver = this.components.functionDescriptorResolver;
            DeclarationDescriptor declarationDescriptor = context2.scope.getOwnerDescriptor();
            LexicalScope lexicalScope = context2.scope;
            Intrinsics.checkNotNullExpressionValue((Object)lexicalScope, (String)"scope");
            BindingTrace bindingTrace = context2.trace;
            Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"trace");
            DataFlowInfo dataFlowInfo = context2.dataFlowInfo;
            Intrinsics.checkNotNullExpressionValue((Object)dataFlowInfo, (String)"dataFlowInfo");
            KotlinType kotlinType = context2.expectedType;
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"expectedType");
            functionDescriptor = functionDescriptorResolver.resolveFunctionExpressionDescriptor(declarationDescriptor, lexicalScope, function2, bindingTrace, dataFlowInfo, kotlinType, context2.inferenceSession);
        }
        ForceResolveUtil.forceResolveAllContents(functionDescriptor.getAnnotations());
        LexicalScope lexicalScope = FunctionDescriptorUtil.getFunctionInnerScope(context2.scope, functionDescriptor, context2.trace, this.components.overloadChecker);
        Intrinsics.checkNotNullExpressionValue((Object)lexicalScope, (String)"getFunctionInnerScope(...)");
        LexicalScope functionInnerScope = lexicalScope;
        if (!function2.hasDeclaredReturnType() && !function2.hasBlockBody()) {
            ForceResolveUtil.forceResolveAllContents(functionDescriptor.getReturnType());
        } else {
            this.components.expressionTypingServices.checkFunctionReturnType(functionInnerScope, function2, functionDescriptor, context2.dataFlowInfo, null, context2.trace, context2);
        }
        ValueParameterResolver valueParameterResolver = this.components.valueParameterResolver;
        List<KtParameter> list = function2.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getValueParameters(...)");
        List<ValueParameterDescriptor> list2 = functionDescriptor.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getValueParameters(...)");
        DataFlowInfo dataFlowInfo = context2.dataFlowInfo;
        Intrinsics.checkNotNullExpressionValue((Object)dataFlowInfo, (String)"dataFlowInfo");
        BindingTrace bindingTrace = context2.trace;
        Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"trace");
        valueParameterResolver.resolveValueParameters(list, list2, functionInnerScope, dataFlowInfo, bindingTrace, context2.inferenceSession);
        this.components.modifiersChecker.withTrace(context2.trace).checkModifiersForLocalDeclaration(function2, functionDescriptor);
        IdentifierChecker identifierChecker = this.components.identifierChecker;
        KtDeclaration ktDeclaration = function2;
        BindingTrace bindingTrace2 = context2.trace;
        Intrinsics.checkNotNullExpressionValue((Object)bindingTrace2, (String)"trace");
        identifierChecker.checkDeclaration(ktDeclaration, bindingTrace2);
        DeclarationsCheckerBuilder declarationsCheckerBuilder = this.components.declarationsCheckerBuilder;
        BindingTrace bindingTrace3 = context2.trace;
        Intrinsics.checkNotNullExpressionValue((Object)bindingTrace3, (String)"trace");
        declarationsCheckerBuilder.withTrace(bindingTrace3).checkFunction(function2, functionDescriptor);
        if (isDeclaration) {
            kotlinTypeInfo = TypeInfoFactoryKt.createTypeInfo(this.components.dataFlowAnalyzer.checkStatementType(function2, context2), context2);
        } else {
            boolean newInferenceEnabled = this.components.languageVersionSettings.supportsFeature(LanguageFeature.NewInference);
            KotlinBuiltIns kotlinBuiltIns = this.components.builtIns;
            Intrinsics.checkNotNullExpressionValue((Object)kotlinBuiltIns, (String)"builtIns");
            KotlinType resultType = FunctionsTypingVisitorKt.createFunctionType$default(functionDescriptor, kotlinBuiltIns, false, false, 4, null);
            if (newInferenceEnabled) {
                KotlinType kotlinType = context2.expectedType;
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"expectedType");
                if (!TypeUtilsKt.contains(kotlinType, (Function1<? super UnwrappedType, Boolean>)((Function1)FunctionsTypingVisitor::visitNamedFunction$lambda$1))) {
                    KotlinBuiltIns kotlinBuiltIns2 = this.components.builtIns;
                    Intrinsics.checkNotNullExpressionValue((Object)kotlinBuiltIns2, (String)"builtIns");
                    KotlinType typeToTypeCheck = FunctionsTypingVisitorKt.createFunctionType(functionDescriptor, kotlinBuiltIns2, false, true);
                    this.components.dataFlowAnalyzer.checkType(typeToTypeCheck, (KtExpression)function2, (ResolutionContext)context2);
                }
                kotlinTypeInfo = TypeInfoFactoryKt.createTypeInfo(resultType, context2);
            } else {
                KotlinTypeInfo kotlinTypeInfo2 = this.components.dataFlowAnalyzer.createCheckedTypeInfo(resultType, context2, function2);
                Intrinsics.checkNotNull((Object)kotlinTypeInfo2);
                kotlinTypeInfo = kotlinTypeInfo2;
            }
        }
        return kotlinTypeInfo;
    }

    @Override
    @Nullable
    public KotlinTypeInfo visitLambdaExpression(@NotNull KtLambdaExpression expression2, @NotNull ExpressionTypingContext context2) {
        KtParameterList valueParameterList;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!this.components.languageVersionSettings.supportsFeature(LanguageFeature.YieldIsNoMoreReserved)) {
            PsiElement psiElement = expression2;
            BindingTrace bindingTrace = context2.trace;
            Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"trace");
            ReservedCheckingKt.checkReservedYieldBeforeLambda(psiElement, bindingTrace);
        }
        if (!expression2.getFunctionLiteral().hasBody()) {
            return null;
        }
        KotlinType kotlinType = context2.expectedType;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"expectedType");
        KotlinType expectedType = kotlinType;
        boolean functionTypeExpected = this.isBuiltinFunctionalType(expectedType);
        boolean suspendFunctionTypeExpected = this.isSuspendFunctionType(expectedType);
        AnonymousFunctionDescriptor functionDescriptor = this.createFunctionLiteralDescriptor(expression2, context2);
        List<KtParameter> list = expression2.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getValueParameters(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtParameter it = (KtParameter)element$iv;
            boolean bl2 = false;
            IdentifierChecker identifierChecker = this.components.identifierChecker;
            Intrinsics.checkNotNull((Object)it);
            KtDeclaration ktDeclaration = it;
            BindingTrace bindingTrace = context2.trace;
            Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"trace");
            identifierChecker.checkDeclaration(ktDeclaration, bindingTrace);
            KtNamedDeclaration ktNamedDeclaration = it;
            BindingTrace bindingTrace2 = context2.trace;
            Intrinsics.checkNotNullExpressionValue((Object)bindingTrace2, (String)"trace");
            DiagnosticSink diagnosticSink = bindingTrace2;
            LanguageVersionSettings languageVersionSettings = this.components.languageVersionSettings;
            Intrinsics.checkNotNullExpressionValue((Object)languageVersionSettings, (String)"languageVersionSettings");
            UnderscoreChecker.INSTANCE.checkNamed(ktNamedDeclaration, diagnosticSink, languageVersionSettings, true);
        }
        KtParameterList ktParameterList = valueParameterList = expression2.getFunctionLiteral().getValueParameterList();
        if ((ktParameterList != null ? (KotlinPlaceHolderStub)ktParameterList.getStub() : null) == null) {
            KtParameterList ktParameterList2 = valueParameterList;
            PsiElement psiElement = ktParameterList2 != null ? ktParameterList2.getTrailingComma() : null;
            BindingTrace bindingTrace = context2.trace;
            Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"trace");
            LanguageVersionSettings languageVersionSettings = context2.languageVersionSettings;
            Intrinsics.checkNotNullExpressionValue((Object)languageVersionSettings, (String)"languageVersionSettings");
            TrailingCommaChecker.INSTANCE.check(psiElement, bindingTrace, languageVersionSettings);
        }
        KotlinType safeReturnType = this.computeReturnType(expression2, context2, functionDescriptor, functionTypeExpected);
        functionDescriptor.setReturnType(safeReturnType);
        TypeResolutionInterceptor typeResolutionInterceptor = this.components.typeResolutionInterceptor;
        KtElement ktElement = expression2;
        SimpleFunctionDescriptor simpleFunctionDescriptor = functionDescriptor;
        KotlinBuiltIns kotlinBuiltIns = this.components.builtIns;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinBuiltIns, (String)"builtIns");
        KotlinType kotlinType2 = FunctionsTypingVisitorKt.createFunctionType$default(simpleFunctionDescriptor, kotlinBuiltIns, suspendFunctionTypeExpected, false, 4, null);
        Intrinsics.checkNotNull((Object)kotlinType2);
        KotlinType resultType = typeResolutionInterceptor.interceptType(ktElement, context2, kotlinType2);
        if (context2.inferenceSession instanceof BuilderInferenceSession) {
            ((BuilderInferenceSession)context2.inferenceSession).addExpression(expression2);
        }
        if (functionTypeExpected) {
            return TypeInfoFactoryKt.createTypeInfo(resultType, context2);
        }
        return this.components.dataFlowAnalyzer.createCheckedTypeInfo(resultType, context2, expression2);
    }

    private final AnonymousFunctionDescriptor createFunctionLiteralDescriptor(KtLambdaExpression expression2, ExpressionTypingContext context2) {
        KtFunctionLiteral ktFunctionLiteral = expression2.getFunctionLiteral();
        Intrinsics.checkNotNullExpressionValue((Object)ktFunctionLiteral, (String)"getFunctionLiteral(...)");
        KtFunctionLiteral functionLiteral = ktFunctionLiteral;
        DeclarationDescriptor declarationDescriptor = context2.scope.getOwnerDescriptor();
        AnnotationResolver annotationResolver = this.components.annotationResolver;
        LexicalScope lexicalScope = context2.scope;
        Intrinsics.checkNotNullExpressionValue((Object)lexicalScope, (String)"scope");
        List<KtAnnotationEntry> list = KtPsiUtilKt.getAnnotationEntries(expression2);
        BindingTrace bindingTrace = context2.trace;
        Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"trace");
        Annotations annotations2 = annotationResolver.resolveAnnotationsWithArguments(lexicalScope, list, bindingTrace);
        SourceElement sourceElement = KotlinSourceElementKt.toSourceElement(functionLiteral);
        KotlinType kotlinType = context2.expectedType;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"expectedType");
        AnonymousFunctionDescriptor it = new AnonymousFunctionDescriptor(declarationDescriptor, annotations2, CallableMemberDescriptor.Kind.DECLARATION, sourceElement, this.isSuspendFunctionType(kotlinType));
        boolean bl2 = false;
        AnonymousFunctionDescriptor functionDescriptor = this.facade.getComponents().typeResolutionInterceptor.interceptFunctionLiteralDescriptor(expression2, context2, it);
        FunctionDescriptorResolver functionDescriptorResolver = this.components.functionDescriptorResolver;
        DeclarationDescriptor declarationDescriptor2 = context2.scope.getOwnerDescriptor();
        LexicalScope lexicalScope2 = context2.scope;
        Intrinsics.checkNotNullExpressionValue((Object)lexicalScope2, (String)"scope");
        KtFunction ktFunction = functionLiteral;
        SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl = functionDescriptor;
        BindingTrace bindingTrace2 = context2.trace;
        Intrinsics.checkNotNullExpressionValue((Object)bindingTrace2, (String)"trace");
        KotlinType kotlinType2 = context2.expectedType;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"expectedType");
        DataFlowInfo dataFlowInfo = context2.dataFlowInfo;
        Intrinsics.checkNotNullExpressionValue((Object)dataFlowInfo, (String)"dataFlowInfo");
        functionDescriptorResolver.initializeFunctionDescriptorAndExplicitReturnType(declarationDescriptor2, lexicalScope2, ktFunction, simpleFunctionDescriptorImpl, bindingTrace2, kotlinType2, dataFlowInfo, context2.inferenceSession);
        for (ValueParameterDescriptor parameterDescriptor : functionDescriptor.getValueParameters()) {
            ForceResolveUtil.forceResolveAllContents(parameterDescriptor.getAnnotations());
        }
        BindingContextUtils.recordFunctionDeclarationToDescriptor(context2.trace, functionLiteral, functionDescriptor);
        return functionDescriptor;
    }

    private final boolean isBuiltinFunctionalType(KotlinType $this$isBuiltinFunctionalType) {
        return !TypeUtils.noExpectedType($this$isBuiltinFunctionalType) && FunctionTypesKt.isBuiltinFunctionalType($this$isBuiltinFunctionalType);
    }

    private final boolean isSuspendFunctionType(KotlinType $this$isSuspendFunctionType) {
        return !TypeUtils.noExpectedType($this$isSuspendFunctionType) && FunctionTypesKt.isSuspendFunctionType($this$isSuspendFunctionType);
    }

    private final KotlinType computeReturnType(KtLambdaExpression expression2, ExpressionTypingContext context2, SimpleFunctionDescriptorImpl functionDescriptor, boolean functionTypeExpected) {
        KotlinType kotlinType;
        KotlinType kotlinType2;
        if (functionTypeExpected) {
            KotlinType kotlinType3 = context2.expectedType;
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType3, (String)"expectedType");
            kotlinType2 = FunctionTypesKt.getReturnTypeFromFunctionType(kotlinType3);
        } else {
            kotlinType2 = null;
        }
        KotlinType expectedReturnType = kotlinType2;
        KotlinType returnType2 = this.computeUnsafeReturnType(expression2, context2, functionDescriptor, expectedReturnType);
        if (!expression2.getFunctionLiteral().hasDeclaredReturnType() && functionTypeExpected) {
            KotlinType kotlinType4 = expectedReturnType;
            Intrinsics.checkNotNull((Object)kotlinType4);
            if (!TypeUtils.noExpectedType(kotlinType4) && KotlinBuiltIns.isUnit(expectedReturnType)) {
                SimpleType simpleType = this.components.builtIns.getUnitType();
                Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getUnitType(...)");
                return simpleType;
            }
        }
        if ((kotlinType = returnType2) == null) {
            SimpleType simpleType = TypeUtils.CANNOT_INFER_FUNCTION_PARAM_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"CANNOT_INFER_FUNCTION_PARAM_TYPE");
            kotlinType = simpleType;
        }
        return kotlinType;
    }

    private final KotlinType computeUnsafeReturnType(KtLambdaExpression expression2, ExpressionTypingContext context2, SimpleFunctionDescriptorImpl functionDescriptor, KotlinType expectedReturnType) {
        KotlinType typeOfBodyExpression;
        KtFunctionLiteral functionLiteral;
        block2: {
            KtFunctionLiteral ktFunctionLiteral = expression2.getFunctionLiteral();
            Intrinsics.checkNotNullExpressionValue((Object)ktFunctionLiteral, (String)"getFunctionLiteral(...)");
            functionLiteral = ktFunctionLiteral;
            KotlinType kotlinType = expectedReturnType;
            if (kotlinType == null) {
                SimpleType simpleType = TypeUtils.NO_EXPECTED_TYPE;
                Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"NO_EXPECTED_TYPE");
                kotlinType = simpleType;
            }
            KotlinType expectedType = kotlinType;
            LexicalScope lexicalScope = FunctionDescriptorUtil.getFunctionInnerScope(context2.scope, functionDescriptor, context2.trace, this.components.overloadChecker);
            Intrinsics.checkNotNullExpressionValue((Object)lexicalScope, (String)"getFunctionInnerScope(...)");
            LexicalScope functionInnerScope = lexicalScope;
            Object Context2 = ((ExpressionTypingContext)context2.replaceScope(functionInnerScope)).replaceExpectedType(expectedType);
            Intrinsics.checkNotNullExpressionValue(Context2, (String)"replaceExpectedType(...)");
            ExpressionTypingContext newContext = (ExpressionTypingContext)Context2;
            context2.trace.record(BindingContext.EXPECTED_RETURN_TYPE, functionLiteral, expectedType);
            KotlinResolutionCallbacksImpl.LambdaInfo newInferenceLambdaInfo = (KotlinResolutionCallbacksImpl.LambdaInfo)context2.trace.get(BindingContext.NEW_INFERENCE_LAMBDA_INFO, expression2.getFunctionLiteral());
            if (newInferenceLambdaInfo == null && context2.languageVersionSettings.supportsFeature(LanguageFeature.NewInference)) {
                Object Context3 = newContext.replaceContextDependency(ContextDependency.INDEPENDENT);
                Intrinsics.checkNotNullExpressionValue(Context3, (String)"replaceContextDependency(...)");
                newContext = (ExpressionTypingContext)Context3;
            }
            ExpressionTypingServices expressionTypingServices = this.components.expressionTypingServices;
            KtBlockExpression ktBlockExpression = functionLiteral.getBodyExpression();
            Intrinsics.checkNotNull((Object)ktBlockExpression);
            KotlinTypeInfo kotlinTypeInfo = expressionTypingServices.getBlockReturnedType(ktBlockExpression, CoercionStrategy.COERCION_TO_UNIT, newContext);
            Intrinsics.checkNotNullExpressionValue((Object)kotlinTypeInfo, (String)"getBlockReturnedType(...)");
            KotlinTypeInfo blockReturnedType = kotlinTypeInfo;
            typeOfBodyExpression = blockReturnedType.getType();
            KotlinResolutionCallbacksImpl.LambdaInfo lambdaInfo = newInferenceLambdaInfo;
            if (lambdaInfo == null) break block2;
            KotlinResolutionCallbacksImpl.LambdaInfo it = lambdaInfo;
            boolean bl2 = false;
            it.getLastExpressionInfo().setDataFlowInfoAfter(blockReturnedType.getDataFlowInfo());
        }
        return this.computeReturnTypeBasedOnReturnExpressions(functionLiteral, context2, typeOfBodyExpression);
    }

    private final KotlinType computeReturnTypeBasedOnReturnExpressions(KtFunctionLiteral functionLiteral, ExpressionTypingContext context2, KotlinType typeOfBodyExpression) {
        boolean bl2;
        ArrayList returnedExpressionTypes;
        block9: {
            KtExpression returnedExpression;
            returnedExpressionTypes = Lists.newArrayList();
            boolean hasEmptyReturn = false;
            BindingTrace bindingTrace = context2.trace;
            Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"trace");
            Collection<KtReturnExpression> returnExpressions = this.collectReturns(functionLiteral, bindingTrace);
            for (KtReturnExpression returnExpression : returnExpressions) {
                returnedExpression = returnExpression.getReturnedExpression();
                if (returnedExpression == null) {
                    hasEmptyReturn = true;
                    continue;
                }
                Intrinsics.checkNotNull(returnedExpressionTypes);
                ksp.org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull(returnedExpressionTypes, context2.trace.getType(returnedExpression));
            }
            if (hasEmptyReturn) {
                for (KtReturnExpression returnExpression : returnExpressions) {
                    KotlinType type2;
                    returnedExpression = returnExpression.getReturnedExpression();
                    if (returnedExpression == null || (type2 = context2.trace.getType(returnedExpression)) != null && KotlinBuiltIns.isUnit(type2)) continue;
                    context2.trace.report(Errors.RETURN_TYPE_MISMATCH.on((KtExpression)((PsiElement)returnedExpression), this.components.builtIns.getUnitType()));
                }
                return this.components.builtIns.getUnitType();
            }
            Intrinsics.checkNotNull(returnedExpressionTypes);
            ksp.org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull(returnedExpressionTypes, typeOfBodyExpression);
            if (returnedExpressionTypes.isEmpty()) {
                return null;
            }
            Iterable $this$any$iv = returnedExpressionTypes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl2 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KotlinType it = (KotlinType)element$iv;
                    boolean bl3 = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!TypeUtilsKt.contains(it, (Function1<? super UnwrappedType, Boolean>)((Function1)FunctionsTypingVisitor::computeReturnTypeBasedOnReturnExpressions$lambda$6$lambda$5))) continue;
                    bl2 = true;
                    break block9;
                }
                bl2 = false;
            }
        }
        if (bl2) {
            return null;
        }
        return CommonSupertypes.commonSupertype(returnedExpressionTypes);
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<KtReturnExpression> collectReturns(KtFunctionLiteral functionLiteral, BindingTrace trace) {
        void $this$filterTo$iv$iv;
        KtBlockExpression bodyExpression;
        ArrayList result2 = Lists.newArrayList();
        KtBlockExpression ktBlockExpression = bodyExpression = functionLiteral.getBodyExpression();
        if (ktBlockExpression != null) {
            Void cfr_ignored_0 = (Void)ktBlockExpression.accept((KtVisitor)new KtTreeVisitor<List<KtReturnExpression>>(){

                public Void visitReturnExpression(KtReturnExpression expression2, List<KtReturnExpression> insideActualFunction) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    Intrinsics.checkNotNullParameter(insideActualFunction, (String)"insideActualFunction");
                    insideActualFunction.add(expression2);
                    return null;
                }
            }, result2);
        }
        Intrinsics.checkNotNull(result2);
        Iterable $this$filter$iv = result2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PsiElement psiElement;
            KtReturnExpression it = (KtReturnExpression)element$iv$iv;
            boolean bl2 = false;
            if (it.getTargetLabel() != null) {
                KtSimpleNameExpression it2;
                boolean bl3 = false;
                psiElement = (PsiElement)trace.get(BindingContext.LABEL_TARGET, it2);
            } else {
                psiElement = null;
            }
            if (!Intrinsics.areEqual(psiElement, (Object)functionLiteral)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void checkTypesForReturnStatements(@NotNull KtDeclarationWithBody function2, @NotNull BindingTrace trace, @NotNull KotlinType actualReturnType) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)actualReturnType, (String)"actualReturnType");
        if (function2.hasBlockBody()) {
            return;
        }
        if (!(function2 instanceof KtNamedFunction && ((KtNamedFunction)function2).getTypeReference() == null || function2 instanceof KtPropertyAccessor && ((KtPropertyAccessor)function2).getReturnTypeReference() != null)) {
            return;
        }
        for (KtReturnExpression returnForCheck : this.collectReturns(function2, trace)) {
            KotlinType expressionType;
            KtExpression expression2 = returnForCheck.getReturnedExpression();
            if (expression2 == null) {
                if (TypeUtilsKt.isUnit(actualReturnType)) continue;
                trace.report(Errors.RETURN_TYPE_MISMATCH.on((KtExpression)((PsiElement)returnForCheck), actualReturnType));
                continue;
            }
            if (trace.getType(expression2) == null || KotlinTypeChecker.DEFAULT.isSubtypeOf(expressionType, actualReturnType)) continue;
            trace.report(Errors.TYPE_MISMATCH.on((KtExpression)((PsiElement)expression2), expressionType, actualReturnType));
        }
    }

    private final List<KtReturnExpression> collectReturns(KtDeclarationWithBody function2, BindingTrace trace) {
        KtExpression ktExpression = function2.getBodyExpression();
        if (ktExpression == null) {
            return CollectionsKt.emptyList();
        }
        KtExpression bodyExpression = ktExpression;
        ArrayList<KtReturnExpression> returns = new ArrayList<KtReturnExpression>();
        bodyExpression.accept((KtVisitor)new KtTreeVisitor<Boolean>(function2, returns, trace){
            final /* synthetic */ KtDeclarationWithBody $function;
            final /* synthetic */ ArrayList<KtReturnExpression> $returns;
            final /* synthetic */ BindingTrace $trace;
            {
                this.$function = $function;
                this.$returns = $returns;
                this.$trace = $trace;
            }

            public Void visitReturnExpression(KtReturnExpression expression2, boolean insideActualFunction) {
                PsiElement labelTarget;
                PsiElement psiElement;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                KtSimpleNameExpression ktSimpleNameExpression = expression2.getTargetLabel();
                if (ktSimpleNameExpression != null) {
                    KtSimpleNameExpression ktSimpleNameExpression2 = ktSimpleNameExpression;
                    BindingTrace bindingTrace = this.$trace;
                    KtSimpleNameExpression it = ktSimpleNameExpression2;
                    boolean bl2 = false;
                    psiElement = (PsiElement)bindingTrace.get(BindingContext.LABEL_TARGET, it);
                } else {
                    psiElement = labelTarget = null;
                }
                if (Intrinsics.areEqual(labelTarget, (Object)this.$function) || labelTarget == null && insideActualFunction) {
                    this.$returns.add(expression2);
                }
                return (Void)super.visitReturnExpression(expression2, insideActualFunction);
            }

            public Void visitNamedFunction(KtNamedFunction function2, boolean data) {
                Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
                return (Void)super.visitNamedFunction(function2, false);
            }

            public Void visitPropertyAccessor(KtPropertyAccessor accessor, boolean data) {
                Intrinsics.checkNotNullParameter((Object)accessor, (String)"accessor");
                return (Void)super.visitPropertyAccessor(accessor, false);
            }

            public Void visitAnonymousInitializer(KtAnonymousInitializer initializer, boolean data) {
                Intrinsics.checkNotNullParameter((Object)initializer, (String)"initializer");
                return (Void)super.visitAnonymousInitializer(initializer, false);
            }
        }, true);
        return returns;
    }

    private static final boolean visitNamedFunction$lambda$1(UnwrappedType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it == TypeUtils.NO_EXPECTED_TYPE;
    }

    private static final boolean computeReturnTypeBasedOnReturnExpressions$lambda$6$lambda$5(UnwrappedType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getConstructor() instanceof TypeVariableTypeConstructor;
    }
}

