/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.scopes;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptorNonRoot;
import ksp.org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.VariableDescriptor;
import ksp.org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import ksp.org.jetbrains.kotlin.name.Name;
import ksp.org.jetbrains.kotlin.resolve.OverloadChecker;
import ksp.org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import ksp.org.jetbrains.kotlin.resolve.scopes.LocalRedeclarationChecker;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rH$J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u0012H$R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lksp/org/jetbrains/kotlin/resolve/scopes/AbstractLocalRedeclarationChecker;", "Lksp/org/jetbrains/kotlin/resolve/scopes/LocalRedeclarationChecker;", "overloadChecker", "Lksp/org/jetbrains/kotlin/resolve/OverloadChecker;", "<init>", "(Lorg/jetbrains/kotlin/resolve/OverloadChecker;)V", "getOverloadChecker", "()Lorg/jetbrains/kotlin/resolve/OverloadChecker;", "checkBeforeAddingToScope", "", "scope", "Lksp/org/jetbrains/kotlin/resolve/scopes/LexicalScope;", "newDescriptor", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "handleRedeclaration", "first", "second", "handleConflictingOverloads", "Lksp/org/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "frontend"})
public abstract class AbstractLocalRedeclarationChecker
implements LocalRedeclarationChecker {
    @NotNull
    private final OverloadChecker overloadChecker;

    public AbstractLocalRedeclarationChecker(@NotNull OverloadChecker overloadChecker) {
        Intrinsics.checkNotNullParameter((Object)overloadChecker, (String)"overloadChecker");
        this.overloadChecker = overloadChecker;
    }

    @NotNull
    public final OverloadChecker getOverloadChecker() {
        return this.overloadChecker;
    }

    @Override
    public void checkBeforeAddingToScope(@NotNull LexicalScope scope, @NotNull DeclarationDescriptor newDescriptor2) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)newDescriptor2, (String)"newDescriptor");
        Name name2 = newDescriptor2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"getName(...)");
        Name name3 = name2;
        NoLookupLocation location2 = NoLookupLocation.WHEN_CHECK_DECLARATION_CONFLICTS;
        DeclarationDescriptor declarationDescriptor = newDescriptor2;
        if (declarationDescriptor instanceof ClassifierDescriptor || declarationDescriptor instanceof VariableDescriptor) {
            DeclarationDescriptorNonRoot otherDescriptor;
            ClassifierDescriptor classifierDescriptor = scope.getContributedClassifier(name3, location2);
            DeclarationDescriptorNonRoot declarationDescriptorNonRoot = otherDescriptor = classifierDescriptor != null ? (DeclarationDescriptorNonRoot)classifierDescriptor : (DeclarationDescriptorNonRoot)CollectionsKt.firstOrNull((Iterable)scope.getContributedVariables(name3, location2));
            if (otherDescriptor != null) {
                this.handleRedeclaration(otherDescriptor, newDescriptor2);
            }
        } else if (declarationDescriptor instanceof FunctionDescriptor) {
            Collection collection;
            Collection otherFunctions = scope.getContributedFunctions(name3, location2);
            ClassifierDescriptor otherClass = scope.getContributedClassifier(name3, location2);
            if (otherClass instanceof ClassDescriptor) {
                Collection<ClassConstructorDescriptor> collection2 = ((ClassDescriptor)otherClass).getConstructors();
                Intrinsics.checkNotNullExpressionValue(collection2, (String)"getConstructors(...)");
                collection = CollectionsKt.plus(otherFunctions, (Iterable)collection2);
            } else {
                collection = otherFunctions;
            }
            Collection potentiallyConflictingOverloads = collection;
            for (FunctionDescriptor overloadedDescriptor : potentiallyConflictingOverloads) {
                Intrinsics.checkNotNull((Object)overloadedDescriptor);
                if (this.overloadChecker.isOverloadable(overloadedDescriptor, newDescriptor2)) continue;
                this.handleConflictingOverloads((CallableMemberDescriptor)newDescriptor2, overloadedDescriptor);
                break;
            }
        } else {
            throw new IllegalStateException("Unexpected type of descriptor: " + newDescriptor2.getClass().getName() + ", descriptor: " + newDescriptor2);
        }
    }

    protected abstract void handleRedeclaration(@NotNull DeclarationDescriptor var1, @NotNull DeclarationDescriptor var2);

    protected abstract void handleConflictingOverloads(@NotNull CallableMemberDescriptor var1, @NotNull CallableMemberDescriptor var2);
}

