/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.descriptors.ClassKind;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.FirElement;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirConstructor;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirArrayLiteral;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirStatement;
import ksp.org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0010"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirUnsupportedArrayLiteralChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirArrayLiteral;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirArrayLiteralChecker;", "<init>", "()V", "check", "", "expression", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "isInsideAnnotationCall", "", "isInsideAnnotationConstructor", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirUnsupportedArrayLiteralChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirUnsupportedArrayLiteralChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirUnsupportedArrayLiteralChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CheckerContext.kt\norg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContextKt\n+ 4 CheckerContext.kt\norg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContextKt$findClosest$1\n*L\n1#1,46:1\n1761#2,3:47\n93#3,3:50\n98#3:54\n93#4:53\n*S KotlinDebug\n*F\n+ 1 FirUnsupportedArrayLiteralChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirUnsupportedArrayLiteralChecker\n*L\n35#1:47,3\n44#1:50,3\n44#1:54\n44#1:53\n*E\n"})
public final class FirUnsupportedArrayLiteralChecker
extends FirExpressionChecker<FirArrayLiteral> {
    @NotNull
    public static final FirUnsupportedArrayLiteralChecker INSTANCE = new FirUnsupportedArrayLiteralChecker();

    private FirUnsupportedArrayLiteralChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirArrayLiteral expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!this.isInsideAnnotationCall(context2) && !this.isInsideAnnotationConstructor(context2)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getUNSUPPORTED(), (Object)"Collection literals outside of annotations", (DiagnosticContext)context2, null, 16, null);
        }
    }

    private final boolean isInsideAnnotationCall(CheckerContext context2) {
        boolean bl2;
        block5: {
            Iterable $this$any$iv = CollectionsKt.asReversed(context2.getCallsOrAssignments());
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl2 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl3;
                    FirStatement it = (FirStatement)element$iv;
                    boolean bl4 = false;
                    FirStatement firStatement = it;
                    if (firStatement instanceof FirFunctionCall) {
                        FirRegularClassSymbol firRegularClassSymbol = ToSymbolUtilsKt.toRegularClassSymbol(FirTypeUtilsKt.getResolvedType((FirExpression)it), context2.getSession());
                        bl3 = (firRegularClassSymbol != null ? firRegularClassSymbol.getClassKind() : null) == ClassKind.ANNOTATION_CLASS;
                    } else {
                        bl3 = firStatement instanceof FirAnnotationCall;
                    }
                    if (!bl3) continue;
                    bl2 = true;
                    break block5;
                }
                bl2 = false;
            }
        }
        return bl2;
    }

    private final boolean isInsideAnnotationConstructor(CheckerContext context2) {
        Object object;
        FirElement firElement;
        block3: {
            CheckerContext $this$findClosest_u24default$iv = context2;
            boolean $i$f$findClosest = false;
            for (FirDeclaration it$iv : CollectionsKt.asReversed($this$findClosest_u24default$iv.getContainingDeclarations())) {
                FirElement firElement2;
                FirDeclaration firDeclaration = it$iv;
                if (!(firDeclaration instanceof FirConstructor)) {
                    firDeclaration = null;
                }
                if ((firElement = (FirElement)((FirConstructor)firDeclaration)) == null) continue;
                FirElement firElement3 = firElement2 = firElement;
                boolean bl2 = false;
                FirElement it = firElement3;
                firElement = true ? firElement2 : null;
                if (firElement == null) {
                    continue;
                }
                break block3;
            }
            firElement = null;
        }
        return ((object = (FirConstructor)firElement) != null && (object = ((FirConstructor)object).getReturnTypeRef()) != null && (object = FirHelpersKt.toRegularClassSymbol((FirTypeRef)object, context2.getSession())) != null ? ((FirClassSymbol)object).getClassKind() : null) == ClassKind.ANNOTATION_CLASS;
    }
}

