/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.codegen;

import kotlin.text.StringsKt;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.builtins.functions.FunctionInvokeDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassKind;
import ksp.org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import ksp.org.jetbrains.kotlin.name.Name;
import ksp.org.jetbrains.kotlin.types.KotlinType;

public class JvmCodegenUtil {
    private JvmCodegenUtil() {
    }

    public static boolean isJvmInterface(@Nullable DeclarationDescriptor descriptor2) {
        if (descriptor2 instanceof ClassDescriptor) {
            ClassKind kind = ((ClassDescriptor)descriptor2).getKind();
            return kind == ClassKind.INTERFACE || kind == ClassKind.ANNOTATION_CLASS;
        }
        return false;
    }

    public static boolean isJvmInterface(KotlinType type2) {
        return JvmCodegenUtil.isJvmInterface(type2.getConstructor().getDeclarationDescriptor());
    }

    @Nullable
    public static ClassDescriptor getDispatchReceiverParameterForConstructorCall(@NotNull ConstructorDescriptor descriptor2) {
        ClassDescriptor expectedThisClass;
        ReceiverParameterDescriptor dispatchReceiver;
        if (descriptor2 == null) {
            JvmCodegenUtil.$$$reportNull$$$0(0);
        }
        if ((dispatchReceiver = descriptor2.getDispatchReceiverParameter()) != null && !(expectedThisClass = (ClassDescriptor)dispatchReceiver.getContainingDeclaration()).getKind().isSingleton()) {
            return expectedThisClass;
        }
        return null;
    }

    @NotNull
    public static String getModuleName(ModuleDescriptor module2) {
        Name stableName = module2.getStableName();
        if (stableName == null) {
            return JvmCodegenUtil.prepareModuleName(module2.getName());
        }
        return JvmCodegenUtil.prepareModuleName(stableName);
    }

    @NotNull
    public static String prepareModuleName(@NotNull Name name2) {
        if (name2 == null) {
            JvmCodegenUtil.$$$reportNull$$$0(1);
        }
        String string2 = StringsKt.removeSurrounding((String)name2.asString(), (CharSequence)"<", (CharSequence)">");
        if (string2 == null) {
            JvmCodegenUtil.$$$reportNull$$$0(2);
        }
        return string2;
    }

    @NotNull
    public static String getMappingFileName(@NotNull String moduleName) {
        if (moduleName == null) {
            JvmCodegenUtil.$$$reportNull$$$0(3);
        }
        String string2 = "META-INF/" + moduleName + "." + "kotlin_module";
        if (string2 == null) {
            JvmCodegenUtil.$$$reportNull$$$0(4);
        }
        return string2;
    }

    public static boolean isDeclarationOfBigArityFunctionInvoke(@Nullable DeclarationDescriptor descriptor2) {
        return descriptor2 instanceof FunctionInvokeDescriptor && ((FunctionInvokeDescriptor)descriptor2).hasBigArity();
    }

    public static boolean isDeclarationOfBigArityCreateCoroutineMethod(@Nullable DeclarationDescriptor descriptor2) {
        return descriptor2 instanceof SimpleFunctionDescriptor && descriptor2.getName().asString().equals("create") && ((SimpleFunctionDescriptor)descriptor2).getValueParameters().size() >= 22 && descriptor2.getContainingDeclaration() instanceof AnonymousFunctionDescriptor && ((AnonymousFunctionDescriptor)descriptor2.getContainingDeclaration()).isSuspend();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 4: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/org/jetbrains/kotlin/codegen/JvmCodegenUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/org/jetbrains/kotlin/codegen/JvmCodegenUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareModuleName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappingFileName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDispatchReceiverParameterForConstructorCall";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "prepareModuleName";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getMappingFileName";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

