/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.backend.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.ir.expressions.IrBranch;
import ksp.org.jetbrains.kotlin.ir.expressions.IrCall;
import ksp.org.jetbrains.kotlin.ir.expressions.IrExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import ksp.org.jetbrains.kotlin.ir.expressions.IrWhen;
import ksp.org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import ksp.org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import ksp.org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import ksp.org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005j\n\u0012\u0004\u0012\u00020\u0006\u0018\u0001`\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lksp/org/jetbrains/kotlin/backend/common/IrWhenUtils;", "", "<init>", "()V", "matchConditions", "Ljava/util/ArrayList;", "Lksp/org/jetbrains/kotlin/ir/expressions/IrCall;", "Lkotlin/collections/ArrayList;", "ororSymbol", "Lksp/org/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "condition", "Lksp/org/jetbrains/kotlin/ir/expressions/IrExpression;", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nIrWhenUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrWhenUtils.kt\norg/jetbrains/kotlin/backend/common/IrWhenUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,77:1\n1#2:78\n*E\n"})
public final class IrWhenUtils {
    @NotNull
    public static final IrWhenUtils INSTANCE = new IrWhenUtils();

    private IrWhenUtils() {
    }

    @Nullable
    public final ArrayList<IrCall> matchConditions(@NotNull IrFunctionSymbol ororSymbol, @NotNull IrExpression condition) {
        Intrinsics.checkNotNullParameter((Object)ororSymbol, (String)"ororSymbol");
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        if (condition instanceof IrWhen && Intrinsics.areEqual((Object)((IrWhen)condition).getOrigin(), (Object)IrStatementOrigin.Companion.getWHEN_COMMA())) {
            Collection collection;
            boolean bl2 = IrTypePredicatesKt.isBoolean(condition.getType());
            if (_Assertions.ENABLED && !bl2) {
                boolean bl3 = false;
                String string2 = "WHEN_COMMA should always be a Boolean: " + DumpIrTreeKt.dump$default(condition, null, 1, null);
                throw new AssertionError((Object)string2);
            }
            ArrayList candidates2 = new ArrayList();
            for (IrBranch branch : ((IrWhen)condition).getBranches()) {
                ArrayList<IrCall> arrayList;
                Collection collection2 = candidates2;
                if (IrUtilsKt.isElseBranch(branch)) {
                    boolean bl4 = IrUtilsKt.isTrueConst(branch.getCondition());
                    if (_Assertions.ENABLED && !bl4) {
                        boolean bl5 = false;
                        String string3 = "IrElseBranch.condition should be const true: " + DumpIrTreeKt.dump$default(branch.getCondition(), null, 1, null);
                        throw new AssertionError((Object)string3);
                    }
                    arrayList = this.matchConditions(ororSymbol, branch.getResult());
                    if (arrayList == null) {
                        return null;
                    }
                } else {
                    if (!IrUtilsKt.isTrueConst(branch.getResult())) {
                        return null;
                    }
                    arrayList = this.matchConditions(ororSymbol, branch.getCondition());
                    if (arrayList == null) {
                        return null;
                    }
                }
                Iterable iterable = arrayList;
                CollectionsKt.addAll((Collection)collection2, (Iterable)iterable);
            }
            Collection collection3 = candidates2;
            if (collection3.isEmpty()) {
                boolean bl6 = false;
                collection = null;
            } else {
                collection = collection3;
            }
            return (ArrayList)collection;
        }
        if (condition instanceof IrCall && Intrinsics.areEqual((Object)((IrCall)condition).getSymbol(), (Object)ororSymbol)) {
            Object object;
            ArrayList candidates3 = new ArrayList();
            Iterator iterator2 = ((IrCall)condition).getArguments().iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
            Object object2 = iterator2;
            while (object2.hasNext()) {
                IrExpression argument = (IrExpression)object2.next();
                Collection collection = candidates3;
                IrExpression irExpression = argument;
                Intrinsics.checkNotNull((Object)irExpression);
                ArrayList<IrCall> arrayList = this.matchConditions(ororSymbol, irExpression);
                if (arrayList == null) {
                    return null;
                }
                CollectionsKt.addAll((Collection)collection, (Iterable)arrayList);
            }
            object2 = candidates3;
            if (object2.isEmpty()) {
                boolean bl7 = false;
                object = null;
            } else {
                object = object2;
            }
            return (ArrayList)object;
        }
        if (condition instanceof IrCall) {
            Object[] objectArray = new IrCall[]{condition};
            return CollectionsKt.arrayListOf((Object[])objectArray);
        }
        return null;
    }
}

