/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.analysis.decompiled.light.classes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.openapi.util.registry.Registry;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.psi.ClassFileViewProvider;
import ksp.com.intellij.psi.PsiClass;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiFile;
import ksp.com.intellij.psi.PsiManager;
import ksp.com.intellij.psi.impl.compiled.ClsClassImpl;
import ksp.com.intellij.psi.impl.compiled.ClsFileImpl;
import ksp.com.intellij.psi.impl.java.stubs.impl.PsiJavaFileStubImpl;
import ksp.com.intellij.psi.util.PsiTreeUtil;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.analysis.decompiled.light.classes.ClsJavaStubByVirtualFileCache;
import ksp.org.jetbrains.kotlin.analysis.decompiled.light.classes.KtLightClassForDecompiledDeclaration;
import ksp.org.jetbrains.kotlin.analysis.decompiled.light.classes.KtLightClassForDecompiledFacade;
import ksp.org.jetbrains.kotlin.analysis.decompiler.psi.file.KtClsFile;
import ksp.org.jetbrains.kotlin.asJava.builder.ClsWrapperStubPsiFactory;
import ksp.org.jetbrains.kotlin.asJava.classes.KtLightClassForFacade;
import ksp.org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import ksp.org.jetbrains.kotlin.name.FqName;
import ksp.org.jetbrains.kotlin.name.Name;
import ksp.org.jetbrains.kotlin.psi.KtClassOrObject;
import ksp.org.jetbrains.kotlin.psi.KtEnumEntry;
import ksp.org.jetbrains.kotlin.psi.KtFile;
import ksp.org.jetbrains.kotlin.utils.KotlinExceptionWithAttachments;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u001a\u0010\u000e\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\tH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0012\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\rJt\u0010\u0012\u001a\u0004\u0018\u0001H\u0015\"\u0004\b\u0000\u0010\u00152\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142M\u0010\u0016\u001aI\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001a\u0012\u0013\u0012\u00110\u001b\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001c\u0012\u0015\u0012\u0013\u0018\u00010\u000b\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001d\u0012\u0004\u0012\u0002H\u00150\u0017H\u0002\u00a2\u0006\u0002\u0010\u001eJ&\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010!\u001a\u00020\u00112\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#J*\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020$2\u0006\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rR\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006+"}, d2={"Lksp/org/jetbrains/kotlin/analysis/decompiled/light/classes/DecompiledLightClassesFactory;", "", "<init>", "()V", "checkInconsistency", "", "getCheckInconsistency", "()Z", "getLightClassForDecompiledClassOrObject", "Lksp/org/jetbrains/kotlin/analysis/decompiled/light/classes/KtLightClassForDecompiledDeclaration;", "decompiledClassOrObject", "Lksp/org/jetbrains/kotlin/psi/KtClassOrObject;", "project", "Lksp/com/intellij/openapi/project/Project;", "findCorrespondingLightClass", "rootLightClassForDecompiledFile", "getClassRelativeName", "Lksp/org/jetbrains/kotlin/name/FqName;", "createLightClassForDecompiledKotlinFile", "file", "Lksp/org/jetbrains/kotlin/analysis/decompiler/psi/file/KtClsFile;", "T", "builder", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "kotlinClsFile", "Lksp/com/intellij/psi/PsiClass;", "javaClsClass", "classOrObject", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/analysis/decompiler/psi/file/KtClsFile;Lkotlin/jvm/functions/Function3;)Ljava/lang/Object;", "createLightFacadeForDecompiledKotlinFile", "Lksp/org/jetbrains/kotlin/asJava/classes/KtLightClassForFacade;", "facadeClassFqName", "files", "", "Lksp/org/jetbrains/kotlin/psi/KtFile;", "createClsJavaClassFromVirtualFile", "Lksp/com/intellij/psi/impl/compiled/ClsClassImpl;", "mirrorFile", "classFile", "Lksp/com/intellij/openapi/vfs/VirtualFile;", "correspondingClassOrObject", "light-classes-for-decompiled"})
@SourceDebugExtension(value={"SMAP\nDecompiledLightClassesFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DecompiledLightClassesFactory.kt\norg/jetbrains/kotlin/analysis/decompiled/light/classes/DecompiledLightClassesFactory\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,164:1\n11228#2:165\n11563#2,3:166\n808#3,11:169\n1740#3,3:180\n295#3,2:183\n1563#3:185\n1634#3,3:186\n*S KotlinDebug\n*F\n+ 1 DecompiledLightClassesFactory.kt\norg/jetbrains/kotlin/analysis/decompiled/light/classes/DecompiledLightClassesFactory\n*L\n76#1:165\n76#1:166,3\n113#1:169,11\n129#1:180,3\n130#1:183,2\n131#1:185\n131#1:186,3\n*E\n"})
public final class DecompiledLightClassesFactory {
    @NotNull
    public static final DecompiledLightClassesFactory INSTANCE = new DecompiledLightClassesFactory();

    private DecompiledLightClassesFactory() {
    }

    private final boolean getCheckInconsistency() {
        return Registry.is("kotlin.decompiled.light.classes.check.inconsistency", false);
    }

    @Nullable
    public final KtLightClassForDecompiledDeclaration getLightClassForDecompiledClassOrObject(@NotNull KtClassOrObject decompiledClassOrObject, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)decompiledClassOrObject, (String)"decompiledClassOrObject");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (decompiledClassOrObject instanceof KtEnumEntry) {
            return null;
        }
        PsiFile psiFile = decompiledClassOrObject.getContainingFile();
        KtClsFile ktClsFile = psiFile instanceof KtClsFile ? (KtClsFile)psiFile : null;
        if (ktClsFile == null) {
            return null;
        }
        KtClsFile containingKtFile = ktClsFile;
        KtLightClassForDecompiledDeclaration ktLightClassForDecompiledDeclaration = this.createLightClassForDecompiledKotlinFile(containingKtFile, project);
        if (ktLightClassForDecompiledDeclaration == null) {
            return null;
        }
        KtLightClassForDecompiledDeclaration rootLightClassForDecompiledFile = ktLightClassForDecompiledDeclaration;
        return this.findCorrespondingLightClass(decompiledClassOrObject, rootLightClassForDecompiledFile);
    }

    /*
     * WARNING - void declaration
     */
    private final KtLightClassForDecompiledDeclaration findCorrespondingLightClass(KtClassOrObject decompiledClassOrObject, KtLightClassForDecompiledDeclaration rootLightClassForDecompiledFile) {
        FqName fqName = this.getClassRelativeName(decompiledClassOrObject);
        if (fqName == null) {
            return null;
        }
        FqName relativeFqName = fqName;
        Iterator<Name> iterator2 = relativeFqName.pathSegments().iterator();
        Name base = iterator2.next();
        if (!Intrinsics.areEqual((Object)rootLightClassForDecompiledFile.getName(), (Object)base.asString())) {
            return null;
        }
        KtLightClassForDecompiledDeclaration current = rootLightClassForDecompiledFile;
        while (iterator2.hasNext()) {
            Name name2 = iterator2.next();
            String string2 = name2.asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
            PsiClass innerClass = current.findInnerClassByName(string2, false);
            PsiClass psiClass = innerClass;
            if (psiClass == null) {
                if (this.getCheckInconsistency()) {
                    Collection<String> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    PsiClass[] psiClassArray = current.getInnerClasses();
                    String string3 = "innerClasses.txt";
                    KotlinExceptionWithAttachments kotlinExceptionWithAttachments = new KotlinExceptionWithAttachments("Could not find corresponding inner/nested class").withAttachment("relativeFqName.txt", relativeFqName).withAttachment("decompiledClassOrObjectFqName.txt", decompiledClassOrObject.getFqName()).withAttachment("decompiledFileName.txt", decompiledClassOrObject.getContainingKtFile().getVirtualFile().getName()).withPsiAttachment("decompiledClassOrObject.txt", decompiledClassOrObject).withAttachment("fileClass.txt", Reflection.getOrCreateKotlinClass(decompiledClassOrObject.getContainingFile().getClass())).withPsiAttachment("file.txt", decompiledClassOrObject.getContainingFile()).withPsiAttachment("root.txt", rootLightClassForDecompiledFile).withAttachment("currentName.txt", current.getName()).withPsiAttachment("current.txt", current);
                    boolean $i$f$map = false;
                    void var11_13 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
                    boolean $i$f$mapTo = false;
                    int n2 = ((void)$this$mapTo$iv$iv).length;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        void psiClass2;
                        void item$iv$iv;
                        void var17_19 = item$iv$iv = $this$mapTo$iv$iv[i2];
                        collection = destination$iv$iv;
                        boolean bl2 = false;
                        collection.add(psiClass2.getName());
                    }
                    collection = (List)destination$iv$iv;
                    throw kotlinExceptionWithAttachments.withAttachment(string3, collection).withAttachment("innerName.txt", name2.asString());
                }
                return null;
            }
            current = (KtLightClassForDecompiledDeclaration)psiClass;
        }
        return current;
    }

    private final FqName getClassRelativeName(KtClassOrObject decompiledClassOrObject) {
        Name name2 = decompiledClassOrObject.getNameAsName();
        if (name2 == null) {
            return null;
        }
        Name name3 = name2;
        KtClassOrObject parent2 = PsiTreeUtil.getParentOfType((PsiElement)decompiledClassOrObject, KtClassOrObject.class, true);
        if (parent2 == null) {
            boolean bl2 = decompiledClassOrObject.isTopLevel();
            if (_Assertions.ENABLED && !bl2) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            return FqName.Companion.topLevel(name3);
        }
        FqName fqName = this.getClassRelativeName(parent2);
        return fqName != null ? fqName.child(name3) : null;
    }

    @Nullable
    public final KtLightClassForDecompiledDeclaration createLightClassForDecompiledKotlinFile(@NotNull KtClsFile file2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return (KtLightClassForDecompiledDeclaration)this.createLightClassForDecompiledKotlinFile(project, file2, DecompiledLightClassesFactory::createLightClassForDecompiledKotlinFile$lambda$1);
    }

    /*
     * WARNING - void declaration
     */
    private final <T> T createLightClassForDecompiledKotlinFile(Project project, KtClsFile file2, Function3<? super KtClsFile, ? super PsiClass, ? super KtClassOrObject, ? extends T> builder2) {
        void $this$filterIsInstanceTo$iv$iv;
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        Iterable $this$filterIsInstance$iv = file2.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KtClassOrObject)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        KtClassOrObject classOrObject = (KtClassOrObject)CollectionsKt.singleOrNull((List)((List)destination$iv$iv));
        ClsClassImpl clsClassImpl = this.createClsJavaClassFromVirtualFile(file2, virtualFile2, classOrObject, project);
        if (clsClassImpl == null) {
            return null;
        }
        ClsClassImpl javaClsClass = clsClassImpl;
        return (T)builder2.invoke((Object)file2, (Object)javaClsClass, (Object)classOrObject);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final KtLightClassForFacade createLightFacadeForDecompiledKotlinFile(@NotNull Project project, @NotNull FqName facadeClassFqName, @NotNull List<? extends KtFile> files2) {
        Object v1;
        block8: {
            boolean $this$all$iv2;
            block7: {
                boolean bl2;
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)facadeClassFqName, (String)"facadeClassFqName");
                Intrinsics.checkNotNullParameter(files2, (String)"files");
                Iterable $this$all$iv2 = files2;
                boolean $i$f$all = false;
                if ($this$all$iv2 instanceof Collection && ((Collection)$this$all$iv2).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$all$iv2) {
                        KtFile p0 = (KtFile)element$iv;
                        boolean bl3 = false;
                        if (p0.isCompiled()) continue;
                        bl2 = false;
                        break block7;
                    }
                    bl2 = $this$all$iv2 = true;
                }
            }
            if (_Assertions.ENABLED && !$this$all$iv2) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            Iterable $this$firstOrNull$iv = files2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KtFile it = (KtFile)element$iv;
                boolean bl4 = false;
                if (!Intrinsics.areEqual((Object)JvmFileClassUtilKt.getJavaFileFacadeFqName(it), (Object)facadeClassFqName)) continue;
                v1 = element$iv;
                break block8;
            }
            v1 = null;
        }
        Object object = v1;
        KtClsFile ktClsFile = object instanceof KtClsFile ? (KtClsFile)object : null;
        if (ktClsFile == null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            object = files2;
            StringBuilder stringBuilder = new StringBuilder().append("Can't find the representative decompiled file for ").append(facadeClassFqName).append(" in ");
            boolean $i$f$map = false;
            void $i$f$firstOrNull = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                KtFile ktFile = (KtFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl5 = false;
                collection.add(it.getName());
            }
            object = stringBuilder.append((List)destination$iv$iv).toString();
            throw new IllegalStateException(object.toString());
        }
        KtClsFile file2 = ktClsFile;
        return (KtLightClassForFacade)this.createLightClassForDecompiledKotlinFile(project, file2, (arg_0, arg_1, arg_2) -> DecompiledLightClassesFactory.createLightFacadeForDecompiledKotlinFile$lambda$4(files2, arg_0, arg_1, arg_2));
    }

    @Nullable
    public final ClsClassImpl createClsJavaClassFromVirtualFile(@NotNull KtFile mirrorFile, @NotNull VirtualFile classFile, @Nullable KtClassOrObject correspondingClassOrObject, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)mirrorFile, (String)"mirrorFile");
        Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PsiJavaFileStubImpl psiJavaFileStubImpl = ClsJavaStubByVirtualFileCache.Companion.getInstance(project).get(classFile);
        if (psiJavaFileStubImpl == null) {
            return null;
        }
        PsiJavaFileStubImpl javaFileStub = psiJavaFileStubImpl;
        javaFileStub.setPsiFactory(ClsWrapperStubPsiFactory.INSTANCE);
        PsiManager psiManager = PsiManager.getInstance(mirrorFile.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        PsiManager manager = psiManager;
        ClassFileViewProvider classFileViewProvider = new ClassFileViewProvider(manager, classFile);
        ClsFileImpl fakeFile2 = new ClsFileImpl(correspondingClassOrObject, javaFileStub, mirrorFile, classFileViewProvider){
            final /* synthetic */ KtClassOrObject $correspondingClassOrObject;
            final /* synthetic */ PsiJavaFileStubImpl $javaFileStub;
            final /* synthetic */ KtFile $mirrorFile;
            {
                this.$correspondingClassOrObject = $correspondingClassOrObject;
                this.$javaFileStub = $javaFileStub;
                this.$mirrorFile = $mirrorFile;
                super($super_call_param$1);
            }

            public PsiElement getNavigationElement() {
                if (this.$correspondingClassOrObject != null) {
                    PsiFile psiFile = this.$correspondingClassOrObject.getNavigationElement().getContainingFile();
                    Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
                    return psiFile;
                }
                PsiElement psiElement = super.getNavigationElement();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getNavigationElement(...)");
                return psiElement;
            }

            public PsiJavaFileStubImpl getStub() {
                return this.$javaFileStub;
            }

            public KtFile getMirror() {
                return this.$mirrorFile;
            }

            public boolean isPhysical() {
                return false;
            }
        };
        javaFileStub.setPsi((PsiFile)fakeFile2);
        PsiClass[] psiClassArray = fakeFile2.getClasses();
        Intrinsics.checkNotNullExpressionValue((Object)psiClassArray, (String)"getClasses(...)");
        Object object = ArraysKt.single((Object[])psiClassArray);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.psi.impl.compiled.ClsClassImpl");
        return (ClsClassImpl)object;
    }

    private static final KtLightClassForDecompiledDeclaration createLightClassForDecompiledKotlinFile$lambda$1(KtClsFile kotlinClsFile, PsiClass javaClsClass, KtClassOrObject classOrObject) {
        Intrinsics.checkNotNullParameter((Object)kotlinClsFile, (String)"kotlinClsFile");
        Intrinsics.checkNotNullParameter((Object)javaClsClass, (String)"javaClsClass");
        PsiElement psiElement = javaClsClass.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getParent(...)");
        return new KtLightClassForDecompiledDeclaration(javaClsClass, psiElement, kotlinClsFile, classOrObject);
    }

    private static final KtLightClassForDecompiledFacade createLightFacadeForDecompiledKotlinFile$lambda$4(List $files, KtClsFile kotlinClsFile, PsiClass javaClsClass, KtClassOrObject classOrObject) {
        Intrinsics.checkNotNullParameter((Object)kotlinClsFile, (String)"kotlinClsFile");
        Intrinsics.checkNotNullParameter((Object)javaClsClass, (String)"javaClsClass");
        PsiElement psiElement = javaClsClass.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getParent(...)");
        return new KtLightClassForDecompiledFacade(javaClsClass, psiElement, kotlinClsFile, classOrObject, $files);
    }
}

