/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.impl.source.tree;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import ksp.com.intellij.lang.ASTFactory;
import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.pom.PomManager;
import ksp.com.intellij.pom.PomModel;
import ksp.com.intellij.pom.event.PomModelEvent;
import ksp.com.intellij.pom.impl.PomTransactionBase;
import ksp.com.intellij.pom.tree.TreeAspect;
import ksp.com.intellij.pom.tree.events.TreeChangeEvent;
import ksp.com.intellij.pom.tree.events.impl.TreeChangeEventImpl;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiManager;
import ksp.com.intellij.psi.impl.DebugUtil;
import ksp.com.intellij.psi.impl.PsiManagerEx;
import ksp.com.intellij.psi.impl.source.DummyHolder;
import ksp.com.intellij.psi.impl.source.DummyHolderFactory;
import ksp.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import ksp.com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import ksp.com.intellij.psi.impl.source.tree.CompositeElement;
import ksp.com.intellij.psi.impl.source.tree.FileElement;
import ksp.com.intellij.psi.impl.source.tree.LeafElement;
import ksp.com.intellij.psi.impl.source.tree.TreeCopyHandler;
import ksp.com.intellij.psi.impl.source.tree.TreeElement;
import ksp.com.intellij.psi.impl.source.tree.TreeGenerator;
import ksp.com.intellij.psi.impl.source.tree.TreeUtil;
import ksp.com.intellij.psi.util.PsiUtilCore;
import ksp.com.intellij.util.CharTable;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public final class ChangeUtil {
    private static final Logger LOG = Logger.getInstance(ChangeUtil.class);

    public static void encodeInformation(TreeElement element2) {
        ChangeUtil.encodeInformation(element2, element2);
    }

    private static void encodeInformation(TreeElement element2, ASTNode original) {
        DebugUtil.performPsiModification(null, () -> ChangeUtil.encodeInformation(element2, original, new HashMap<Object, Object>()));
    }

    private static void encodeInformation(TreeElement element2, ASTNode original, Map<Object, Object> state) {
        for (TreeCopyHandler handler2 : TreeCopyHandler.EP_NAME.getExtensionList()) {
            handler2.encodeInformation(element2, original, state);
        }
        if (original instanceof CompositeElement) {
            TreeElement child = element2.getFirstChildNode();
            ASTNode child1 = original.getFirstChildNode();
            while (child != null) {
                ChangeUtil.encodeInformation(child, child1, state);
                child = child.getTreeNext();
                child1 = child1.getTreeNext();
            }
        }
    }

    public static TreeElement decodeInformation(TreeElement element2) {
        return DebugUtil.performPsiModification(null, () -> ChangeUtil.decodeInformation(element2, new HashMap<Object, Object>()));
    }

    private static TreeElement decodeInformation(TreeElement element2, Map<Object, Object> state) {
        for (TreeElement child = element2.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            child = ChangeUtil.decodeInformation(child, state);
        }
        for (TreeCopyHandler handler2 : TreeCopyHandler.EP_NAME.getExtensionList()) {
            TreeElement treeElement = handler2.decodeInformation(element2, state);
            if (treeElement == null) continue;
            return treeElement;
        }
        return element2;
    }

    @NotNull
    public static LeafElement copyLeafWithText(@NotNull LeafElement original, @NotNull String text) {
        if (original == null) {
            ChangeUtil.$$$reportNull$$$0(0);
        }
        if (text == null) {
            ChangeUtil.$$$reportNull$$$0(1);
        }
        LeafElement element2 = ASTFactory.leaf(original.getElementType(), text);
        original.copyCopyableDataTo(element2);
        ChangeUtil.encodeInformation(element2, original);
        TreeUtil.clearCaches(element2);
        ChangeUtil.saveIndentationToCopy(original, element2);
        LeafElement leafElement = element2;
        if (leafElement == null) {
            ChangeUtil.$$$reportNull$$$0(2);
        }
        return leafElement;
    }

    @NotNull
    public static TreeElement copyElement(@NotNull TreeElement original, CharTable table) {
        CompositeElement treeParent;
        if (original == null) {
            ChangeUtil.$$$reportNull$$$0(3);
        }
        return ChangeUtil.copyElement(original, (treeParent = original.getTreeParent()) == null ? null : treeParent.getPsi(), table);
    }

    @NotNull
    public static TreeElement copyElement(@NotNull TreeElement original, PsiElement context2, CharTable table) {
        if (original == null) {
            ChangeUtil.$$$reportNull$$$0(4);
        }
        TreeElement element2 = (TreeElement)original.clone();
        PsiManagerEx manager = original.getManager();
        DummyHolderFactory.createHolder(manager, element2, context2, table).getTreeElement();
        ChangeUtil.encodeInformation(element2, original);
        TreeUtil.clearCaches(element2);
        ChangeUtil.saveIndentationToCopy(original, element2);
        TreeElement treeElement = element2;
        if (treeElement == null) {
            ChangeUtil.$$$reportNull$$$0(5);
        }
        return treeElement;
    }

    private static void saveIndentationToCopy(TreeElement original, TreeElement element2) {
        if (original == null || element2 == null || CodeEditUtil.isNodeGenerated(original)) {
            return;
        }
        int indentation = CodeEditUtil.getOldIndentation(original);
        if (indentation < 0) {
            CodeEditUtil.saveWhitespacesInfo(original);
        }
        CodeEditUtil.setOldIndentation(element2, CodeEditUtil.getOldIndentation(original));
        if (indentation < 0) {
            CodeEditUtil.setOldIndentation(original, -1);
        }
    }

    @NotNull
    public static TreeElement copyToElement(@NotNull PsiElement original) {
        DummyHolder holder;
        FileElement holderElement;
        TreeElement treeElement;
        if (original == null) {
            ChangeUtil.$$$reportNull$$$0(6);
        }
        LOG.assertTrue((treeElement = ChangeUtil.generateTreeElement(original, (holderElement = (holder = DummyHolderFactory.createHolder(original.getManager(), null, original.getLanguage())).getTreeElement()).getCharTable(), original.getManager())) != null, "original element class: " + original.getClass().getName() + ", language: " + original.getLanguage());
        holderElement.rawAddChildren(treeElement);
        TreeUtil.clearCaches(holderElement);
        ChangeUtil.saveIndentationToCopy((TreeElement)original.getNode(), treeElement);
        TreeElement treeElement2 = treeElement;
        if (treeElement2 == null) {
            ChangeUtil.$$$reportNull$$$0(7);
        }
        return treeElement2;
    }

    @Nullable
    public static TreeElement generateTreeElement(@Nullable PsiElement original, @NotNull CharTable table, @NotNull PsiManager manager) {
        if (table == null) {
            ChangeUtil.$$$reportNull$$$0(8);
        }
        if (manager == null) {
            ChangeUtil.$$$reportNull$$$0(9);
        }
        if (original == null) {
            return null;
        }
        PsiUtilCore.ensureValid(original);
        if (SourceTreeToPsiMap.hasTreeElement(original)) {
            return ChangeUtil.copyElement((TreeElement)SourceTreeToPsiMap.psiElementToTree(original), table);
        }
        return TreeGenerator.EP_NAME.getExtensionList().stream().map(generator -> generator.generateTreeFor(original, table, manager)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public static void prepareAndRunChangeAction(final @NotNull ChangeAction action, final @NotNull TreeElement changedElement) {
        if (action == null) {
            ChangeUtil.$$$reportNull$$$0(10);
        }
        if (changedElement == null) {
            ChangeUtil.$$$reportNull$$$0(11);
        }
        final FileElement changedFile = TreeUtil.getFileElement(changedElement);
        PsiManagerEx manager = changedFile.getManager();
        final PomModel model = PomManager.getModel(manager.getProject());
        model.runTransaction(new PomTransactionBase(changedElement.getPsi()){

            @Override
            @NotNull
            public PomModelEvent runInner() {
                TreeChangeEventImpl destinationTreeChange = new TreeChangeEventImpl(model.getModelAspect(TreeAspect.class), changedFile);
                PomModelEvent event = new PomModelEvent(model, destinationTreeChange);
                action.makeChange(destinationTreeChange);
                changedElement.clearCaches();
                if (changedElement instanceof CompositeElement) {
                    ((CompositeElement)changedElement).subtreeChanged();
                }
                PomModelEvent pomModelEvent = event;
                if (pomModelEvent == null) {
                    1.$$$reportNull$$$0(0);
                }
                return pomModelEvent;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ksp/com/intellij/psi/impl/source/tree/ChangeUtil$1", "runInner"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/psi/impl/source/tree/ChangeUtil";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changedElement";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/psi/impl/source/tree/ChangeUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "copyLeafWithText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "copyElement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "copyToElement";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "copyLeafWithText";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "copyElement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "copyToElement";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "generateTreeElement";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "prepareAndRunChangeAction";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    public static interface ChangeAction {
        public void makeChange(@NotNull TreeChangeEvent var1);
    }
}

