/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.impl.smartPointers;

import java.util.Objects;
import ksp.com.intellij.lang.Language;
import ksp.com.intellij.lang.LanguageUtil;
import ksp.com.intellij.openapi.editor.Document;
import ksp.com.intellij.openapi.editor.ex.DocumentEx;
import ksp.com.intellij.openapi.fileEditor.FileDocumentManager;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.openapi.util.Segment;
import ksp.com.intellij.openapi.util.TextRange;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.psi.PsiDocumentManager;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiFile;
import ksp.com.intellij.psi.impl.PsiDocumentManagerBase;
import ksp.com.intellij.psi.impl.smartPointers.SelfElementInfo;
import ksp.com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import ksp.com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

final class FileElementInfo
extends SmartPointerElementInfo {
    @NotNull
    private final VirtualFile myVirtualFile;
    @NotNull
    private final Project myProject;
    @NotNull
    private final String myLanguageId;
    @NotNull
    private final String myFileClassName;

    FileElementInfo(@NotNull PsiFile file2) {
        if (file2 == null) {
            FileElementInfo.$$$reportNull$$$0(0);
        }
        this.myVirtualFile = file2.getViewProvider().getVirtualFile();
        this.myProject = file2.getProject();
        this.myLanguageId = LanguageUtil.getRootLanguage(file2).getID();
        this.myFileClassName = file2.getClass().getName();
    }

    @Override
    PsiElement restoreElement(@NotNull SmartPointerManagerImpl manager) {
        Language language;
        if (manager == null) {
            FileElementInfo.$$$reportNull$$$0(1);
        }
        if ((language = Language.findLanguageByID(this.myLanguageId)) == null) {
            return null;
        }
        PsiFile file2 = SelfElementInfo.restoreFileFromVirtual(this.myVirtualFile, this.myProject, language);
        return file2 != null && file2.getClass().getName().equals(this.myFileClassName) ? file2 : null;
    }

    @Override
    PsiFile restoreFile(@NotNull SmartPointerManagerImpl manager) {
        PsiElement element2;
        if (manager == null) {
            FileElementInfo.$$$reportNull$$$0(2);
        }
        return (element2 = this.restoreElement(manager)) == null ? null : element2.getContainingFile();
    }

    @Override
    int elementHashCode() {
        return this.myVirtualFile.hashCode();
    }

    @Override
    boolean pointsToTheSameElementAs(@NotNull SmartPointerElementInfo other, @NotNull SmartPointerManagerImpl manager) {
        if (other == null) {
            FileElementInfo.$$$reportNull$$$0(3);
        }
        if (manager == null) {
            FileElementInfo.$$$reportNull$$$0(4);
        }
        return other instanceof FileElementInfo && Objects.equals(this.myVirtualFile, ((FileElementInfo)other).myVirtualFile);
    }

    @Override
    @NotNull
    VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myVirtualFile;
        if (virtualFile == null) {
            FileElementInfo.$$$reportNull$$$0(5);
        }
        return virtualFile;
    }

    @Override
    Segment getRange(@NotNull SmartPointerManagerImpl manager) {
        if (manager == null) {
            FileElementInfo.$$$reportNull$$$0(6);
        }
        if (!this.myVirtualFile.isValid()) {
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(this.myVirtualFile);
        return document == null ? null : TextRange.from(0, document.getTextLength());
    }

    @Override
    @Nullable
    Segment getPsiRange(@NotNull SmartPointerManagerImpl manager) {
        Document currentDoc;
        if (manager == null) {
            FileElementInfo.$$$reportNull$$$0(7);
        }
        DocumentEx committedDoc = (currentDoc = FileDocumentManager.getInstance().getCachedDocument(this.myVirtualFile)) == null ? null : ((PsiDocumentManagerBase)PsiDocumentManager.getInstance(this.myProject)).getLastCommittedDocument(currentDoc);
        return committedDoc == null ? this.getRange(manager) : new TextRange(0, committedDoc.getTextLength());
    }

    public String toString() {
        return "file{" + this.myVirtualFile + ", " + this.myLanguageId + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 5: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/psi/impl/smartPointers/FileElementInfo";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/psi/impl/smartPointers/FileElementInfo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFile";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "restoreElement";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "restoreFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "pointsToTheSameElementAs";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRange";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPsiRange";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

