/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.impl.compiled;

import ksp.com.intellij.lang.java.lexer.JavaLexer;
import ksp.com.intellij.lang.java.parser.JavaParser;
import ksp.com.intellij.lang.java.parser.JavaParserUtil;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.projectRoots.JavaSdkVersion;
import ksp.com.intellij.openapi.util.text.StringUtil;
import ksp.com.intellij.pom.java.LanguageLevel;
import ksp.com.intellij.psi.JavaPsiFacade;
import ksp.com.intellij.psi.PsiAnnotation;
import ksp.com.intellij.psi.PsiAnnotationMemberValue;
import ksp.com.intellij.psi.PsiAnnotationOwner;
import ksp.com.intellij.psi.PsiArrayInitializerMemberValue;
import ksp.com.intellij.psi.PsiBinaryExpression;
import ksp.com.intellij.psi.PsiClassObjectAccessExpression;
import ksp.com.intellij.psi.PsiConstantEvaluationHelper;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiExpression;
import ksp.com.intellij.psi.PsiFile;
import ksp.com.intellij.psi.PsiJavaCodeReferenceElement;
import ksp.com.intellij.psi.PsiJavaParserFacade;
import ksp.com.intellij.psi.PsiJavaToken;
import ksp.com.intellij.psi.PsiLiteralExpression;
import ksp.com.intellij.psi.PsiManager;
import ksp.com.intellij.psi.PsiNameValuePair;
import ksp.com.intellij.psi.PsiPrefixExpression;
import ksp.com.intellij.psi.PsiPrimitiveType;
import ksp.com.intellij.psi.PsiReferenceExpression;
import ksp.com.intellij.psi.PsiType;
import ksp.com.intellij.psi.PsiTypes;
import ksp.com.intellij.psi.impl.compiled.ClsAnnotationParameterListImpl;
import ksp.com.intellij.psi.impl.compiled.ClsAnnotationValueImpl;
import ksp.com.intellij.psi.impl.compiled.ClsArrayInitializerMemberValueImpl;
import ksp.com.intellij.psi.impl.compiled.ClsBinaryExpressionImpl;
import ksp.com.intellij.psi.impl.compiled.ClsClassObjectAccessExpressionImpl;
import ksp.com.intellij.psi.impl.compiled.ClsElementImpl;
import ksp.com.intellij.psi.impl.compiled.ClsFileImpl;
import ksp.com.intellij.psi.impl.compiled.ClsJavaCodeReferenceElementImpl;
import ksp.com.intellij.psi.impl.compiled.ClsLiteralExpressionImpl;
import ksp.com.intellij.psi.impl.compiled.ClsPrefixExpressionImpl;
import ksp.com.intellij.psi.impl.compiled.ClsReferenceExpressionImpl;
import ksp.com.intellij.psi.impl.source.DummyHolder;
import ksp.com.intellij.psi.impl.source.DummyHolderFactory;
import ksp.com.intellij.psi.impl.source.JavaDummyElement;
import ksp.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import ksp.com.intellij.psi.util.PsiUtil;
import ksp.com.intellij.util.IncorrectOperationException;
import ksp.com.intellij.util.lang.JavaVersion;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public final class ClsParsingUtil {
    private static final Logger LOG = Logger.getInstance(ClsParsingUtil.class);
    private static final JavaParserUtil.ParserWrapper ANNOTATION_VALUE = builder2 -> JavaParser.INSTANCE.getDeclarationParser().parseAnnotationValue(builder2);

    private ClsParsingUtil() {
    }

    public static PsiExpression createExpressionFromText(@NotNull String exprText, @NotNull PsiManager manager, @NotNull ClsElementImpl parent2) {
        if (exprText == null) {
            ClsParsingUtil.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            ClsParsingUtil.$$$reportNull$$$0(1);
        }
        if (parent2 == null) {
            ClsParsingUtil.$$$reportNull$$$0(2);
        }
        PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(manager.getProject()).getParserFacade();
        try {
            PsiExpression expr = parserFacade.createExpressionFromText(exprText, null);
            return ClsParsingUtil.psiToClsExpression(expr, parent2);
        }
        catch (IncorrectOperationException e2) {
            LOG.error(e2);
            return null;
        }
    }

    public static PsiAnnotationMemberValue createMemberValueFromText(@NotNull String text, @NotNull PsiManager manager, @NotNull ClsElementImpl parent2) {
        LanguageLevel level;
        DummyHolder holder;
        PsiElement element2;
        if (text == null) {
            ClsParsingUtil.$$$reportNull$$$0(3);
        }
        if (manager == null) {
            ClsParsingUtil.$$$reportNull$$$0(4);
        }
        if (parent2 == null) {
            ClsParsingUtil.$$$reportNull$$$0(5);
        }
        if (!((element2 = SourceTreeToPsiMap.treeElementToPsi((holder = DummyHolderFactory.createHolder(manager, new JavaDummyElement(text, ANNOTATION_VALUE, level = PsiUtil.getLanguageLevel(parent2)), null)).getTreeElement().getFirstChildNode())) instanceof PsiAnnotationMemberValue)) {
            LOG.error("Could not parse initializer:'" + text + "'");
            return null;
        }
        return ClsParsingUtil.getMemberValue(element2, parent2);
    }

    public static PsiAnnotationMemberValue getMemberValue(@NotNull PsiElement element2, @NotNull ClsElementImpl parent2) {
        if (element2 == null) {
            ClsParsingUtil.$$$reportNull$$$0(6);
        }
        if (parent2 == null) {
            ClsParsingUtil.$$$reportNull$$$0(7);
        }
        if (element2 instanceof PsiExpression) {
            return ClsParsingUtil.psiToClsExpression((PsiExpression)element2, parent2);
        }
        if (element2 instanceof PsiArrayInitializerMemberValue) {
            PsiAnnotationMemberValue[] initializers = ((PsiArrayInitializerMemberValue)element2).getInitializers();
            PsiAnnotationMemberValue[] clsInitializers = new PsiAnnotationMemberValue[initializers.length];
            ClsArrayInitializerMemberValueImpl arrayValue = new ClsArrayInitializerMemberValueImpl(parent2, clsInitializers);
            for (int i2 = 0; i2 < initializers.length; ++i2) {
                clsInitializers[i2] = ClsParsingUtil.getMemberValue(initializers[i2], arrayValue);
            }
            return arrayValue;
        }
        if (element2 instanceof PsiAnnotation) {
            final PsiAnnotation psiAnnotation = (PsiAnnotation)element2;
            PsiJavaCodeReferenceElement referenceElement = psiAnnotation.getNameReferenceElement();
            assert (referenceElement != null) : psiAnnotation;
            final String canonicalText = referenceElement.getText();
            return new ClsAnnotationValueImpl(parent2){

                @Override
                protected ClsJavaCodeReferenceElementImpl createReference() {
                    return new ClsJavaCodeReferenceElementImpl(this, canonicalText);
                }

                @Override
                protected ClsAnnotationParameterListImpl createParameterList() {
                    PsiNameValuePair[] psiAttributes = psiAnnotation.getParameterList().getAttributes();
                    return new ClsAnnotationParameterListImpl(this, psiAttributes);
                }

                @Override
                public PsiAnnotationOwner getOwner() {
                    return (PsiAnnotationOwner)((Object)this.getParent());
                }
            };
        }
        LOG.error("Unexpected source element for annotation member value: " + element2);
        return null;
    }

    static PsiExpression psiToClsExpression(@NotNull PsiExpression expr, @NotNull ClsElementImpl parent2) {
        String exprText;
        if (expr == null) {
            ClsParsingUtil.$$$reportNull$$$0(8);
        }
        if (parent2 == null) {
            ClsParsingUtil.$$$reportNull$$$0(9);
        }
        if (expr instanceof PsiLiteralExpression) {
            PsiFile file2 = parent2.getContainingFile();
            boolean forDecompiling = file2 instanceof ClsFileImpl && ((ClsFileImpl)file2).isForDecompiling();
            PsiType type2 = forDecompiling ? (PsiPrimitiveType)PsiTypes.nullType() : expr.getType();
            Object value2 = forDecompiling ? null : ((PsiLiteralExpression)expr).getValue();
            return new ClsLiteralExpressionImpl(parent2, expr.getText(), type2, value2);
        }
        if (expr instanceof PsiPrefixExpression) {
            PsiJavaToken sign = ((PsiPrefixExpression)expr).getOperationSign();
            PsiExpression operand = ((PsiPrefixExpression)expr).getOperand();
            if (operand == null) {
                LOG.error("Invalid prefix expression: " + expr + " [" + expr.getText() + "]");
                return null;
            }
            return new ClsPrefixExpressionImpl(parent2, sign, operand);
        }
        if (expr instanceof PsiClassObjectAccessExpression && StringUtil.endsWith(exprText = expr.getText(), ".class")) {
            String classText = exprText.substring(0, exprText.length() - 6);
            return new ClsClassObjectAccessExpressionImpl(parent2, classText);
        }
        if (expr instanceof PsiReferenceExpression) {
            return new ClsReferenceExpressionImpl(parent2, (PsiReferenceExpression)expr);
        }
        if (expr instanceof PsiBinaryExpression) {
            PsiJavaToken sign = ((PsiBinaryExpression)expr).getOperationSign();
            PsiExpression left = ((PsiBinaryExpression)expr).getLOperand();
            PsiExpression right = ((PsiBinaryExpression)expr).getROperand();
            if (right == null) {
                LOG.error("Invalid binary expression: " + expr + " [" + expr.getText() + "]");
                return null;
            }
            return new ClsBinaryExpressionImpl(parent2, sign, left, right);
        }
        PsiFile file3 = parent2.getContainingFile();
        if (file3 instanceof ClsFileImpl && ((ClsFileImpl)file3).isForDecompiling()) {
            return new ClsLiteralExpressionImpl(parent2, expr.getText(), PsiTypes.nullType(), null);
        }
        PsiConstantEvaluationHelper evaluator = JavaPsiFacade.getInstance(expr.getProject()).getConstantEvaluationHelper();
        Object value3 = evaluator.computeConstantExpression(expr);
        if (value3 != null) {
            return new ClsLiteralExpressionImpl(parent2, expr.getText(), expr.getType(), value3);
        }
        LOG.error("Unable to compute expression value: " + expr + " [" + expr.getText() + "]");
        return null;
    }

    public static boolean isJavaIdentifier(@NotNull String identifier, @NotNull LanguageLevel level) {
        if (identifier == null) {
            ClsParsingUtil.$$$reportNull$$$0(10);
        }
        if (level == null) {
            ClsParsingUtil.$$$reportNull$$$0(11);
        }
        return StringUtil.isJavaIdentifier(identifier) && !JavaLexer.isKeyword(identifier, level);
    }

    @Nullable
    public static JavaSdkVersion getJdkVersionByBytecode(int major) {
        if (major >= 44) {
            JavaVersion version = JavaVersion.compose(major - 44);
            return JavaSdkVersion.fromJavaVersion(version);
        }
        return null;
    }

    public static boolean isPreviewLevel(int minor) {
        return minor == 65535;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exprText";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
        }
        objectArray2[1] = "ksp/com/intellij/psi/impl/compiled/ClsParsingUtil";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createExpressionFromText";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createMemberValueFromText";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getMemberValue";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "psiToClsExpression";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "isJavaIdentifier";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

