/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.model;

import java.util.function.BiFunction;
import java.util.function.Function;
import ksp.com.intellij.model.DelegatingPointer;
import ksp.com.intellij.model.DelegatingPointerEq;
import ksp.com.intellij.model.FileRangePointer;
import ksp.com.intellij.openapi.util.TextRange;
import ksp.com.intellij.psi.PsiFile;
import ksp.com.intellij.psi.SmartPointerManager;
import ksp.com.intellij.psi.SmartPsiFileRange;
import ksp.com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import ksp.com.intellij.util.concurrency.annotations.RequiresReadLock;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.Contract;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface Pointer<T> {
    @RequiresReadLock
    @RequiresBackgroundThread
    @Nullable
    public T dereference();

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <T> Pointer<T> hardPointer(@NotNull T value2) {
        if (value2 == null) {
            Pointer.$$$reportNull$$$0(0);
        }
        Pointer<Object> pointer = () -> value2;
        if (pointer == null) {
            Pointer.$$$reportNull$$$0(1);
        }
        return pointer;
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static <T, U> Pointer<T> delegatingPointer(@NotNull Pointer<? extends U> underlyingPointer, @NotNull Function<? super U, ? extends T> restoration) {
        if (underlyingPointer == null) {
            Pointer.$$$reportNull$$$0(2);
        }
        if (restoration == null) {
            Pointer.$$$reportNull$$$0(3);
        }
        return new DelegatingPointer.ByValue<T, U>(underlyingPointer, restoration);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static <T, U> Pointer<T> uroborosPointer(@NotNull Pointer<? extends U> underlyingPointer, @NotNull BiFunction<? super U, ? super Pointer<T>, ? extends T> restoration) {
        if (underlyingPointer == null) {
            Pointer.$$$reportNull$$$0(4);
        }
        if (restoration == null) {
            Pointer.$$$reportNull$$$0(5);
        }
        return new DelegatingPointer.ByValueAndPointer<T, U>(underlyingPointer, restoration);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static <T> Pointer<T> fileRangePointer(@NotNull PsiFile file2, @NotNull TextRange rangeInFile, @NotNull @NotNull BiFunction<? super @NotNull PsiFile, ? super @NotNull TextRange, ? extends @Nullable T> restoration) {
        if (file2 == null) {
            Pointer.$$$reportNull$$$0(6);
        }
        if (rangeInFile == null) {
            Pointer.$$$reportNull$$$0(7);
        }
        if (restoration == null) {
            Pointer.$$$reportNull$$$0(8);
        }
        SmartPsiFileRange base = SmartPointerManager.getInstance(file2.getProject()).createSmartPsiFileRangePointer(file2, rangeInFile);
        return new FileRangePointer<T>(base, restoration);
    }

    @Deprecated
    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static <T, U> Pointer<T> delegatingPointer(@NotNull Pointer<? extends U> underlyingPointer, @NotNull Object key, @NotNull Function<? super U, ? extends T> restoration) {
        if (underlyingPointer == null) {
            Pointer.$$$reportNull$$$0(9);
        }
        if (key == null) {
            Pointer.$$$reportNull$$$0(10);
        }
        if (restoration == null) {
            Pointer.$$$reportNull$$$0(11);
        }
        return new DelegatingPointerEq.ByValue<T, U>(underlyingPointer, key, restoration);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/model/Pointer";
                break;
            }
            case 2: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "underlyingPointer";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restoration";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInFile";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/model/Pointer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "hardPointer";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hardPointer";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "delegatingPointer";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "uroborosPointer";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fileRangePointer";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

