/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.ir.interpreter.state.reflection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.ir.declarations.IrClass;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFunction;
import ksp.org.jetbrains.kotlin.ir.declarations.IrParameterKind;
import ksp.org.jetbrains.kotlin.ir.declarations.IrProperty;
import ksp.org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import ksp.org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import ksp.org.jetbrains.kotlin.ir.expressions.IrCall;
import ksp.org.jetbrains.kotlin.ir.interpreter.state.State;
import ksp.org.jetbrains.kotlin.ir.symbols.IrSymbol;
import ksp.org.jetbrains.kotlin.ir.types.IrType;
import ksp.org.jetbrains.kotlin.ir.util.IrUtilsKt;
import ksp.org.jetbrains.kotlin.ir.util.RenderIrElementKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001c\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u001a\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000b2\b\b\u0002\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000bH\u0004J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000bH\u0004J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0004J\f\u0010\u001c\u001a\u00020\u000f*\u00020\u0012H\u0004R$\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u0005j\u0002`\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001d"}, d2={"Lksp/org/jetbrains/kotlin/ir/interpreter/state/reflection/ReflectionState;", "Lksp/org/jetbrains/kotlin/ir/interpreter/state/State;", "<init>", "()V", "fields", "", "Lksp/org/jetbrains/kotlin/ir/symbols/IrSymbol;", "Lksp/org/jetbrains/kotlin/ir/interpreter/stack/Fields;", "getFields", "()Ljava/util/Map;", "getIrFunctionByIrCall", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFunction;", "expression", "Lksp/org/jetbrains/kotlin/ir/expressions/IrCall;", "renderReceivers", "", "function", "dispatchReceiverTypeOverride", "Lksp/org/jetbrains/kotlin/ir/types/IrType;", "renderNonReceiverParameters", "irFunction", "renderEmptyParenthesis", "", "renderLambda", "renderFunction", "renderProperty", "property", "Lksp/org/jetbrains/kotlin/ir/declarations/IrProperty;", "renderType", "ir.interpreter"})
@SourceDebugExtension(value={"SMAP\nReflectionState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReflectionState.kt\norg/jetbrains/kotlin/ir/interpreter/state/reflection/ReflectionState\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n1#2:97\n295#3,2:98\n774#3:100\n865#3,2:101\n*S KotlinDebug\n*F\n+ 1 ReflectionState.kt\norg/jetbrains/kotlin/ir/interpreter/state/reflection/ReflectionState\n*L\n27#1:98,2\n44#1:100\n44#1:101,2\n*E\n"})
public abstract class ReflectionState
implements State {
    @NotNull
    private final Map<IrSymbol, State> fields = new LinkedHashMap();

    @Override
    @NotNull
    public Map<IrSymbol, State> getFields() {
        return this.fields;
    }

    @Override
    @Nullable
    public IrFunction getIrFunctionByIrCall(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        return null;
    }

    private final String renderReceivers(IrFunction function2, IrType dispatchReceiverTypeOverride) {
        StringBuilder stringBuilder;
        Object v2;
        IrType dispatchReceiver;
        block8: {
            IrType irType;
            IrValueParameter irValueParameter = function2.getDispatchReceiverParameter();
            if (irValueParameter != null) {
                IrValueParameter it = irValueParameter;
                boolean bl2 = false;
                irType = dispatchReceiverTypeOverride;
                if (irType == null) {
                    irType = it.getType();
                }
            } else {
                irType = null;
            }
            dispatchReceiver = irType;
            Iterable $this$firstOrNull$iv = function2.getParameters();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                IrValueParameter it = (IrValueParameter)element$iv;
                boolean bl3 = false;
                if (!(it.getKind() == IrParameterKind.ExtensionReceiver)) continue;
                v2 = element$iv;
                break block8;
            }
            v2 = null;
        }
        IrValueParameter irValueParameter = v2;
        IrType extensionReceiver2 = irValueParameter != null ? irValueParameter.getType() : null;
        StringBuilder $this$renderReceivers_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl4 = false;
        if (dispatchReceiver != null) {
            $this$renderReceivers_u24lambda_u242.append(this.renderType(dispatchReceiver)).append(".");
        }
        if (extensionReceiver2 != null) {
            boolean addParentheses;
            boolean bl5 = addParentheses = dispatchReceiver != null;
            if (addParentheses) {
                $this$renderReceivers_u24lambda_u242.append("(");
            }
            $this$renderReceivers_u24lambda_u242.append(this.renderType(extensionReceiver2)).append(".");
            if (addParentheses) {
                $this$renderReceivers_u24lambda_u242.append(")");
            }
        }
        return stringBuilder.toString();
    }

    static /* synthetic */ String renderReceivers$default(ReflectionState reflectionState, IrFunction irFunction, IrType irType, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: renderReceivers");
        }
        if ((n2 & 2) != 0) {
            irType = null;
        }
        return reflectionState.renderReceivers(irFunction, irType);
    }

    /*
     * WARNING - void declaration
     */
    private final String renderNonReceiverParameters(IrFunction irFunction, boolean renderEmptyParenthesis) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Iterable iterable = irFunction.getParameters();
        boolean $i$f$filter = false;
        void var6_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IrValueParameter it = (IrValueParameter)element$iv$iv;
            boolean bl2 = false;
            if (!(it.getKind() == IrParameterKind.Context || it.getKind() == IrParameterKind.Regular)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List nonReceivers = (List)destination$iv$iv;
        if (nonReceivers.isEmpty() && !renderEmptyParenthesis) {
            return "";
        }
        return CollectionsKt.joinToString$default((Iterable)nonReceivers, null, (CharSequence)"(", (CharSequence)")", (int)0, null, arg_0 -> ReflectionState.renderNonReceiverParameters$lambda$4(this, arg_0), (int)25, null);
    }

    static /* synthetic */ String renderNonReceiverParameters$default(ReflectionState reflectionState, IrFunction irFunction, boolean bl2, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: renderNonReceiverParameters");
        }
        if ((n2 & 2) != 0) {
            bl2 = true;
        }
        return reflectionState.renderNonReceiverParameters(irFunction, bl2);
    }

    @NotNull
    protected final String renderLambda(@NotNull IrFunction irFunction) {
        Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
        String receivers = ReflectionState.renderReceivers$default(this, irFunction, null, 2, null);
        String otherParameters = ReflectionState.renderNonReceiverParameters$default(this, irFunction, false, 2, null);
        String returnType2 = this.renderType(irFunction.getReturnType());
        return receivers + otherParameters + " -> " + returnType2;
    }

    @NotNull
    protected final String renderFunction(@NotNull IrFunction irFunction) {
        Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
        IrClass irClass = IrUtilsKt.getParentClassOrNull(irFunction);
        String receivers = this.renderReceivers(irFunction, irClass != null ? IrUtilsKt.getDefaultType(irClass) : null);
        String otherParameters = ReflectionState.renderNonReceiverParameters$default(this, irFunction, false, 2, null);
        String returnType2 = this.renderType(irFunction.getReturnType());
        return "fun " + receivers + irFunction.getName() + otherParameters + ": " + returnType2;
    }

    @NotNull
    protected final String renderProperty(@NotNull IrProperty property2) {
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        String prefix = property2.isVar() ? "var" : "val";
        IrSimpleFunction irSimpleFunction = property2.getGetter();
        Intrinsics.checkNotNull((Object)irSimpleFunction);
        IrSimpleFunction getter2 = irSimpleFunction;
        String receivers = ReflectionState.renderReceivers$default(this, getter2, null, 2, null);
        String contextParameters = this.renderNonReceiverParameters(getter2, false);
        String returnType2 = this.renderType(getter2.getReturnType());
        return prefix + ' ' + receivers + contextParameters + property2.getName() + ": " + returnType2;
    }

    @NotNull
    protected final String renderType(@NotNull IrType $this$renderType) {
        int index2;
        Intrinsics.checkNotNullParameter((Object)$this$renderType, (String)"<this>");
        String renderedType = StringsKt.replace$default((String)RenderIrElementKt.render$default($this$renderType, null, 1, null), (String)"<root>.", (String)"", (boolean)false, (int)4, null);
        if (StringsKt.contains$default((CharSequence)renderedType, (CharSequence)"<get-", (boolean)false, (int)2, null)) {
            int startIndex = StringsKt.indexOf$default((CharSequence)renderedType, (String)"<get-", (int)0, (boolean)false, (int)6, null);
            int lastTriangle = StringsKt.indexOf$default((CharSequence)renderedType, (char)'>', (int)startIndex, (boolean)false, (int)4, null) + 1;
            String string = renderedType;
            CharSequence charSequence = "get";
            renderedType = ((Object)StringsKt.replaceRange((CharSequence)string, (int)startIndex, (int)lastTriangle, (CharSequence)charSequence)).toString();
        }
        while ((index2 = StringsKt.indexOf$default((CharSequence)renderedType, (String)" of ", (int)0, (boolean)false, (int)6, null)) != -1) {
            int replaceUntilComma = StringsKt.indexOf$default((CharSequence)renderedType, (char)',', (int)index2, (boolean)false, (int)4, null);
            int replaceUntilTriangle = StringsKt.indexOf$default((CharSequence)renderedType, (char)'>', (int)index2, (boolean)false, (int)4, null);
            int replaceUntil = replaceUntilComma == -1 && replaceUntilTriangle == -1 ? renderedType.length() : (replaceUntilComma == -1 ? replaceUntilTriangle : (replaceUntilTriangle == -1 ? replaceUntilComma : Math.min(replaceUntilComma, replaceUntilTriangle)));
            String string = renderedType;
            CharSequence charSequence = "";
            renderedType = ((Object)StringsKt.replaceRange((CharSequence)string, (int)index2, (int)replaceUntil, (CharSequence)charSequence)).toString();
        }
        return renderedType;
    }

    private static final CharSequence renderNonReceiverParameters$lambda$4(ReflectionState this$0, IrValueParameter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.renderType(it.getType());
    }
}

